/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Commands;

import at.pcgamingfreaks.MarriageMaster.Bungee.API.CommandManager;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Commands.ChatCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Commands.HomeCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Commands.TpCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Commands.UpdateCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Command.CommandExecutorWithSubCommandsGeneric;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManagerImplementation
extends CommandExecutorWithSubCommandsGeneric<MarryCommand>
implements Listener,
CommandManager {
    private final MarriageMaster plugin;
    private final HashSet<String> commandAliases = new HashSet();
    private String[] switchesOn;
    private String[] switchesOff;
    private String[] switchesToggle;
    private String[] switchesAll;
    private String[] switchesRemove;
    private Message helpFormat;

    public CommandManagerImplementation(MarriageMaster plugin) {
        this.plugin = plugin;
    }

    public void init() {
        this.switchesOn = this.plugin.getLanguage().getSwitch("On", "on");
        this.switchesOff = this.plugin.getLanguage().getSwitch("Off", "off");
        this.switchesToggle = this.plugin.getLanguage().getSwitch("Toggle", "toggle");
        this.switchesAll = this.plugin.getLanguage().getSwitch("All", "all");
        this.switchesRemove = this.plugin.getLanguage().getSwitch("Remove", "remove");
        this.commandAliases.add("marry");
        for (String alias : this.plugin.getLanguage().getCommandAliases("marry")) {
            this.commandAliases.add(alias.toLowerCase());
        }
        this.plugin.getProxy().getPluginManager().registerListener((Plugin)this.plugin, (Listener)this);
        this.helpFormat = (Message)((Message)((Message)((Message)this.plugin.getLanguage().getMessage("Commands.HelpFormat").placeholder("MainCommand")).placeholder("SubCommand")).placeholder("Parameters")).placeholder("Description");
        try {
            Reflection.setStaticField(MarryCommand.class, "showHelp", this.getClass().getDeclaredMethod("sendHelp", CommandSender.class, String.class, Collection.class));
            Reflection.setStaticField(MarryCommand.class, "marriagePlugin", this.plugin);
            Reflection.setStaticField(MarryCommand.class, "messageNoPermission", this.plugin.messageNoPermission);
            Reflection.setStaticField(MarryCommand.class, "messageNotMarried", this.plugin.messageNotMarried);
            Reflection.setStaticField(MarryCommand.class, "messageNotFromConsole", this.plugin.messageNotFromConsole);
            Reflection.setStaticField(MarryCommand.class, "helpPartnerSelector", "<" + this.plugin.helpPartnerNameVariable + ">");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, (Object)((Object)ConsoleColor.RED) + "Unable to set the help format. Default format will be used." + (Object)((Object)ConsoleColor.RESET), e);
        }
        if (this.plugin.getConfig().isChatHandlerEnabled()) {
            this.registerSubCommand(new ChatCommand(this.plugin));
        }
        if (this.plugin.getConfig().isTPHandlerEnabled()) {
            this.registerSubCommand(new TpCommand(this.plugin));
        }
        if (this.plugin.getConfig().isHomeHandlerEnabled()) {
            this.registerSubCommand(new HomeCommand(this.plugin));
        }
        if (this.plugin.getConfig().useUpdater()) {
            this.registerSubCommand(new UpdateCommand(this.plugin));
        }
    }

    @Override
    public void close() {
        this.plugin.getProxy().getPluginManager().unregisterListener((Listener)this);
        super.close();
    }

    public void sendHelp(CommandSender target, String marryAlias, Collection<HelpData> data) {
        for (HelpData d : data) {
            this.helpFormat.send(target, marryAlias, d.getTranslatedSubCommand(), d.getParameter(), d.getDescription());
        }
    }

    @EventHandler(priority=-64)
    public void onChat(ChatEvent event) {
        MarryCommand mC;
        String[] args;
        String cmd;
        if (event.isCommand() && this.commandAliases.contains(cmd = (args = event.getMessage().split("\\s+"))[0].toLowerCase().substring(1)) && args.length > 1 && (args = Arrays.copyOfRange(args, 1, args.length)).length > 0 && (mC = (MarryCommand)this.subCommandMap.get(args[0].toLowerCase())) != null) {
            mC.doExecute((CommandSender)event.getSender(), cmd, args[0], args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            event.setCancelled(true);
        }
    }

    @Override
    public boolean isOnSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesOn, str);
    }

    @Override
    public boolean isOffSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesOff, str);
    }

    @Override
    public boolean isToggleSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesToggle, str);
    }

    @Override
    public boolean isAllSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesAll, str);
    }

    @Override
    public boolean isRemoveSwitch(@Nullable String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesRemove, str);
    }

    @Override
    @NotNull
    public String getOnSwitchTranslation() {
        return this.switchesOn[0];
    }

    @Override
    @NotNull
    public String getOffSwitchTranslation() {
        return this.switchesOff[0];
    }

    @Override
    @NotNull
    public String getToggleSwitchTranslation() {
        return this.switchesToggle[0];
    }

    @Override
    @NotNull
    public String getAllSwitchTranslation() {
        return this.switchesAll[0];
    }

    @Override
    @NotNull
    public String getRemoveSwitchTranslation() {
        return this.switchesRemove[0];
    }

    @Override
    @Nullable
    public List<String> getSimpleTabComplete(@NotNull CommandSender sender, String ... args) {
        List<String> names = null;
        if (sender instanceof ProxiedPlayer && this.plugin.areMultiplePartnersAllowed() && args != null && args.length == 1 && (names = this.plugin.getPlayerData((ProxiedPlayer)sender).getMatchingPartnerNames(args[0])).isEmpty()) {
            names = null;
        }
        return names;
    }
}

