/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Commands;

import at.pcgamingfreaks.MarriageMaster.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.Marriage;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Commands.CommandManagerImplementation;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageFormat;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;

public class ChatCommand
extends MarryCommand
implements Listener {
    private final Message messageJoined;
    private final Message messageLeft;
    private final Message messageListeningStarted;
    private final Message messageListeningStopped;
    private final Message privateMessageFormat;
    private final Message messageTargetSet;
    private final String displayNameAll;
    private final String helpText;
    private LinkedList<ProxiedPlayer> listeners = new LinkedList();
    private MarryCommand chatToggleCommand;
    private MarryCommand chatListenCommand;
    private final String[] setTargetParameters;

    public ChatCommand(@NotNull MarriageMaster plugin) {
        super((Plugin)plugin, "chat", plugin.getLanguage().getTranslated("Commands.Description.Chat"), "marry.chat", true, true, plugin.getLanguage().getCommandAliases("Chat"));
        this.messageJoined = plugin.getLanguage().getMessage("Ingame.Chat.Joined");
        this.messageLeft = plugin.getLanguage().getMessage("Ingame.Chat.Left");
        this.messageListeningStarted = plugin.getLanguage().getMessage("Ingame.Chat.ListeningStarted");
        this.messageListeningStopped = plugin.getLanguage().getMessage("Ingame.Chat.ListeningStopped");
        this.messageTargetSet = plugin.getLanguage().getMessage("Ingame.Chat.TargetSet");
        this.privateMessageFormat = (Message)((Message)((Message)((Message)((Message)((Message)plugin.getLanguage().getMessage("Ingame.Chat.Format").placeholder("SenderDisplayName")).placeholder("ReceiverDisplayName")).placeholder("Message")).placeholder("SenderName")).placeholder("ReceiverName")).placeholder("MagicHeart");
        this.displayNameAll = plugin.getLanguage().getTranslated("Ingame.Chat.DisplayNameAll");
        this.helpText = "<" + plugin.getLanguage().getTranslated("Commands.MessageVariable") + ">";
        this.setTargetParameters = plugin.getLanguage().getCommandAliases("ChatSetTarget");
        plugin.getProxy().getPluginManager().registerListener((Plugin)plugin, (Listener)this);
    }

    @Override
    public void afterRegister() {
        this.chatToggleCommand = new ChatToggleCommand((MarriageMaster)this.getMarriagePlugin(), this);
        ((CommandManagerImplementation)this.getMarriagePlugin().getCommandManager()).registerSubCommand(this.chatToggleCommand);
        this.chatListenCommand = new ChatListenCommand((MarriageMaster)this.getMarriagePlugin(), this);
        ((CommandManagerImplementation)this.getMarriagePlugin().getCommandManager()).registerSubCommand(this.chatListenCommand);
    }

    @Override
    public void beforeUnregister() {
        ((CommandManagerImplementation)this.getMarriagePlugin().getCommandManager()).registerSubCommand(this.chatToggleCommand);
        this.chatToggleCommand.close();
        ((CommandManagerImplementation)this.getMarriagePlugin().getCommandManager()).registerSubCommand(this.chatListenCommand);
        this.chatListenCommand.close();
    }

    @Override
    public void close() {
        this.listeners.clear();
        this.listeners = null;
        if (this.chatToggleCommand != null) {
            this.chatToggleCommand.close();
            this.chatToggleCommand = null;
        }
        if (this.chatListenCommand != null) {
            this.chatListenCommand.close();
            this.chatListenCommand = null;
        }
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String s1, @NotNull String[] args) {
        at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer player = (at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer)this.getMarriagePlugin().getPlayerData((ProxiedPlayer)sender);
        if (args.length == 0) {
            this.showHelp(sender, mainCommandAlias);
        } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isToggleSwitch(args[0])) {
            this.toggleChatSetting(player);
        } else if (this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2 && StringUtils.arrayContainsIgnoreCase(this.setTargetParameters, args[0])) {
            ProxiedPlayer target = this.plugin.getProxy().getPlayer(args[1]);
            if (target != null && player.isPartner(target)) {
                player.setPrivateChatTarget(this.getMarriagePlugin().getPlayerData(target));
                this.messageTargetSet.send(sender, new Object[0]);
            } else {
                ((MarriageMaster)this.getMarriagePlugin()).messageTargetPartnerNotFound.send(sender, new Object[0]);
            }
        } else if (player.getPrivateChatTarget() == null || ((at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer)((Marriage)player.getPrivateChatTarget()).getPartner(player)).isOnline()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(args[i]);
            }
            this.doChat(player, stringBuilder.toString());
        } else {
            ((MarriageMaster)this.getMarriagePlugin()).messagePartnerOffline.send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String s, @NotNull String s1, @NotNull String[] args) {
        List<String> data = new LinkedList<String>();
        if (args.length > 0) {
            if (args.length == 2 && StringUtils.arrayContainsIgnoreCase(this.setTargetParameters, args[0])) {
                at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer player = (at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer)this.getMarriagePlugin().getPlayerData((ProxiedPlayer)sender);
                data = player.getMatchingPartnerNames(args[1]);
            } else {
                String arg = args[args.length - 1].toLowerCase(Locale.ENGLISH);
                for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
                    if (!player.getName().toLowerCase(Locale.ENGLISH).startsWith(arg)) continue;
                    data.add(player.getName());
                }
            }
        }
        return data.isEmpty() ? null : data;
    }

    @Override
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        LinkedList<HelpData> help = new LinkedList<HelpData>();
        help.add(new HelpData(this.getTranslatedName(), "<" + this.helpText + ">", this.getDescription()));
        if (this.getMarriagePlugin().areMultiplePartnersAllowed()) {
            help.add(new HelpData(this.getTranslatedName() + " " + this.setTargetParameters[0], "<" + ((MarriageMaster)this.getMarriagePlugin()).helpPartnerNameVariable + " / " + ((CommandManager)this.getMarriagePlugin().getCommandManager()).getAllSwitchTranslation() + ">", this.getDescription()));
        }
        return help;
    }

    @EventHandler(priority=32)
    public void onChat(ChatEvent event) {
        if (!(event.getSender() instanceof ProxiedPlayer) || event.isCommand()) {
            return;
        }
        at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer player = (at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer)this.getMarriagePlugin().getPlayerData((ProxiedPlayer)event.getSender());
        if (player.isPrivateChatDefault()) {
            event.setCancelled(true);
            this.doChat(player, event.getMessage());
        }
    }

    @EventHandler(priority=-64)
    public void onLeave(PlayerDisconnectEvent event) {
        this.listeners.remove(event.getPlayer());
    }

    private void toggleChatSetting(at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer player) {
        if (player.isPrivateChatDefault()) {
            player.setPrivateChatDefault(false);
            player.send(this.messageLeft, new Object[0]);
        } else {
            player.setPrivateChatDefault(true);
            player.send(this.messageJoined, new Object[0]);
        }
    }

    private void toggleListenChat(ProxiedPlayer player, boolean on) {
        if (on) {
            this.messageListeningStarted.send((CommandSender)player, new Object[0]);
            this.listeners.add(player);
        } else {
            this.messageListeningStopped.send((CommandSender)player, new Object[0]);
            this.listeners.remove(player);
        }
    }

    private void toggleListenChat(ProxiedPlayer player) {
        this.toggleListenChat(player, !this.listeners.contains(player));
    }

    private void doChat(at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer sender, String msg) {
        LinkedList<Marriage> recipients = new LinkedList<Marriage>();
        ProxiedPlayer recipient = null;
        if (sender.getPrivateChatTarget() == null) {
            MarriagePlayer last = null;
            for (Object m : sender.getMultiMarriageData()) {
                at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer p = (at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer)m.getPartner(sender);
                if (p == null || !p.isOnline() || p.getPlayerOnline() == null) continue;
                last = p;
                recipients.add((Marriage)m);
            }
            if (recipients.size() == 1) {
                recipient = (ProxiedPlayer)last.getPlayerOnline();
            }
        } else {
            at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer player2 = (at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer)sender.getPartner();
            if (player2 != null && player2.isOnline()) {
                recipient = (ProxiedPlayer)player2.getPlayer();
                recipients.add((Marriage)sender.getPrivateChatTarget());
            }
        }
        ProxiedPlayer player = (ProxiedPlayer)sender.getPlayer();
        if (!recipients.isEmpty()) {
            msg = msg.replace('\u00a7', '&');
            if (player.hasPermission("marry.chat.color")) {
                msg = MessageColor.translateAlternateColorCodes(msg);
            }
            if (player.hasPermission("marry.chat.format")) {
                msg = MessageFormat.translateAlternateFormatCodes(msg);
            }
            msg = player.hasPermission("marry.chat.magic") ? msg.replace("&k", MessageFormat.MAGIC.toString()) : msg.replace(MessageFormat.MAGIC.toString(), "&k");
            ArrayList<Object> playerRecipients = new ArrayList<Object>(this.listeners.size() + recipients.size() + 1);
            playerRecipients.addAll(this.listeners);
            playerRecipients.add(player);
            if (recipient == null) {
                for (Marriage target : recipients) {
                    playerRecipients.add(((at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer)target.getPartner(sender)).getPlayer());
                }
            } else {
                playerRecipients.add(recipient);
            }
            String magicHeart = "266\u2764\u00a7f";
            if (recipients.size() == 1) {
                magicHeart = ((Marriage)recipients.get(0)).getMagicHeart();
            }
            this.privateMessageFormat.send(playerRecipients, player.getDisplayName(), recipient != null ? recipient.getDisplayName() : this.displayNameAll, msg, player.getName(), recipient != null ? recipient.getName() : this.displayNameAll, magicHeart);
        } else {
            ((MarriageMaster)this.getMarriagePlugin()).messagePartnerOffline.send((CommandSender)player, new Object[0]);
        }
    }

    public static class ChatListenCommand
    extends MarryCommand {
        private ChatCommand chatCommand;

        public ChatListenCommand(MarriageMaster plugin, ChatCommand chatCommand) {
            super((Plugin)plugin, "listenchat", plugin.getLanguage().getTranslated("Commands.Description.ChatListen"), "marry.listenchat", true, plugin.getLanguage().getCommandAliases("ChatListen"));
            this.chatCommand = chatCommand;
        }

        @Override
        public void execute(@NotNull CommandSender cmdSender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            ProxiedPlayer sender = (ProxiedPlayer)cmdSender;
            if (args.length == 1) {
                if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isToggleSwitch(args[0])) {
                    this.chatCommand.toggleListenChat(sender);
                } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isOnSwitch(args[0])) {
                    this.chatCommand.toggleListenChat(sender);
                } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isOffSwitch(args[0])) {
                    this.chatCommand.toggleListenChat(sender);
                } else {
                    this.showHelp((CommandSender)sender, mainCommandAlias);
                }
            } else {
                this.chatCommand.toggleListenChat(sender);
            }
        }

        @Override
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            return null;
        }

        @Override
        public void close() {
            this.chatCommand = null;
        }
    }

    public static class ChatToggleCommand
    extends MarryCommand {
        private ChatCommand chatCommand;

        public ChatToggleCommand(MarriageMaster plugin, ChatCommand chatCommand) {
            super((Plugin)plugin, "chattoggle", plugin.getLanguage().getTranslated("Commands.Description.ChatToggle"), "marry.chat", true, plugin.getLanguage().getCommandAliases("ChatToggle"));
            this.chatCommand = chatCommand;
        }

        @Override
        public void close() {
            this.chatCommand = null;
        }

        @Override
        public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            this.chatCommand.toggleChatSetting((at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer)this.getMarriagePlugin().getPlayerData((ProxiedPlayer)sender));
        }

        @Override
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            return null;
        }

        @Override
        public List<HelpData> getHelp(@NotNull CommandSender requester) {
            return null;
        }
    }
}

