/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder;

import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Hooks.ClipsPlaceholderHook;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Hooks.MVdWPlaceholderReplacer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Hooks.PlaceholderAPIHook;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.PlaceholderFormatted;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.PlaceholderReplacer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.HasHome;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.Heart;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.Home;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.HomeCoordinates;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.HomeWorld;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.HomeX;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.HomeY;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.HomeZ;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.IsInRange;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.IsMarried;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.IsPriest;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MagicHeart;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestHasHome;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestHome;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestHomeCoordinates;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestHomeWorld;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestHomeX;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestHomeY;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestHomeZ;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestPartnerDisplayName;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestPartnerName;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestPrefix;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestSuffix;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.NearestSurname;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.PartnerDisplayNameId;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.PartnerDisplayNameList;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.PartnerList;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.MultiPartner.PartnerNameId;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.PartnerCount;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.PartnerDisplayName;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.PartnerName;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.Prefix;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.StatusHeart;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.Suffix;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.Replacer.Surname;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Range;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlaceholderManager {
    private static MVdWPlaceholderReplacer mVdWPlaceholderReplacer = null;
    private final MarriageMaster plugin;
    private final Map<String, PlaceholderReplacer> placeholders = new TreeMap<String, PlaceholderReplacer>(String.CASE_INSENSITIVE_ORDER);
    private final List<PlaceholderAPIHook> hooks = new ArrayList<PlaceholderAPIHook>(2);
    private final List<String> placeholdersList = new ArrayList<String>();

    public PlaceholderManager(MarriageMaster plugin) {
        this.plugin = plugin;
        if (!PlaceholderManager.isPluginEnabled("MVdWPlaceholderAPI") && !PlaceholderManager.isPluginEnabled("PlaceholderAPI")) {
            return;
        }
        this.generatePlaceholdersMap();
        if (PlaceholderManager.isPluginEnabled("MVdWPlaceholderAPI")) {
            if (mVdWPlaceholderReplacer == null) {
                mVdWPlaceholderReplacer = new MVdWPlaceholderReplacer(plugin, this);
            } else {
                mVdWPlaceholderReplacer.set(plugin, this);
            }
            this.hooks.add(mVdWPlaceholderReplacer);
        }
        if (PlaceholderManager.isPluginEnabled("PlaceholderAPI")) {
            this.hooks.add(new ClipsPlaceholderHook(plugin, this));
        }
    }

    private static boolean isPluginEnabled(String pluginName) {
        return Bukkit.getPluginManager().isPluginEnabled(pluginName);
    }

    public void close() {
        for (PlaceholderAPIHook hook : this.hooks) {
            hook.close();
        }
        this.hooks.clear();
        this.placeholdersList.clear();
        this.placeholders.clear();
    }

    public Map<String, PlaceholderReplacer> getPlaceholders() {
        return this.placeholders;
    }

    public String replacePlaceholder(OfflinePlayer player, String identifier) {
        if (player == null) {
            return "Player needed!";
        }
        PlaceholderReplacer replacer = this.placeholders.get(identifier);
        return replacer == null ? null : replacer.replace(player);
    }

    private void generatePlaceholdersMap() {
        this.registerPlaceholder(new HasHome(this.plugin));
        this.registerPlaceholder(new Heart(this.plugin));
        this.registerPlaceholder(new Home(this.plugin));
        this.registerPlaceholder(new HomeCoordinates(this.plugin));
        this.registerPlaceholder(new HomeWorld(this.plugin));
        this.registerPlaceholder(new HomeX(this.plugin));
        this.registerPlaceholder(new HomeY(this.plugin));
        this.registerPlaceholder(new HomeZ(this.plugin));
        this.registerPlaceholder(new IsMarried(this.plugin));
        this.registerPlaceholder(new IsPriest(this.plugin));
        this.registerPlaceholder(new PartnerCount(this.plugin));
        this.registerPlaceholder(new PartnerDisplayName(this.plugin));
        this.registerPlaceholder(new PartnerName(this.plugin));
        this.registerPlaceholder(new Prefix(this.plugin));
        this.registerPlaceholder(new Suffix(this.plugin));
        this.registerPlaceholder(new Surname(this.plugin));
        this.registerPlaceholder(new StatusHeart(this.plugin));
        this.registerPlaceholder(new MagicHeart(this.plugin));
        for (Range range : Range.values()) {
            if (range == Range.Marry) continue;
            this.registerPlaceholder(new IsInRange(this.plugin, range));
        }
        if (this.plugin.areMultiplePartnersAllowed()) {
            this.registerPlaceholder(new NearestPrefix(this.plugin));
            this.registerPlaceholder(new NearestSuffix(this.plugin));
            this.registerPlaceholder(new NearestPartnerName(this.plugin));
            this.registerPlaceholder(new NearestPartnerDisplayName(this.plugin));
            this.registerPlaceholder(new NearestSurname(this.plugin));
            this.registerPlaceholder(new NearestHasHome(this.plugin));
            this.registerPlaceholder(new NearestHome(this.plugin));
            this.registerPlaceholder(new NearestHomeCoordinates(this.plugin));
            this.registerPlaceholder(new NearestHomeX(this.plugin));
            this.registerPlaceholder(new NearestHomeY(this.plugin));
            this.registerPlaceholder(new NearestHomeZ(this.plugin));
            this.registerPlaceholder(new NearestHomeWorld(this.plugin));
            this.registerPlaceholder(new PartnerList(this.plugin));
            this.registerPlaceholder(new PartnerDisplayNameList(this.plugin));
            for (int i = 0; i < 10; ++i) {
                this.registerPlaceholder(new PartnerNameId(this.plugin, i));
                this.registerPlaceholder(new PartnerDisplayNameId(this.plugin, i));
            }
        }
    }

    public void registerPlaceholder(PlaceholderReplacer placeholder) {
        if (placeholder.getClass().isAnnotationPresent(PlaceholderFormatted.class)) {
            try {
                PlaceholderFormatted pfa = placeholder.getClass().getAnnotation(PlaceholderFormatted.class);
                if (placeholder.getFormat() != null && placeholder.getFormat().matches(pfa.formatRuleDetectionRegex())) {
                    placeholder = (PlaceholderReplacer)Reflection.getConstructor(pfa.formattedClass(), MarriageMaster.class).newInstance(this.plugin);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to register placeholder '" + placeholder.getName() + "'!", e);
                return;
            }
        }
        this.placeholders.put(placeholder.getName(), placeholder);
        PlaceholderReplacer finalPlaceholder = placeholder;
        placeholder.getAliases().forEach(alias -> this.placeholders.put((String)alias, finalPlaceholder));
    }

    public List<String> getPlaceholdersList() {
        if (this.placeholdersList.isEmpty()) {
            for (String key : this.placeholders.keySet()) {
                this.placeholdersList.add(this.plugin.getDescription().getName() + '_' + key);
            }
        }
        return this.placeholdersList;
    }

    public void testPlaceholders(@NotNull BufferedWriter writer) throws IOException {
        for (PlaceholderAPIHook hook : this.hooks) {
            hook.testPlaceholders(writer);
        }
    }
}

