/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.DelayableTeleportAction;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarriageMasterReloadEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriageMasterPlugin;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.PrefixSuffixFormatter;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.BackpackIntegration.BackpackIntegrationManager;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.BackpackIntegration.IBackpackIntegration;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.CommandManagerImplementation;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.Config;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.Database;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.Language;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.MarriagePlayerData;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Formatter.PrefixSuffixFormatterImpl;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.BonusXP.BonusXpListener;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.BonusXP.BonusXpSplitOnPickupListener;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.BonusXP.McMMOBonusXpListener;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.BonusXP.McMMOClassicBonusXpListener;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.BonusXP.SkillApiBonusXpListener;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.ChatPrefixSuffix;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.CommandExecutor;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.EconomyHandler;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.JoinLeaveInfo;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.JoinLeaveWorker;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.OpenRequestCloser;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.PluginChannelCommunicator;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener.RegainHealth;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Management.MarriageManager;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Placeholder.PlaceholderManager;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.SpecialInfoWorker.NoDatabaseWorker;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.ManagedUpdater;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.Utils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Plugin.IPlugin;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.UUIDConverter;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MarriageMaster
extends JavaPlugin
implements MarriageMasterPlugin,
IPlugin {
    private static Version version = null;
    private static MarriageMaster instance;
    private ManagedUpdater updater;
    private Config config = null;
    private Language language = null;
    private Database database = null;
    private IBackpackIntegration backpacksIntegration = null;
    private PluginChannelCommunicator pluginChannelCommunicator = null;
    private PrefixSuffixFormatter prefixSuffixFormatter = null;
    private CommandManagerImplementation commandManager = null;
    private MarriageManager marriageManager = null;
    private PlaceholderManager placeholderManager = null;
    private boolean selfMarriageAllowed = false;
    private boolean selfDivorceAllowed = false;
    private boolean surnamesEnabled = false;
    private boolean surnamesForced = false;
    private boolean multiplePartnersAllowed = false;

    public void onEnable() {
        this.updater = new ManagedUpdater(this);
        MarriageMaster.setInstance(this);
        MarriageMaster.setVersion(new Version(this.getDescription().getVersion()));
        Utils.warnIfPerWorldPluginsIsInstalled(this.getLogger());
        this.getLogger().info("Starting Marriage Master in standalone mode!");
        if (this.getServer().getPluginManager().isPluginEnabled("PCGF_PluginLib")) {
            this.getLogger().info("You do have the PCGF_PluginLib installed. You may consider switching to the default version of the plugin to reduce memory load and unlock additional features.");
        }
        this.config = new Config(this);
        if (!this.config.isLoaded()) {
            this.failedToEnablePlugin();
            return;
        }
        this.updater.setChannel(this.config.getUpdateChannel());
        if (this.config.useUpdater()) {
            this.updater.update();
        }
        this.language = new Language(this);
        BackpackIntegrationManager.initIntegration();
        this.backpacksIntegration = BackpackIntegrationManager.getIntegration();
        if (!this.load()) {
            this.failedToEnablePlugin();
            return;
        }
        this.getLogger().info(StringUtils.getPluginEnabledMessage("Marriage Master"));
    }

    private void failedToEnablePlugin() {
        this.getLogger().info((Object)((Object)ConsoleColor.RED) + "Failed to enable the plugin!" + (Object)((Object)ConsoleColor.YELLOW) + " :( " + (Object)((Object)ConsoleColor.RESET));
        this.setEnabled(false);
        MarriageMaster.setInstance(null);
    }

    public void onDisable() {
        if (this.config != null && this.config.isLoaded() && this.database != null) {
            if (this.config.useUpdater()) {
                this.updater.update();
            }
            this.unload();
        }
        MarriageMaster.setInstance(null);
        this.updater.waitForAsyncOperation();
        this.getLogger().info(StringUtils.getPluginDisabledMessage("Marriage Master"));
    }

    public void reload() {
        this.unload();
        this.config.reload();
        this.load();
        this.getServer().getPluginManager().callEvent((Event)new MarriageMasterReloadEvent());
    }

    private boolean load() {
        if (!this.config.isLoaded() || !this.language.load(this.config)) {
            this.getLogger().warning((Object)((Object)ConsoleColor.RED) + "Configuration or language file not loaded correct! Disabling plugin." + (Object)((Object)ConsoleColor.RESET));
            this.setEnabled(false);
            return false;
        }
        this.updater.setChannel(this.config.getUpdateChannel());
        this.loadGlobalSettings();
        this.database = new Database(this);
        if (!this.database.available()) {
            this.getLogger().warning((Object)((Object)ConsoleColor.RED) + "Failed to connect to database! Please adjust your settings and retry!" + (Object)((Object)ConsoleColor.RESET));
            new NoDatabaseWorker(this);
            return true;
        }
        if (this.database.useBungee()) {
            this.pluginChannelCommunicator = new PluginChannelCommunicator(this);
        }
        CommonMessages.loadCommonMessages(this.language);
        this.commandManager = new CommandManagerImplementation(this);
        this.commandManager.init();
        this.marriageManager = new MarriageManager(this);
        this.prefixSuffixFormatter = new PrefixSuffixFormatterImpl(this);
        this.registerEvents();
        this.placeholderManager = new PlaceholderManager(this);
        return true;
    }

    void loadGlobalSettings() {
        this.surnamesEnabled = this.config.isSurnamesEnabled();
        this.multiplePartnersAllowed = this.config.areMultiplePartnersAllowed();
        this.selfMarriageAllowed = this.config.isSelfMarriageAllowed();
        this.selfDivorceAllowed = this.config.isSelfDivorceAllowed();
        this.surnamesForced = this.config.isSurnamesForced() && this.surnamesEnabled;
    }

    void registerEvents() {
        Plugin mcMMO;
        this.getServer().getPluginManager().registerEvents((Listener)new JoinLeaveWorker(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OpenRequestCloser(), (Plugin)this);
        if (this.config.isBonusXPEnabled()) {
            if (this.config.getBonusXpMultiplier() > 1.0) {
                this.getServer().getPluginManager().registerEvents((Listener)new BonusXpListener(this), (Plugin)this);
            }
            if (this.config.isBonusXPSplitOnPickupEnabled()) {
                this.getServer().getPluginManager().registerEvents((Listener)new BonusXpSplitOnPickupListener(this), (Plugin)this);
            }
        }
        if (this.config.isSkillApiBonusXPEnabled() && this.getServer().getPluginManager().isPluginEnabled("SkillAPI")) {
            this.getServer().getPluginManager().registerEvents((Listener)new SkillApiBonusXpListener(this), (Plugin)this);
        }
        if (this.config.isMcMMOBonusXPEnabled() && this.getServer().getPluginManager().isPluginEnabled("mcMMO") && (mcMMO = this.getServer().getPluginManager().getPlugin("mcMMO")) != null) {
            if (new Version(mcMMO.getDescription().getVersion()).olderThan(new Version("2"))) {
                this.getServer().getPluginManager().registerEvents((Listener)new McMMOClassicBonusXpListener(this), (Plugin)this);
            } else {
                this.getServer().getPluginManager().registerEvents((Listener)new McMMOBonusXpListener(this), (Plugin)this);
            }
        }
        if (this.config.isHPRegainEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new RegainHealth(this), (Plugin)this);
        }
        if (this.config.isJoinLeaveInfoEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new JoinLeaveInfo(this), (Plugin)this);
        }
        if (this.config.isEconomyEnabled()) {
            new EconomyHandler(this);
        }
        if (this.config.isCommandExecutorEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new CommandExecutor(this), (Plugin)this);
        }
        if (this.getConfiguration().isPrefixEnabled() || this.getConfiguration().isSuffixEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new ChatPrefixSuffix(this), (Plugin)this);
        }
    }

    private void unload() {
        this.placeholderManager.close();
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        if (this.pluginChannelCommunicator != null) {
            this.pluginChannelCommunicator.close();
            this.pluginChannelCommunicator = null;
        }
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        this.database.close();
        this.database = null;
        this.commandManager.close();
        this.marriageManager.close();
    }

    public Config getConfiguration() {
        return this.config;
    }

    public static Version version() {
        return version;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return version;
    }

    @Override
    public boolean areMultiplePartnersAllowed() {
        return this.multiplePartnersAllowed;
    }

    @Override
    @NotNull
    public MarriagePlayer getPlayerData(@NotNull UUID uuid) {
        return this.database.getPlayer(uuid);
    }

    @Override
    @NotNull
    public MarriagePlayer getPlayerData(@NotNull String name) {
        Player player = this.getServer().getPlayer(name);
        if (player != null) {
            return this.getPlayerData((OfflinePlayer)player);
        }
        MarriagePlayerData data = (MarriagePlayerData)this.getPlayerData(UUIDConverter.getUUIDCacheOnly(name, true));
        data.setName(name);
        return data;
    }

    @Override
    @NotNull
    public MarriagePlayer getPlayerData(@NotNull OfflinePlayer player) {
        return this.database.getPlayer(player);
    }

    @Override
    @NotNull
    public Collection<? extends Marriage> getMarriages() {
        return this.database.getCache().getLoadedMarriages();
    }

    @Override
    public boolean isInRange(@NotNull Player player1, @NotNull Player player2, double range) {
        return Utils.inRange(player1, player2, range, "marry.bypass.rangelimit");
    }

    @Override
    public boolean isInRangeSquared(@NotNull Player player1, @NotNull Player player2, double rangeSquared) {
        return Utils.inRangeSquared(player1, player2, rangeSquared, "marry.bypass.rangelimit");
    }

    @Override
    public void doDelayableTeleportAction(@NotNull DelayableTeleportAction action) {
        if (action.getDelay() == 0L || ((MarriagePlayer)action.getPlayer()).hasPermission("marry.bypass.delay")) {
            action.run();
        } else {
            Player player = (Player)((MarriagePlayer)action.getPlayer()).getPlayerOnline();
            MarriagePlayerData playerData = (MarriagePlayerData)action.getPlayer();
            if (((MarriagePlayer)action.getPlayer()).isOnline() && player != null) {
                Location oldLocation = player.getLocation();
                double oldHealth = player.getHealth();
                CommonMessages.getMessageDontMove().send((CommandSender)player, action.getDelay() / 20L);
                if (playerData.getDelayedTpTask() != null) {
                    playerData.getDelayedTpTask().cancel();
                }
                playerData.setDelayedTpTask(this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                    playerData.setDelayedTpTask(null);
                    if (((MarriagePlayer)action.getPlayer()).isOnline()) {
                        if (oldHealth <= player.getHealth() && oldLocation.getX() == player.getLocation().getX() && oldLocation.getY() == player.getLocation().getY() && oldLocation.getZ() == player.getLocation().getZ() && oldLocation.getWorld().getName().equalsIgnoreCase(player.getLocation().getWorld().getName())) {
                            action.run();
                        } else {
                            CommonMessages.getMessageMoved().send((CommandSender)player, new Object[0]);
                        }
                    }
                }, action.getDelay()));
            }
        }
    }

    @Override
    @NotNull
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    @NotNull
    public at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriageManager getMarriageManager() {
        return this.marriageManager;
    }

    @Override
    @NotNull
    public Collection<? extends MarriagePlayer> getPriestsOnline() {
        ArrayList<MarriagePlayer> priests = new ArrayList<MarriagePlayer>();
        for (Player player : this.getServer().getOnlinePlayers()) {
            MarriagePlayer marriagePlayer = this.getPlayerData((OfflinePlayer)player);
            if (!marriagePlayer.isPriest()) continue;
            priests.add(marriagePlayer);
        }
        return priests;
    }

    @Override
    @NotNull
    public Collection<? extends MarriagePlayer> getPriests() {
        return this.database.getCache().getLoadedPlayers().stream().filter(MarriagePlayerDataBase::isPriest).collect(Collectors.toList());
    }

    private static void setVersion(Version version) {
        MarriageMaster.version = version;
    }

    public static MarriageMaster getInstance() {
        return instance;
    }

    private static void setInstance(MarriageMaster instance) {
        MarriageMaster.instance = instance;
    }

    public ManagedUpdater getUpdater() {
        return this.updater;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Database getDatabase() {
        return this.database;
    }

    public IBackpackIntegration getBackpacksIntegration() {
        return this.backpacksIntegration;
    }

    public PluginChannelCommunicator getPluginChannelCommunicator() {
        return this.pluginChannelCommunicator;
    }

    @Override
    public PrefixSuffixFormatter getPrefixSuffixFormatter() {
        return this.prefixSuffixFormatter;
    }

    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    @Override
    public boolean isSelfMarriageAllowed() {
        return this.selfMarriageAllowed;
    }

    @Override
    public boolean isSelfDivorceAllowed() {
        return this.selfDivorceAllowed;
    }

    @Override
    public boolean isSurnamesEnabled() {
        return this.surnamesEnabled;
    }

    @Override
    public boolean isSurnamesForced() {
        return this.surnamesForced;
    }
}

