/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Management.Requests;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarriedEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarryEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.MarriageData;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Management.MarriageManager;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Placeholder.Placeholders;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender.SendMethod;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfMarryAcceptRequest
extends AcceptPendingRequest {
    private static Message messageSelfBroadcastMarriage;
    private static Message messageSelfMarried;
    private static Message messageSelfPlayerCalledOff;
    private static Message messageSelfYouCalledOff;
    private static Message messageSelfPlayerMarryOff;
    private final MarriageManager manager;
    private final String surname;

    public static void loadMessages(MarriageMaster plugin) {
        messageSelfMarried = (Message)plugin.getLanguage().getMessage("Ingame.Marry.Self.Married").placeholders(Placeholders.PLAYER_NAME);
        messageSelfYouCalledOff = plugin.getLanguage().getMessage("Ingame.Marry.Self.YouCalledOff");
        messageSelfPlayerMarryOff = (Message)plugin.getLanguage().getMessage("Ingame.Marry.Self.PlayerOff").placeholders(Placeholders.PLAYER_NAME);
        messageSelfPlayerCalledOff = (Message)plugin.getLanguage().getMessage("Ingame.Marry.Self.PlayerCalledOff").placeholders(Placeholders.PLAYER_NAME);
        messageSelfBroadcastMarriage = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Marry.Self.Broadcast").placeholders(Placeholders.PLAYER1_NAME)).placeholders(Placeholders.PLAYER2_NAME);
        if (!plugin.getConfiguration().isMarryAnnouncementEnabled()) {
            messageSelfBroadcastMarriage.setSendMethod(SendMethod.DISABLED);
        }
    }

    public static void unLoadMessages() {
        messageSelfPlayerMarryOff = null;
        messageSelfYouCalledOff = null;
        messageSelfPlayerCalledOff = null;
        messageSelfMarried = null;
        messageSelfBroadcastMarriage = null;
    }

    public SelfMarryAcceptRequest(@NotNull MarriageManager manager, @NotNull MarriagePlayer hasToAccept, @NotNull MarriagePlayer sender, @Nullable String surname) {
        super(hasToAccept, sender);
        this.surname = surname;
        this.manager = manager;
    }

    @Override
    public void onAccept() {
        if (((MarriagePlayer[])this.getPlayersThatCanCancel()).length == 0 || !((MarriagePlayer[])this.getPlayersThatCanCancel())[0].isOnline() || !((MarriagePlayer)this.getPlayerThatHasToAccept()).isOnline()) {
            return;
        }
        MarriagePlayer player1 = ((MarriagePlayer[])this.getPlayersThatCanCancel())[0];
        MarriagePlayer player2 = (MarriagePlayer)this.getPlayerThatHasToAccept();
        MarryEvent marryEvent = new MarryEvent(player1, player2, (CommandSender)player1.getPlayerOnline(), this.surname);
        Bukkit.getPluginManager().callEvent((Event)marryEvent);
        if (!marryEvent.isCancelled()) {
            MarriageData marriage = new MarriageData(((MarriagePlayer[])this.getPlayersThatCanCancel())[0], (MarriagePlayer)this.getPlayerThatHasToAccept(), ((MarriagePlayer[])this.getPlayersThatCanCancel())[0], this.surname);
            MarriageMaster.getInstance().getDatabase().cachedMarry(marriage);
            player2.send(messageSelfMarried, player1);
            player1.send(messageSelfMarried, player2);
            messageSelfBroadcastMarriage.broadcast(player1, player2);
            MarriageMaster.getInstance().getServer().getPluginManager().callEvent((Event)new MarriedEvent(marriage));
        }
    }

    @Override
    public void onDeny() {
        if (((MarriagePlayer[])this.getPlayersThatCanCancel()).length == 0 || !((MarriagePlayer[])this.getPlayersThatCanCancel())[0].isOnline() || !((MarriagePlayer)this.getPlayerThatHasToAccept()).isOnline()) {
            return;
        }
        MarriagePlayer p1 = ((MarriagePlayer[])this.getPlayersThatCanCancel())[0];
        MarriagePlayer p2 = (MarriagePlayer)this.getPlayerThatHasToAccept();
        p2.send(messageSelfYouCalledOff, new Object[0]);
        p1.send(messageSelfPlayerCalledOff, p2);
    }

    @Override
    public void onCancel(@NotNull MarriagePlayer player) {
        if (((MarriagePlayer[])this.getPlayersThatCanCancel()).length == 0 || !((MarriagePlayer[])this.getPlayersThatCanCancel())[0].isOnline() || !((MarriagePlayer)this.getPlayerThatHasToAccept()).isOnline()) {
            return;
        }
        MarriagePlayer p1 = ((MarriagePlayer[])this.getPlayersThatCanCancel())[0];
        MarriagePlayer p2 = (MarriagePlayer)this.getPlayerThatHasToAccept();
        p1.send(messageSelfYouCalledOff, new Object[0]);
        p2.send(messageSelfPlayerCalledOff, p1);
    }

    @Override
    protected void onDisconnect(@NotNull MarriagePlayer player) {
        if (player.equals(((MarriagePlayer[])this.getPlayersThatCanCancel())[0])) {
            ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(messageSelfPlayerMarryOff, player);
        } else {
            ((MarriagePlayer[])this.getPlayersThatCanCancel())[0].send(messageSelfPlayerMarryOff, player);
        }
    }
}

