/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Management.Requests;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Management.MarriageManager;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Placeholder.Placeholders;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import org.jetbrains.annotations.NotNull;

public class SelfDivorceAcceptRequest
extends AcceptPendingRequest {
    private static Message messageSelfDivorcePlayerOff;
    private static Message messageSelfDivorceDeny;
    private static Message messageSelfDivorceYouDeny;
    private static Message messageSelfDivorceCancelled;
    private static Message messageSelfDivorceYouCancelled;
    private final Marriage marriageData;
    private final MarriageManager manager;

    public static void loadMessages(MarriageMaster plugin) {
        messageSelfDivorceDeny = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.Self.Deny").placeholders(Placeholders.PLAYER_NAME);
        messageSelfDivorceYouDeny = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.Self.YouDeny").placeholders(Placeholders.PLAYER_NAME);
        messageSelfDivorceCancelled = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.Self.Cancelled").placeholders(Placeholders.PLAYER_NAME);
        messageSelfDivorceYouCancelled = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.Self.YouCancelled").placeholders(Placeholders.PLAYER_NAME);
        messageSelfDivorcePlayerOff = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.Self.PlayerOff").placeholders(Placeholders.PLAYER_NAME);
    }

    public static void unLoadMessages() {
        messageSelfDivorceYouCancelled = null;
        messageSelfDivorceCancelled = null;
        messageSelfDivorceYouDeny = null;
        messageSelfDivorceDeny = null;
        messageSelfDivorcePlayerOff = null;
    }

    public SelfDivorceAcceptRequest(@NotNull MarriageManager manager, @NotNull MarriagePlayer hasToAccept, @NotNull MarriagePlayer canCancel, @NotNull Marriage marriageData) {
        super(hasToAccept, canCancel);
        this.marriageData = marriageData;
        this.manager = manager;
    }

    @Override
    protected void onAccept() {
        this.manager.selfFinishDivorce(this.marriageData, ((MarriagePlayer[])this.getPlayersThatCanCancel())[0]);
    }

    @Override
    protected void onDeny() {
        ((MarriagePlayer[])this.getPlayersThatCanCancel())[0].send(messageSelfDivorceDeny, this.getPlayerThatHasToAccept());
        ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(messageSelfDivorceYouDeny, ((MarriagePlayer[])this.getPlayersThatCanCancel())[0]);
    }

    @Override
    protected void onCancel(@NotNull MarriagePlayer player) {
        ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(messageSelfDivorceCancelled, player);
        player.send(messageSelfDivorceYouCancelled, this.getPlayerThatHasToAccept());
    }

    @Override
    protected void onDisconnect(@NotNull MarriagePlayer player) {
        if (player.equals(((MarriagePlayer[])this.getPlayersThatCanCancel())[0])) {
            ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(messageSelfDivorcePlayerOff, player);
        } else {
            ((MarriagePlayer[])this.getPlayersThatCanCancel())[0].send(messageSelfDivorcePlayerOff, player);
        }
    }
}

