/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Listener;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.DelayableTeleportAction;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.HomeCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.TpCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.PluginChannelCommunicatorBase;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class PluginChannelCommunicator
extends PluginChannelCommunicatorBase
implements PluginMessageListener,
Listener {
    private static String serverName = null;
    private final MarriageMaster plugin;
    private final long delayTime;
    private boolean serverNameUpdated = false;
    private TpCommand tpCommand = null;
    private HomeCommand homeCommand = null;

    public PluginChannelCommunicator(MarriageMaster plugin) {
        super(plugin.getLogger(), plugin.getDatabase());
        this.plugin = plugin;
        this.delayTime = (long)plugin.getConfiguration().getTPDelayTime() * 20L;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)plugin, "BungeeCord");
        plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)plugin, "BungeeCord", (PluginMessageListener)this);
        plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)plugin, "marriagemaster:main");
        plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)plugin, "marriagemaster:main", (PluginMessageListener)this);
        PluginChannelCommunicator.setServerName(plugin.getConfiguration().getServerName());
    }

    @Override
    public void close() {
        HandlerList.unregisterAll((Listener)this);
        this.plugin.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin);
        this.plugin.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin);
    }

    @Override
    protected void receiveUnknownChannel(@NotNull String channel, byte[] bytes) {
        if (channel.equals("BungeeCord")) {
            try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));){
                if (in.readUTF().equalsIgnoreCase("GetServer")) {
                    String server = in.readUTF();
                    if (!server.equals(serverName)) {
                        PluginChannelCommunicator.setServerName(server);
                        this.plugin.getConfiguration().setServerName(server);
                    }
                    this.serverNameUpdated = true;
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Failed reading message from the bungee!", e);
            }
        }
    }

    @Override
    protected boolean receiveMarriageMaster(@NotNull String cmd, @NotNull DataInputStream inputStream) throws IOException {
        switch (cmd) {
            case "update": {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "marry update");
                break;
            }
            case "reload": {
                this.plugin.reload();
                break;
            }
            case "home": {
                MarriagePlayer toTP = this.plugin.getPlayerData(UUID.fromString(inputStream.readUTF()));
                Marriage marriage = (Marriage)toTP.getMarriageData(this.plugin.getPlayerData(UUID.fromString(inputStream.readUTF())));
                if (marriage == null || !toTP.isOnline()) {
                    return true;
                }
                this.homeCommand.doTheTP(toTP, marriage);
                break;
            }
            case "delayHome": {
                MarriagePlayer player = this.plugin.getPlayerData(UUID.fromString(inputStream.readUTF()));
                if (!player.isOnline()) break;
                this.plugin.doDelayableTeleportAction(new DelayedAction("home", player, inputStream.readUTF()));
                break;
            }
            case "tp": {
                Player player = this.plugin.getServer().getPlayer(UUID.fromString(inputStream.readUTF()));
                Player target = this.plugin.getServer().getPlayer(UUID.fromString(inputStream.readUTF()));
                if (player == null || target == null || this.tpCommand == null) break;
                this.tpCommand.doTheTP(player, target);
                break;
            }
            case "delayTP": {
                MarriagePlayer player = this.plugin.getPlayerData(UUID.fromString(inputStream.readUTF()));
                if (!player.isOnline()) break;
                this.plugin.doDelayableTeleportAction(new DelayedAction("tp", player, inputStream.readUTF()));
                break;
            }
            case "UseUUIDs": {
                String useUUIDsString = inputStream.readUTF();
                boolean useUUIdDs = Boolean.parseBoolean(useUUIDsString);
                if (useUUIdDs) break;
                this.logger.warning("Your BungeeCord version of Marriage Master is outdated! And you have disabled the UseUUIDs setting on BungeeCord! Changing config ...");
                break;
            }
            case "UseUUIDSeparators": {
                boolean useUUIDSeparators = Boolean.parseBoolean(inputStream.readUTF());
                if (useUUIDSeparators == this.plugin.getConfiguration().useUUIDSeparators()) break;
                this.logger.warning("UseUUIDSeparators setting does not match value on BungeeCord! Changing config ...");
                this.plugin.getConfiguration().setUseUUIDSeparators(useUUIDSeparators);
                this.logger.info("UseUUIDSeparators setting has been set to " + useUUIDSeparators + " to match BungeeCord setting. Please restart the server or reload the plugin.");
                break;
            }
            case "UUID_Type": {
                String type = inputStream.readUTF();
                if ((!type.equals("online") || this.plugin.getConfiguration().useOnlineUUIDs()) && (!type.equals("offline") || !this.plugin.getConfiguration().useOnlineUUIDs())) break;
                this.logger.warning("UUID_Type setting does not match value on BungeeCord! Changing config ...");
                this.plugin.getConfiguration().setUUIDType(type);
                this.logger.info("UUID_Type setting has been set to " + type + " to match BungeeCord setting. Please restart the server or reload the plugin.");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] bytes) {
        this.receive(channel, bytes);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLoginEvent(PlayerJoinEvent event) {
        if (!this.serverNameUpdated) {
            this.sendMessage("BungeeCord", PluginChannelCommunicator.buildStringMessage("GetServer"));
        }
        if (this.plugin.getServer().getOnlinePlayers().size() == 1) {
            this.database.resync();
        }
    }

    @Override
    public void sendMessage(byte[] data) {
        this.sendMessage("marriagemaster:main", data);
    }

    private void sendMessage(String channel, byte[] data) {
        if (!this.plugin.getServer().getOnlinePlayers().isEmpty()) {
            ((Player)this.plugin.getServer().getOnlinePlayers().iterator().next()).sendPluginMessage((Plugin)this.plugin, channel, data);
        } else {
            this.logger.warning("Failed to send PluginMessage, there is no player online!");
        }
    }

    public static String getServerName() {
        return serverName;
    }

    private static void setServerName(String serverName) {
        PluginChannelCommunicator.serverName = serverName;
    }

    public void setTpCommand(TpCommand tpCommand) {
        this.tpCommand = tpCommand;
    }

    public void setHomeCommand(HomeCommand homeCommand) {
        this.homeCommand = homeCommand;
    }

    private class DelayedAction
    implements DelayableTeleportAction {
        private final MarriagePlayer player;
        private final String command;
        private final String partnerUUID;

        public DelayedAction(String command, MarriagePlayer player, String partnerUUID) {
            this.command = command;
            this.player = player;
            this.partnerUUID = partnerUUID;
        }

        @Override
        public void run() {
            PluginChannelCommunicator.this.sendMessage(this.command, this.player.getUUID().toString(), this.partnerUUID);
        }

        @Override
        public long getDelay() {
            return PluginChannelCommunicator.this.delayTime;
        }

        @Override
        public MarriagePlayer getPlayer() {
            return this.player;
        }
    }
}

