/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Formatter;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.PrefixSuffixFormatter;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Formatter.IMarriageAndPartnerFormatter;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Formatter.PlaceholderFormatter;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Formatter.StaticStringFormatter;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class PrefixSuffixFormatterImpl
implements PrefixSuffixFormatter {
    private final IMarriageAndPartnerFormatter prefixFormatter;
    private final IMarriageAndPartnerFormatter suffixFormatter;

    public PrefixSuffixFormatterImpl(MarriageMaster plugin) {
        this.prefixFormatter = PrefixSuffixFormatterImpl.produceFormatter(plugin.getConfiguration().getPrefix());
        this.suffixFormatter = PrefixSuffixFormatterImpl.produceFormatter(plugin.getConfiguration().getSuffix());
    }

    public static IMarriageAndPartnerFormatter produceFormatter(@NotNull String format) {
        format = format.replace("{StatusHeart}", "266\u2764\u00a7f");
        if (StringUtils.indexOfAny((String)format, (String[])new String[]{"{Surname}", "{PartnerName}", "{PartnerDisplayName}", "{MagicHeart}"}) != -1) {
            return new PlaceholderFormatter(format.replace("{Surname}", "%1$s").replace("{PartnerName}", "%2$s").replace("{PartnerDisplayName}", "%3$s").replace("{MagicHeart}", "%4$s"));
        }
        return new StaticStringFormatter(format);
    }

    @Override
    public String formatPrefix(@NotNull Marriage marriage, @NotNull MarriagePlayer partner) {
        return this.prefixFormatter.format(marriage, partner);
    }

    @Override
    public String formatSuffix(@NotNull Marriage marriage, @NotNull MarriagePlayer partner) {
        return this.suffixFormatter.format(marriage, partner);
    }
}

