/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database;

import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.MarriageData;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.MarriageHome;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.MarriagePlayerData;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.SpecialInfoWorker.DbErrorLoadingDataInfo;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.IPlatformSpecific;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider.ConnectionProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import java.sql.SQLException;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformSpecific
implements IPlatformSpecific<MarriagePlayerData, MarriageData, MarriageHome> {
    private final MarriageMaster plugin;

    public PlatformSpecific(MarriageMaster plugin) {
        this.plugin = plugin;
    }

    @Override
    public MarriagePlayerData producePlayer(@Nullable UUID uuid, @NotNull String name, boolean priest, boolean sharesBackpack, @Nullable Object databaseKey) {
        return new MarriagePlayerData(uuid, name, priest, sharesBackpack, databaseKey);
    }

    @Override
    public MarriageData produceMarriage(@NotNull MarriagePlayerData player1, @NotNull MarriagePlayerData player2, @Nullable MarriagePlayerData priest, @NotNull Date weddingDate, @Nullable String surname, boolean pvpEnabled, @Nullable MessageColor color, @Nullable MarriageHome home, @Nullable Object databaseKey) {
        return new MarriageData(player1, player2, priest, weddingDate, surname, pvpEnabled, color, home, databaseKey);
    }

    @Override
    public MarriageHome produceHome(@NotNull String name, @NotNull String world, @Nullable String server, double x, double y, double z, float yaw, float pitch) {
        return new MarriageHome(world, x, y, z, yaw, pitch, server);
    }

    @Override
    public void runAsync(@NotNull Runnable runnable, long delay) {
        if (delay < 1L) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable);
        } else {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, runnable, delay);
        }
    }

    @Override
    @Nullable
    public ConnectionProvider getExternalConnectionProvider(@NotNull String dbType, @NotNull Logger logger) throws SQLException {
        ConnectionProvider connectionProvider = null;
        if (dbType.equals("shared") || dbType.equals("external") || dbType.equals("global")) {
            logger.warning((Object)((Object)ConsoleColor.RED) + "The shared database connection option is not available in standalone mode!" + (Object)((Object)ConsoleColor.RESET));
            throw new SQLException("The shared database connection option is not available in standalone mode!");
        }
        return connectionProvider;
    }

    @Override
    @NotNull
    public String getPluginVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    public void spawnDatabaseLoadingErrorMessage(String failedToLoad) {
        new DbErrorLoadingDataInfo(this.plugin, failedToLoad);
    }
}

