/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.DelayableTeleportAction;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.TPEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Placeholder.Placeholders;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TpCommand
extends MarryCommand {
    private static final Set<Material> BAD_MATS = new HashSet<Material>();
    private final Message messageTeleport;
    private final Message messageTeleportTo;
    private final Message messageUnsafe;
    private final Message messageToUnsafe;
    private final Message messagePartnerVanished;
    private final Message messageWorldNotAllowed;
    private final Message messageRequireConfirmation;
    private final Message messageWaitForConfirmation;
    private final Message messageRequestDenied;
    private final Message messageRequestDeniedPartner;
    private final Message messageRequestCanceled;
    private final Message messageRequestCanceledPartner;
    private final Message messageRequestCanceledDisconnectRequester;
    private final Message messageRequestCanceledDisconnectTarget;
    private final Set<String> blacklistedWorlds;
    private final boolean safetyCheck;
    private final boolean requireConfirmation;
    private final long delayTime;

    public TpCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "tp", plugin.getLanguage().getTranslated("Commands.Description.Tp"), "marry.tp", true, true, plugin.getLanguage().getCommandAliases("Tp"));
        this.blacklistedWorlds = plugin.getConfiguration().getTPBlackListedWorlds();
        this.safetyCheck = plugin.getConfiguration().getSafetyCheck();
        this.requireConfirmation = plugin.getConfiguration().getRequireConfirmation();
        this.delayTime = (long)plugin.getConfiguration().getTPDelayTime() * 20L;
        this.messageTeleport = plugin.getLanguage().getMessage("Ingame.TP.Teleport");
        this.messageTeleportTo = plugin.getLanguage().getMessage("Ingame.TP.TeleportTo");
        this.messageUnsafe = plugin.getLanguage().getMessage("Ingame.TP.Unsafe");
        this.messageToUnsafe = plugin.getLanguage().getMessage("Ingame.TP.ToUnsafe");
        this.messagePartnerVanished = plugin.getLanguage().getMessage("Ingame.TP.PartnerVanished");
        this.messageWorldNotAllowed = plugin.getLanguage().getMessage("Ingame.TP.WorldNotAllowed");
        this.messageRequireConfirmation = (Message)plugin.getLanguage().getMessage("Ingame.TP.Request.Notification").placeholders(Placeholders.PLAYER_NAME);
        this.messageWaitForConfirmation = plugin.getLanguage().getMessage("Ingame.TP.Request.WaitForConfirmation");
        this.messageRequestDenied = plugin.getLanguage().getMessage("Ingame.TP.Request.Denied");
        this.messageRequestDeniedPartner = plugin.getLanguage().getMessage("Ingame.TP.Request.DeniedPartner");
        this.messageRequestCanceled = plugin.getLanguage().getMessage("Ingame.TP.Request.Canceled");
        this.messageRequestCanceledPartner = plugin.getLanguage().getMessage("Ingame.TP.Request.CanceledPartner");
        this.messageRequestCanceledDisconnectRequester = plugin.getLanguage().getMessage("Ingame.TP.Request.CanceledDisconnectRequester");
        this.messageRequestCanceledDisconnectTarget = plugin.getLanguage().getMessage("Ingame.TP.Request.CanceledDisconnectTarget");
        if (plugin.getPluginChannelCommunicator() != null) {
            plugin.getPluginChannelCommunicator().setTpCommand(this);
        }
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer partner;
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        MarriagePlayer marriagePlayer = partner = this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length >= 1 ? (MarriagePlayer)player.getPartner(args[0]) : (MarriagePlayer)player.getNearestPartnerMarriageData().getPartner(player);
        if (partner == null) {
            CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
        } else if (partner.isOnline()) {
            if (this.requireConfirmation && !player.hasPermission("marry.bypass.tpconfirmation") && !partner.hasPermission("marry.autoaccept.tprequest")) {
                this.messageWaitForConfirmation.send(sender, new Object[0]);
                ((CommandManager)this.getMarriagePlugin().getCommandManager()).registerAcceptPendingRequest(new TpRequest(player, partner));
                partner.send(this.messageRequireConfirmation, player);
            } else {
                this.tp(player, partner);
            }
        } else {
            CommonMessages.getMessagePartnerOffline().send(sender, new Object[0]);
        }
    }

    private void tp(@NotNull MarriagePlayer player, @NotNull MarriagePlayer partner) {
        TPEvent event = new TPEvent(player, (Marriage)player.getMarriageData(partner));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.getMarriagePlugin().doDelayableTeleportAction(new TpToPartner(player, (Player)partner.getPlayerOnline()));
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
    }

    @Nullable
    private Location getSafeLoc(@NotNull Location loc) {
        World w = loc.getWorld();
        if (w == null) {
            return null;
        }
        int y = loc.getBlockY();
        if (loc.getY() - (double)y < 0.001) {
            --y;
        }
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        int miny = MCVersion.isOlderThan(MCVersion.MC_1_17) ? Math.max(y - 10, 1) : y - 10;
        Block b1 = w.getBlockAt(x, y + 1, z);
        Block b2 = w.getBlockAt(x, y + 2, z);
        Material matB1 = b1 == null ? Material.AIR : b1.getType();
        Material matB2 = b2 == null ? Material.AIR : b1.getType();
        loc = null;
        while (y > miny && loc == null) {
            Material mat;
            Block b = w.getBlockAt(x, y, z);
            Material material = mat = b == null ? Material.AIR : b.getType();
            if (!(b == null || b.isEmpty() || BAD_MATS.contains(mat) || mat == Material.AIR || b1 != null && !(MCVersion.isNewerOrEqualThan(MCVersion.MC_1_13) ? b1.isPassable() && !BAD_MATS.contains(matB1) : b1.isEmpty()) || b2 != null && !(MCVersion.isNewerOrEqualThan(MCVersion.MC_1_13) ? b2.isPassable() && !BAD_MATS.contains(matB2) : b2.isEmpty()))) {
                loc = b.getLocation();
                loc.setX(loc.getX() + 0.5);
                loc.setY(loc.getY() + 1.0);
                loc.setZ(loc.getZ() + 0.5);
            }
            b2 = b1;
            matB2 = matB1;
            b1 = b;
            matB1 = mat;
            --y;
        }
        return loc;
    }

    public void doTheTP(@NotNull Player player, @NotNull Player partner) {
        if (player.canSee(partner)) {
            Location loc = partner.getLocation();
            if (!this.blacklistedWorlds.contains(loc.getWorld().getName().toLowerCase(Locale.ENGLISH)) || player.hasPermission("marry.bypass.worldblacklist")) {
                if (!player.isFlying() && this.safetyCheck && (loc = this.getSafeLoc(loc)) == null) {
                    this.messageUnsafe.send((CommandSender)player, new Object[0]);
                    this.messageToUnsafe.send((CommandSender)partner, new Object[0]);
                } else {
                    player.teleport(loc);
                    this.messageTeleport.send((CommandSender)player, new Object[0]);
                    this.messageTeleportTo.send((CommandSender)partner, new Object[0]);
                }
            } else {
                this.messageWorldNotAllowed.send((CommandSender)player, new Object[0]);
            }
        } else {
            this.messagePartnerVanished.send((CommandSender)player, new Object[0]);
        }
    }

    static {
        BAD_MATS.add(Material.FIRE);
        BAD_MATS.add(Material.LAVA);
        BAD_MATS.add(Material.CACTUS);
    }

    private class TpRequest
    extends AcceptPendingRequest {
        MarriagePlayer player;

        public TpRequest(MarriagePlayer player, MarriagePlayer partner) {
            super(partner, player);
            this.player = player;
        }

        @Override
        protected void onAccept() {
            TpCommand.this.tp(this.player, (MarriagePlayer)this.getPlayerThatHasToAccept());
        }

        @Override
        protected void onDeny() {
            ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(TpCommand.this.messageRequestDenied, new Object[0]);
            this.player.send(TpCommand.this.messageRequestDeniedPartner, new Object[0]);
        }

        @Override
        protected void onCancel(@NotNull MarriagePlayer marriagePlayer) {
            this.player.send(TpCommand.this.messageRequestCanceled, new Object[0]);
            ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(TpCommand.this.messageRequestCanceledPartner, new Object[0]);
        }

        @Override
        protected void onDisconnect(@NotNull MarriagePlayer marriagePlayer) {
            if (marriagePlayer.equals(this.player)) {
                ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(TpCommand.this.messageRequestCanceledDisconnectRequester, new Object[0]);
            } else {
                this.player.send(TpCommand.this.messageRequestCanceledDisconnectTarget, new Object[0]);
            }
        }
    }

    private class TpToPartner
    implements DelayableTeleportAction {
        private final MarriagePlayer player;
        private final Player partner;

        @Override
        public void run() {
            TpCommand.this.doTheTP((Player)this.player.getPlayerOnline(), this.partner);
        }

        @Override
        public long getDelay() {
            return TpCommand.this.delayTime;
        }

        public TpToPartner(MarriagePlayer player, Player partner) {
            this.player = player;
            this.partner = partner;
        }

        @Override
        public MarriagePlayer getPlayer() {
            return this.player;
        }
    }
}

