/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Management.MarriageManager;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Placeholder.Placeholders;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.FormattedStringPlaceholderProcessor;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SetPriestCommand
extends MarryCommand {
    private final Message messageMadeYouAPriest;
    private final Message messageFiredYou;
    private final Message messageYouMadeAPriest;
    private final Message messageYouFiredAPriest;
    private final Message messagePerPermission;
    private final String helpParam;

    public SetPriestCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "setpriest", plugin.getLanguage().getTranslated("Commands.Description.SetPriest"), "marry.setpriest", plugin.getLanguage().getCommandAliases("SetPriest"));
        this.messageMadeYouAPriest = (Message)((Message)plugin.getLanguage().getMessage("Ingame.SetPriest.MadeYouAPriest").placeholder("Name")).placeholder("DisplayName", FormattedStringPlaceholderProcessor.INSTANCE);
        this.messageFiredYou = (Message)((Message)plugin.getLanguage().getMessage("Ingame.SetPriest.FiredYou").placeholder("Name")).placeholder("DisplayName", FormattedStringPlaceholderProcessor.INSTANCE);
        this.messageYouMadeAPriest = (Message)plugin.getLanguage().getMessage("Ingame.SetPriest.YouMadeAPriest").placeholders(Placeholders.PLAYER_NAME);
        this.messageYouFiredAPriest = (Message)plugin.getLanguage().getMessage("Ingame.SetPriest.YouFiredAPriest").placeholders(Placeholders.PLAYER_NAME);
        this.messagePerPermission = (Message)plugin.getLanguage().getMessage("Ingame.SetPriest.PerPermission").placeholders(Placeholders.PLAYER_NAME);
        this.helpParam = "<" + CommonMessages.getHelpPlayerNameVariable() + ">";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        if (args.length > 0) {
            for (String arg : args) {
                Player bTarget = Bukkit.getPlayer((String)arg);
                if (bTarget != null) {
                    String senderDisplayName;
                    MarriagePlayer target = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(bTarget);
                    if (bTarget.hasPermission("marry.priest")) {
                        this.messagePerPermission.send(sender, target);
                        continue;
                    }
                    String string = senderDisplayName = sender instanceof Player ? ((Player)sender).getDisplayName() : MarriageManager.CONSOLE_DISPLAY_NAME;
                    if (target.isPriest()) {
                        this.messageYouFiredAPriest.send(sender, target);
                        this.messageFiredYou.send((CommandSender)bTarget, sender.getName(), senderDisplayName);
                        target.setPriest(false);
                        continue;
                    }
                    this.messageYouMadeAPriest.send(sender, target);
                    this.messageMadeYouAPriest.send((CommandSender)bTarget, sender.getName(), senderDisplayName);
                    target.setPriest(true);
                    continue;
                }
                CommonMessages.getMessagePlayerNotOnline().send(sender, arg);
            }
        } else {
            this.showHelp(sender, mainCommandAlias);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        if (args.length > 0) {
            String arg = args[args.length - 1].toLowerCase(Locale.ENGLISH);
            LinkedList<String> names = new LinkedList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                String name = player.getName().toLowerCase(Locale.ENGLISH);
                if (name.equalsIgnoreCase(sender.getName()) || !name.startsWith(arg)) continue;
                names.add(name);
            }
            return names;
        }
        return null;
    }

    @Override
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        LinkedList<HelpData> help = new LinkedList<HelpData>();
        help.add(new HelpData(this.getTranslatedName(), this.helpParam, this.getDescription()));
        return help;
    }
}

