/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Placeholder.Placeholders;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ListPriestsCommand
extends MarryCommand {
    private final int entriesPerPage;
    private final Message messageHeadlineMain;
    private final Message messageFooter;
    private final Message messageListFormat;
    private final Message messageNoPriestsOnline;
    private final boolean useFooter;

    public ListPriestsCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "listpriests", plugin.getLanguage().getTranslated("Commands.Description.ListPriests"), "marry.listpriests", plugin.getLanguage().getCommandAliases("ListPriests"));
        this.useFooter = plugin.getConfiguration().useListFooter();
        this.entriesPerPage = plugin.getConfiguration().getListEntriesPerPage();
        this.messageListFormat = (Message)plugin.getLanguage().getMessage("Ingame.ListPriests.Format").placeholders(Placeholders.mkPlayerNameRegex("(Priest)?"));
        this.messageHeadlineMain = (Message)plugin.getLanguage().getMessage("Ingame.ListPriests.Headline").placeholders(Placeholders.PAGE_OPTIONS);
        this.messageFooter = (Message)plugin.getLanguage().getMessage("Ingame.ListPriests.Footer").placeholders(Placeholders.PAGE_OPTIONS);
        this.messageNoPriestsOnline = plugin.getLanguage().getMessage("Ingame.ListPriests.NoPriestsOnline");
    }

    private ArrayList<MarriagePlayer> collectOnlinePriests(@NotNull CommandSender sender) {
        ArrayList<MarriagePlayer> priests = new ArrayList<MarriagePlayer>();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            MarriagePlayer marriagePlayer = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(player);
            if (!marriagePlayer.isPriest() || sender instanceof Player && !((Player)sender).canSee(player)) continue;
            priests.add(marriagePlayer);
        }
        return priests;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        ArrayList<MarriagePlayer> priests = this.collectOnlinePriests(sender);
        if (!priests.isEmpty()) {
            int i;
            int availablePages;
            int page = 0;
            if (args.length == 1) {
                try {
                    page = StringUtils.parsePageNumber(args[0]);
                }
                catch (NumberFormatException ignored) {
                    CommonMessages.getMessageNotANumber().send(sender, new Object[0]);
                    return;
                }
            }
            if (page >= (availablePages = (int)Math.ceil((float)priests.size() / (float)this.entriesPerPage))) {
                page = availablePages - 1;
            }
            this.messageHeadlineMain.send(sender, page + 1, availablePages, mainCommandAlias, alias, page, page + 2);
            int end = Math.min(i + this.entriesPerPage, priests.size());
            for (i = page * this.entriesPerPage; i < end; ++i) {
                this.messageListFormat.send(sender, priests.get(i));
            }
            if (this.useFooter) {
                this.messageFooter.send(sender, page + 1, availablePages, mainCommandAlias, alias, page, page + 2);
            }
        } else {
            this.messageNoPriestsOnline.send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender commandSender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return EMPTY_TAB_COMPLETE_LIST;
    }
}

