/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.MarriagePlayerData;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Placeholder.Placeholders;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender.SendMethod;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.PassthroughMessageComponentPlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ListCommand
extends MarryCommand {
    private final int entriesPerPage;
    private final Message messageHeadlineMain;
    private final Message messageFooter;
    private final Message messageListFormat;
    private final Message messageNoMarriedPlayers;

    public ListCommand(@NotNull MarriageMaster plugin) {
        super((JavaPlugin)plugin, "list", plugin.getLanguage().getTranslated("Commands.Description.List"), "marry.list", plugin.getLanguage().getCommandAliases("List"));
        this.entriesPerPage = plugin.getConfiguration().getListEntriesPerPage();
        this.messageListFormat = (Message)((Message)((Message)((Message)((Message)((Message)plugin.getLanguage().getMessage("Ingame.List.Format").placeholder("Player1Name")).placeholder("Player2Name")).placeholder("Player1DisplayName", PassthroughMessageComponentPlaceholderProcessor.INSTANCE)).placeholder("Player2DisplayName", PassthroughMessageComponentPlaceholderProcessor.INSTANCE)).placeholder("Surname")).placeholder("MagicHeart");
        this.messageHeadlineMain = (Message)plugin.getLanguage().getMessage("Ingame.List.Headline").placeholders(Placeholders.PAGE_OPTIONS);
        this.messageFooter = (Message)plugin.getLanguage().getMessage("Ingame.List.Footer").placeholders(Placeholders.PAGE_OPTIONS);
        this.messageNoMarriedPlayers = plugin.getLanguage().getMessage("Ingame.List.NoMarriedPlayers");
        if (!plugin.getConfiguration().useListFooter()) {
            this.messageFooter.setSendMethod(SendMethod.DISABLED);
        }
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        Collection couples = this.getMarriagePlugin().getMarriages();
        if (!couples.isEmpty()) {
            int page = 0;
            if (args.length == 1) {
                try {
                    page = StringUtils.parsePageNumber(args[0]);
                }
                catch (NumberFormatException ignored) {
                    CommonMessages.getMessageNotANumber().send(sender, new Object[0]);
                    return;
                }
            }
            int c = this.entriesPerPage;
            int availablePages = (int)Math.ceil((float)couples.size() / (float)this.entriesPerPage);
            page = Math.min(page, availablePages - 1);
            this.messageHeadlineMain.send(sender, page + 1, availablePages, mainCommandAlias, alias, page, page + 2);
            Iterator couplesIterator = couples.iterator();
            for (int i = 0; couplesIterator.hasNext() && i < page * this.entriesPerPage; ++i) {
                couplesIterator.next();
            }
            while (couplesIterator.hasNext() && --c >= 0) {
                Marriage couple = (Marriage)couplesIterator.next();
                MarriagePlayer p1 = (MarriagePlayer)couple.getPartner1();
                MarriagePlayer p2 = (MarriagePlayer)couple.getPartner2();
                MessageComponent p1DName = ((MarriagePlayerData)p1).getDisplayNameMessageComponentCheckVanished(sender);
                MessageComponent p2DName = ((MarriagePlayerData)p2).getDisplayNameMessageComponentCheckVanished(sender);
                this.messageListFormat.send(sender, p1.getName(), p2.getName(), p1DName, p2DName, couple.getSurnameString(), couple.getMagicHeart());
            }
            this.messageFooter.send(sender, page + 1, availablePages, mainCommandAlias, alias, page, page + 2);
        } else {
            this.messageNoMarriedPlayers.send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return EMPTY_TAB_COMPLETE_LIST;
    }
}

