/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.HugEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Range;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.FloatPlaceholderProcessor;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class HugCommand
extends MarryCommand {
    private static HugCommand instance;
    private final Message messageHugged;
    private final Message messageGotHugged;
    private final Message messageTooFarAway;
    private final Message messageWait;
    private final double range;
    private final double rangeSquared;
    private final int waitTime;

    public HugCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "hug", plugin.getLanguage().getTranslated("Commands.Description.Hug"), "marry.hug", true, false, plugin.getLanguage().getCommandAliases("Hug"));
        this.range = plugin.getConfiguration().getRange(Range.Hug);
        this.rangeSquared = plugin.getConfiguration().getRangeSquared(Range.Hug);
        this.messageHugged = plugin.getLanguage().getMessage("Ingame.Hug.Hugged");
        this.messageGotHugged = plugin.getLanguage().getMessage("Ingame.Hug.GotHugged");
        FloatPlaceholderProcessor singleDecimalPointProcessor = new FloatPlaceholderProcessor(1);
        this.messageTooFarAway = (Message)plugin.getLanguage().getMessage("Ingame.Hug.TooFarAway").placeholder("Distance", singleDecimalPointProcessor);
        this.messageWait = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Hug.Wait").placeholder("Time")).placeholder("TimeLeft", singleDecimalPointProcessor);
        this.waitTime = plugin.getConfiguration().getHugWaitTime();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer partner;
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        MarriagePlayer marriagePlayer = partner = this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length >= 1 ? (MarriagePlayer)player.getPartner(args[0]) : (MarriagePlayer)player.getNearestPartnerMarriageData().getPartner(player);
        if (partner == null) {
            CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
        } else if (partner.isOnline() && partner.getPlayerOnline() != null) {
            if (this.getMarriagePlugin().isInRangeSquared((Player)sender, (Player)partner.getPlayerOnline(), this.rangeSquared)) {
                this.hug(player, partner);
            } else {
                this.messageTooFarAway.send(sender, this.range);
            }
        } else {
            CommonMessages.getMessagePartnerOffline().send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
    }

    private boolean canHugAgain(MarriagePlayer player) {
        return player.getLastHugTime() < System.currentTimeMillis() - (long)this.waitTime || player.hasPermission("marry.bypass.delay");
    }

    public void hug(MarriagePlayer player, MarriagePlayer partner) {
        if (this.canHugAgain(player)) {
            HugEvent event = new HugEvent(player, (Marriage)player.getMarriageData(partner));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                player.setLastHugTime(System.currentTimeMillis());
                player.sendMessage(this.messageHugged, new Object[0]);
                partner.sendMessage(this.messageGotHugged, new Object[0]);
            }
        } else {
            player.send(this.messageWait, this.waitTime / 1000, (double)(player.getLastHugTime() - System.currentTimeMillis() + (long)this.waitTime) / 1000.0);
        }
    }

    public static HugCommand getInstance() {
        return instance;
    }
}

