/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.DelayableTeleportAction;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.HomeDelEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.HomeSetEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.HomeTPEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Home;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.MarriageHome;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HomeCommand
extends MarryCommand {
    private MarryCommand setHomeCommand;
    private MarryCommand delHomeCommand;
    private final Message messagePlayerNoHome;
    private final Message messageNoHome;
    private final Message messageTPed;
    private final long delayTime;

    public HomeCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "home", plugin.getLanguage().getTranslated("Commands.Description.Home"), "marry.home", false, true, plugin.getLanguage().getCommandAliases("Home"));
        this.messagePlayerNoHome = plugin.getLanguage().getMessage("Ingame.Home.PlayerNoHome");
        this.messageNoHome = plugin.getLanguage().getMessage("Ingame.Home.NoHome");
        this.messageTPed = plugin.getLanguage().getMessage("Ingame.Home.TPed");
        this.delayTime = (long)plugin.getConfiguration().getTPDelayTime() * 20L;
        if (plugin.getPluginChannelCommunicator() != null) {
            plugin.getPluginChannelCommunicator().setHomeCommand(this);
        }
    }

    @Override
    public void afterRegister() {
        MarriageMaster plugin = (MarriageMaster)this.getMarriagePlugin();
        this.setHomeCommand = new SetHomeCommand(plugin, this);
        plugin.getCommandManager().registerSubCommand(this.setHomeCommand);
        this.delHomeCommand = new DelHomeCommand(plugin, this);
        plugin.getCommandManager().registerSubCommand(this.delHomeCommand);
    }

    @Override
    public void beforeUnregister() {
        MarriageMaster plugin = (MarriageMaster)this.getMarriagePlugin();
        plugin.getCommandManager().unRegisterSubCommand(this.setHomeCommand);
        this.setHomeCommand.close();
        plugin.getCommandManager().unRegisterSubCommand(this.delHomeCommand);
        this.delHomeCommand.close();
    }

    @Override
    public void close() {
        if (this.setHomeCommand != null) {
            this.setHomeCommand.close();
            this.setHomeCommand = null;
        }
        if (this.delHomeCommand != null) {
            this.delHomeCommand.close();
            this.delHomeCommand = null;
        }
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        if (player.isMarried() || sender.hasPermission("marry.home.others") && (!this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 1 || this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2)) {
            Marriage marriage = this.getTargetedMarriage(sender, player, args);
            if (marriage != null) {
                if (!marriage.isHomeSet()) {
                    if (sender.hasPermission("marry.home.others") && !marriage.contains(player)) {
                        this.messagePlayerNoHome.send(sender, new Object[0]);
                    } else {
                        this.messageNoHome.send(sender, new Object[0]);
                    }
                } else {
                    HomeTPEvent event = new HomeTPEvent(player, marriage);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        this.getMarriagePlugin().doDelayableTeleportAction(new TeleportHome(player, marriage));
                    }
                }
            }
        } else {
            CommonMessages.getMessageNotMarried().send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        List<String> names = ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
        if (sender.hasPermission("marry.home.others")) {
            if (names == null) {
                names = new LinkedList<String>();
            }
            String arg = args[args.length - 1].toLowerCase(Locale.ENGLISH);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (names.contains(player.getName()) || sender.getName().equals(player.getName()) || !player.getName().toLowerCase(Locale.ENGLISH).startsWith(arg)) continue;
                names.add(player.getName());
            }
            if (names.isEmpty()) {
                names = null;
            }
        }
        return names;
    }

    @Override
    public boolean canUse(@NotNull CommandSender sender) {
        return super.canUse(sender) && (sender.hasPermission("marry.home.others") || ((MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender)).isMarried());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private Marriage getTargetedMarriage(@NotNull CommandSender sender, @Nullable MarriagePlayer player, @NotNull String[] args) {
        if (this.getMarriagePlugin().areMultiplePartnersAllowed()) {
            if (args.length == 2 && sender.hasPermission("marry.home.others")) {
                MarriagePlayer target1 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
                MarriagePlayer target2 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[1]);
                if (target1.isMarried() && target2.isMarried() && target1.isPartner(target2)) {
                    return (Marriage)target1.getMarriageData(target2);
                }
                if (!target1.isMarried() || !target2.isMarried()) {
                    MarriagePlayer t = !target1.isMarried() ? target1 : target2;
                    CommonMessages.getMessagePlayerNotMarried().send(sender, t.getName());
                    return null;
                } else {
                    CommonMessages.getMessagePlayersNotMarried().send(sender, new Object[0]);
                }
                return null;
            }
            if (player == null) {
                return null;
            }
            if (args.length != 1) return (Marriage)player.getMarriageData();
            MarriagePlayer partner = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
            if (player.isPartner(partner)) return (Marriage)player.getMarriageData(partner);
            CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
            return null;
        }
        if (args.length == 1 && sender.hasPermission("marry.home.others")) {
            MarriagePlayer target = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
            if (target.isMarried()) {
                return (Marriage)target.getMarriageData();
            }
            CommonMessages.getMessagePlayerNotMarried().send(sender, target.getName());
            return null;
        }
        if (player == null) return null;
        return (Marriage)player.getMarriageData();
    }

    public void doTheTP(MarriagePlayer player, Marriage marriage) {
        if (player.isOnline()) {
            if (marriage.getHome() != null) {
                if (((Home)marriage.getHome()).isOnThisServer()) {
                    if (((Home)marriage.getHome()).getLocation().getWorld() == null) {
                        this.plugin.getLogger().info("Home world " + ((Home)marriage.getHome()).getWorldName() + " does not exist. Deleting home.");
                        marriage.setHome(null);
                        player.send(this.messageNoHome, new Object[0]);
                        return;
                    }
                    ((Player)player.getPlayerOnline()).teleport(((Home)marriage.getHome()).getLocation());
                    player.send(this.messageTPed, new Object[0]);
                }
            } else {
                player.send(this.messageNoHome, new Object[0]);
            }
        }
    }

    public class DelHomeCommand
    extends MarryCommand {
        @NotNull
        private final HomeCommand homeCommand;
        @NotNull
        private final Message messageHomeDeleted;

        public DelHomeCommand(@NotNull MarriageMaster plugin, HomeCommand homeCommand) {
            super((JavaPlugin)plugin, "delhome", plugin.getLanguage().getTranslated("Commands.Description.DelHome"), "marry.home.del", false, true, plugin.getLanguage().getCommandAliases("DelHome"));
            this.homeCommand = homeCommand;
            this.messageHomeDeleted = plugin.getLanguage().getMessage("Ingame.Home.Deleted");
        }

        @Override
        public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            if (!(sender instanceof Player)) {
                if (this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2 || !this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 1) {
                    Marriage marriageData = this.homeCommand.getTargetedMarriage(sender, null, args);
                    if (marriageData != null) {
                        marriageData.setHome(null);
                        this.messageHomeDeleted.send(sender, new Object[0]);
                    }
                } else {
                    this.showHelp(sender, mainCommandAlias);
                }
            } else {
                MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
                if (player.isMarried() || sender.hasPermission("marry.home.others") && (!this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 1 || this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2)) {
                    Marriage marriage = HomeCommand.this.getTargetedMarriage(sender, player, args);
                    if (marriage != null) {
                        HomeDelEvent event = new HomeDelEvent(player, marriage);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            marriage.setHome(null);
                            this.messageHomeDeleted.send(sender, new Object[0]);
                        }
                    }
                } else {
                    CommonMessages.getMessageNotMarried().send(sender, new Object[0]);
                }
            }
        }

        @Override
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            return this.homeCommand.tabComplete(sender, mainCommandAlias, alias, args);
        }

        @Override
        public boolean canUse(@NotNull CommandSender sender) {
            return super.canUse(sender) && (sender.hasPermission("marry.home.others") || ((MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender)).isMarried());
        }
    }

    public class SetHomeCommand
    extends MarryCommand {
        @NotNull
        private final HomeCommand homeCommand;
        @NotNull
        private final Message messageSet;

        public SetHomeCommand(@NotNull MarriageMaster plugin, HomeCommand homeCommand) {
            super((JavaPlugin)plugin, "sethome", plugin.getLanguage().getTranslated("Commands.Description.SetHome"), "marry.home.set", false, true, plugin.getLanguage().getCommandAliases("SetHome"));
            this.homeCommand = homeCommand;
            this.messageSet = plugin.getLanguage().getMessage("Ingame.Home.Set");
        }

        @Override
        public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
            if (player.isMarried() || sender.hasPermission("marry.home.others") && (!this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 1 || this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2)) {
                Marriage marriage = HomeCommand.this.getTargetedMarriage(sender, player, args);
                if (marriage != null) {
                    HomeSetEvent event = new HomeSetEvent(player, marriage, ((Player)sender).getLocation());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        marriage.setHome(new MarriageHome(event.getNewHomeLocation()));
                        this.messageSet.send(sender, new Object[0]);
                    }
                }
            } else {
                CommonMessages.getMessageNotMarried().send(sender, new Object[0]);
            }
        }

        @Override
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            return this.homeCommand.tabComplete(sender, mainCommandAlias, alias, args);
        }

        @Override
        public boolean canUse(@NotNull CommandSender sender) {
            return super.canUse(sender) && (sender.hasPermission("marry.home.others") || ((MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender)).isMarried());
        }
    }

    private class TeleportHome
    implements DelayableTeleportAction {
        private final MarriagePlayer player;
        private final Marriage marriage;

        @Override
        public void run() {
            HomeCommand.this.doTheTP(this.player, this.marriage);
        }

        @Override
        public long getDelay() {
            return HomeCommand.this.delayTime;
        }

        public TeleportHome(MarriagePlayer player, Marriage marriage) {
            this.player = player;
            this.marriage = marriage;
        }

        @Override
        public MarriagePlayer getPlayer() {
            return this.player;
        }
    }
}

