/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.CommandManagerImplementation;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Command.SubCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.HelpData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class HelpCommand
extends MarryCommand {
    private Collection<MarryCommand> commands;
    private final Message messageHeader;
    private final Message messageFooter;

    public HelpCommand(@NotNull MarriageMaster plugin, @NotNull Collection<MarryCommand> commands) {
        super((JavaPlugin)plugin, "help", plugin.getLanguage().getTranslated("Commands.Description.Help"), plugin.getLanguage().getCommandAliases("Help"));
        this.commands = commands;
        this.messageHeader = plugin.getLanguage().getMessage("Ingame.Help.Header");
        this.messageFooter = plugin.getLanguage().getMessage("Ingame.Help.Footer");
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        this.messageHeader.send(sender, new Object[0]);
        ArrayList<HelpData> help = new ArrayList<HelpData>();
        for (SubCommand subCommand : this.commands) {
            List<HelpData> temp = subCommand.doGetHelp(sender);
            if (temp == null) continue;
            help.addAll(temp);
        }
        ((CommandManagerImplementation)this.getMarriagePlugin().getCommandManager()).sendHelp(sender, mainCommandAlias, help);
        this.messageFooter.send(sender, new Object[0]);
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return EMPTY_TAB_COMPLETE_LIST;
    }

    @Override
    public void close() {
        this.commands = null;
    }
}

