/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.GiftEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Range;
import at.pcgamingfreaks.MarriageMasterStandalone.Placeholder.Placeholders;
import at.pcgamingfreaks.MarriageMasterStandalone.Placeholder.Processors.NamePlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.ItemFilter;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.ItemNameResolver;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Placeholder.Processors.GameModePlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Placeholder.Processors.ItemAmountPlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Placeholder.Processors.ItemDisplayNamePlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Placeholder.Processors.ItemMetadataPlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Placeholder.Processors.ItemNamePlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Placeholder.Processors.Wrappers.ItemStackWrapper;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.InventoryUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Placeholder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GiftCommand
extends MarryCommand {
    private final Message messageNoItemInHand;
    private final Message messagePartnerInvFull;
    private final Message messageItemSent;
    private final Message messageItemReceived;
    private final Message messageWorldNotAllowed;
    private final Message messageItemNotAllowed;
    private final Message messageGameModeNotAllowedSender;
    private final Message messageGameModeNotAllowedReceiver;
    private final Message messageRequireConfirmation;
    private final Message messageWaitForConfirmation;
    private final Message messageRequestDenied;
    private final Message messageRequestDeniedPartner;
    private final Message messageRequestCanceled;
    private final Message messageRequestCanceledPartner;
    private final Message messageRequestCanceledDisconnectRequester;
    private final Message messageRequestCanceledDisconnectTarget;
    private final Message messageRequestRefundInvFull;
    private final Message messageRequestPartnerAlreadyHasAnOpenRequest;
    private final double range;
    private final boolean blacklistEnabled;
    private final boolean requireConfirmation;
    private final ItemNameResolver itemNameResolver = new ItemNameResolver();
    private final Set<String> worldBlacklist;
    private final ItemFilter itemFilter;
    private final Set<GameMode> allowedSendGameModes;
    private final Set<GameMode> allowedReceiveGameModes;

    public GiftCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "gift", plugin.getLanguage().getTranslated("Commands.Description.Gift"), "marry.gift", true, true, plugin.getLanguage().getCommandAliases("Gift"));
        this.itemNameResolver.load(plugin, plugin.getConfiguration());
        this.range = plugin.getConfiguration().getRangeSquared(Range.Gift);
        this.allowedSendGameModes = plugin.getConfiguration().getGiftAllowedGameModes();
        this.allowedReceiveGameModes = plugin.getConfiguration().getGiftAllowedReceiveGameModes();
        this.requireConfirmation = plugin.getConfiguration().isGiftRequireConfirmationEnabled();
        this.worldBlacklist = plugin.getConfiguration().getGiftBlackListedWorlds();
        this.blacklistEnabled = !this.worldBlacklist.isEmpty();
        Placeholder[] itemNamePlaceholder = new Placeholder[]{new Placeholder("ItemName", new ItemNamePlaceholderProcessor(this.itemNameResolver)), new Placeholder("ItemDisplayName", new ItemDisplayNamePlaceholderProcessor(this.itemNameResolver))};
        Placeholder currentGameModePlaceholder = new Placeholder("CurrentGameMode", new GameModePlaceholderProcessor());
        Placeholder[] itemPlaceholders = new Placeholder[]{new Placeholder("ItemAmount", ItemAmountPlaceholderProcessor.INSTANCE), itemNamePlaceholder[0], itemNamePlaceholder[1], new Placeholder("ItemMetaJSON", new ItemMetadataPlaceholderProcessor(plugin.getLogger()))};
        this.messageGameModeNotAllowedSender = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Gift.GameModeNotAllowedSender").replaceAll("\\{AllowedGameModes}", currentGameModePlaceholder.getProcessor().process(this.allowedSendGameModes))).placeholders(new Placeholder[]{currentGameModePlaceholder});
        this.messageGameModeNotAllowedReceiver = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Gift.GameModeNotAllowedReceiver").replaceAll("\\{AllowedGameModes}", currentGameModePlaceholder.getProcessor().process(this.allowedReceiveGameModes))).placeholders(new Placeholder[]{currentGameModePlaceholder});
        this.messageNoItemInHand = plugin.getLanguage().getMessage("Ingame.Gift.NoItemInHand");
        this.messagePartnerInvFull = plugin.getLanguage().getMessage("Ingame.Gift.PartnerInvFull");
        this.messageItemSent = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Gift.ItemSent").placeholders(Placeholders.PLAYER_NAME)).placeholders(itemPlaceholders);
        this.messageItemReceived = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Gift.ItemReceived").placeholders(new Placeholder[]{new Placeholder("Name", NamePlaceholderProcessor.INSTANCE), new Placeholder("DisplayName", NamePlaceholderProcessor.INSTANCE)})).placeholders(itemPlaceholders);
        this.messageWorldNotAllowed = plugin.getLanguage().getMessage("Ingame.Gift.WorldNotAllowed");
        this.messageItemNotAllowed = (Message)plugin.getLanguage().getMessage("Ingame.Gift.ItemNotAllowed").placeholders(itemNamePlaceholder);
        this.messageRequireConfirmation = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Gift.Request.Notification").placeholders(Placeholders.PLAYER_NAME)).placeholders(itemPlaceholders);
        this.messageWaitForConfirmation = (Message)plugin.getLanguage().getMessage("Ingame.Gift.Request.WaitForConfirmation").placeholders(itemPlaceholders);
        this.messageRequestDenied = (Message)plugin.getLanguage().getMessage("Ingame.Gift.Request.Denied").placeholders(itemPlaceholders);
        this.messageRequestDeniedPartner = (Message)plugin.getLanguage().getMessage("Ingame.Gift.Request.DeniedPartner").placeholders(itemPlaceholders);
        this.messageRequestCanceled = (Message)plugin.getLanguage().getMessage("Ingame.Gift.Request.Canceled").placeholders(itemPlaceholders);
        this.messageRequestCanceledPartner = (Message)plugin.getLanguage().getMessage("Ingame.Gift.Request.CanceledPartner").placeholders(itemPlaceholders);
        this.messageRequestCanceledDisconnectRequester = (Message)plugin.getLanguage().getMessage("Ingame.Gift.Request.CanceledDisconnectRequester").placeholders(itemPlaceholders);
        this.messageRequestCanceledDisconnectTarget = (Message)plugin.getLanguage().getMessage("Ingame.Gift.Request.CanceledDisconnectTarget").placeholders(itemPlaceholders);
        this.messageRequestRefundInvFull = plugin.getLanguage().getMessage("Ingame.Gift.Request.RefundInvFull");
        this.messageRequestPartnerAlreadyHasAnOpenRequest = plugin.getLanguage().getMessage("Ingame.Gift.Request.PartnerAlreadyHasAnOpenRequest");
        if (plugin.getConfiguration().isGiftItemFilterEnabled()) {
            this.itemFilter = new ItemFilter(plugin.getConfiguration().isGiftItemFilterModeWhitelist());
            this.itemFilter.addFilteredMaterials(plugin.getConfiguration().getItemFilterMaterials());
            this.itemFilter.addFilteredNames(plugin.getConfiguration().getGiftItemFilterNames());
            this.itemFilter.addFilteredLore(plugin.getConfiguration().getGiftItemFilterLore());
        } else {
            this.itemFilter = null;
        }
        InventoryUtils.prepareTitleForOpenInventoryWithCustomTitle("ignore this");
    }

    boolean canSend(@NotNull Player sender) {
        if (sender.hasPermission("marry.bypass.gift.gamemode") || this.allowedSendGameModes.contains(sender.getGameMode())) {
            return true;
        }
        this.messageGameModeNotAllowedSender.send((CommandSender)sender, sender.getGameMode());
        return false;
    }

    boolean canReceive(@NotNull Player sender, @NotNull Player receiver) {
        if (!this.allowedReceiveGameModes.contains(receiver.getGameMode()) && !receiver.hasPermission("marry.bypass.gift.gamemode")) {
            this.messageGameModeNotAllowedReceiver.send((CommandSender)sender, receiver.getGameMode());
            return false;
        }
        if (this.blacklistEnabled && !sender.hasPermission("marry.bypass.gift.world") && this.worldBlacklist.contains(receiver.getWorld().getName().toLowerCase(Locale.ENGLISH))) {
            this.messageWorldNotAllowed.send((CommandSender)sender, new Object[0]);
            return false;
        }
        return true;
    }

    @Nullable
    ItemStack checkAndGetItemInHand(@NotNull Player sender) {
        ItemStack its = InventoryUtils.getItemInMainHand(sender);
        if (its == null || its.getType() == Material.AIR || its.getAmount() == 0) {
            this.messageNoItemInHand.send((CommandSender)sender, new Object[0]);
            return null;
        }
        if (this.itemFilter != null && !sender.hasPermission("marry.bypass.gift.itemfilter") && this.itemFilter.isItemBlocked(its) || ((MarriageMaster)this.plugin).getBackpacksIntegration() != null && ((MarriageMaster)this.plugin).getBackpacksIntegration().isBackpackItem(its)) {
            this.messageItemNotAllowed.send((CommandSender)sender, its);
            return null;
        }
        return its;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer partner;
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        Player bPlayer = (Player)sender;
        if (!this.canSend(bPlayer)) {
            return;
        }
        if (this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 1) {
            partner = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
            if (!player.isPartner(partner)) {
                CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
                return;
            }
        } else {
            Marriage mPD = player.getNearestPartnerMarriageData();
            if (mPD == null) {
                return;
            }
            partner = (MarriagePlayer)player.getNearestPartnerMarriageData().getPartner(player);
        }
        if (partner != null && partner.isOnline()) {
            Player bPartner = (Player)partner.getPlayerOnline();
            if (bPartner != null && this.getMarriagePlugin().isInRangeSquared(bPlayer, bPartner, this.range)) {
                ItemStack its = this.checkAndGetItemInHand(bPlayer);
                if (its == null) {
                    return;
                }
                int slot = bPartner.getInventory().firstEmpty();
                if (slot == -1) {
                    this.messagePartnerInvFull.send(sender, new Object[0]);
                    return;
                }
                if (!this.canReceive(bPlayer, bPartner)) {
                    return;
                }
                GiftEvent event = new GiftEvent(player, (Marriage)player.getMarriageData(partner), its);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    its = event.getItemStack();
                    ItemStackWrapper wrappedItemStack = new ItemStackWrapper(its, this.plugin.getLogger(), this.itemNameResolver);
                    if (this.requireConfirmation) {
                        if (!((CommandManager)this.getMarriagePlugin().getCommandManager()).registerAcceptPendingRequest(new GiftRequest(wrappedItemStack, partner, player))) {
                            this.messageRequestPartnerAlreadyHasAnOpenRequest.send(sender, new Object[0]);
                            return;
                        }
                        this.messageWaitForConfirmation.send(sender, wrappedItemStack);
                        partner.send(this.messageRequireConfirmation, player, wrappedItemStack);
                    } else {
                        this.messageItemSent.send(sender, partner, wrappedItemStack);
                        this.messageItemReceived.send((CommandSender)bPartner, partner, wrappedItemStack);
                        bPartner.getInventory().setItem(slot, its);
                    }
                    InventoryUtils.setItemInMainHand(bPlayer, null);
                }
            } else {
                CommonMessages.getMessagePartnerNotInRange().send(sender, new Object[0]);
            }
        } else {
            CommonMessages.getMessagePartnerOffline().send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
    }

    private class GiftRequest
    extends AcceptPendingRequest {
        private final ItemStackWrapper item;
        private final MarriagePlayer recipient;
        private final MarriagePlayer sender;

        public GiftRequest(@NotNull ItemStackWrapper item, @NotNull MarriagePlayer recipient, MarriagePlayer sender) {
            super(recipient, sender);
            this.item = item;
            this.recipient = recipient;
            this.sender = sender;
        }

        @Override
        protected void onAccept() {
            int slot = ((Player)this.recipient.getPlayerOnline()).getInventory().firstEmpty();
            if (slot == -1) {
                this.sender.send(GiftCommand.this.messagePartnerInvFull, new Object[0]);
                this.refund();
                return;
            }
            ((Player)this.recipient.getPlayerOnline()).getInventory().setItem(slot, this.item.getItemStack());
            this.sender.send(GiftCommand.this.messageItemSent, this.recipient, this.item);
            this.recipient.send(GiftCommand.this.messageItemReceived, this.sender, this.item);
        }

        @Override
        protected void onDeny() {
            ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(GiftCommand.this.messageRequestDenied, this.item);
            this.sender.send(GiftCommand.this.messageRequestDeniedPartner, this.item);
            this.refund();
        }

        @Override
        protected void onCancel(@NotNull MarriagePlayer player) {
            player.send(GiftCommand.this.messageRequestCanceled, this.item);
            ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(GiftCommand.this.messageRequestCanceledPartner, this.item);
            this.refund();
        }

        @Override
        protected void onDisconnect(@NotNull MarriagePlayer player) {
            if (this.sender.equals(player)) {
                ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(GiftCommand.this.messageRequestCanceledDisconnectRequester, this.item);
            } else {
                player.send(GiftCommand.this.messageRequestCanceledDisconnectTarget, this.item);
            }
            this.refund();
        }

        private void refund() {
            Player player = (Player)this.sender.getPlayerOnline();
            if (player == null) {
                return;
            }
            HashMap left = player.getInventory().addItem(new ItemStack[]{this.item.getItemStack()});
            if (left.isEmpty()) {
                return;
            }
            left.values().forEach(i -> player.getWorld().dropItemNaturally(player.getLocation(), i));
            GiftCommand.this.messageRequestRefundInvFull.send((CommandSender)player, new Object[0]);
        }
    }
}

