/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.MessageBuilder;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageClickEvent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugCommand
extends MarryCommand {
    private final Message messageDone;
    private final Message messageStart;
    private BufferedWriter writer = null;

    public DebugCommand(@NotNull MarriageMaster plugin) {
        super((JavaPlugin)plugin, "debug", "Just for debug reasons", "marry.reload", true, new String[0]);
        MessageBuilder builder = new MessageBuilder("Please do not interact with your game for the next minute!", MessageColor.GOLD, new MessageFormat[0]);
        ((MessageBuilder)((MessageBuilder)builder.appendNewLine()).append("The plugin will now collect data about your server and plugins.", new MessageFormat[0])).appendNewLine();
        ((MessageBuilder)builder.append("This will involve opening inventory's.", new MessageFormat[0])).appendNewLine();
        builder.append("Please do not interact with your game till this is over!", MessageColor.RED, MessageFormat.BOLD);
        this.messageStart = (Message)builder.getMessage();
        builder = (MessageBuilder)new MessageBuilder("All data has been collected!", MessageColor.GREEN, MessageFormat.BOLD).appendNewLine();
        ((MessageBuilder)builder.append("You can now interact with your game again.", new MessageFormat[0])).appendNewLine();
        ((MessageBuilder)builder.append("The collected data can be found in your plugins' directory inside the 'debug.txt' file.", new MessageFormat[0])).appendNewLine();
        builder.append("Please upload this fiel to ", new MessageFormat[0]);
        ((MessageBuilder)builder.append("https://pastebin.com/", MessageColor.YELLOW, MessageFormat.UNDERLINE)).onClick(MessageClickEvent.ClickEventAction.OPEN_URL, "https://pastebin.com/");
        builder.append(" and send the link to the developer.", new MessageFormat[0]);
        this.messageDone = (Message)builder.getMessage();
    }

    @Override
    public void execute(@NotNull CommandSender commandSender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        if (this.writer != null) {
            return;
        }
        Player sender = (Player)commandSender;
        this.messageStart.send((CommandSender)sender, new Object[0]);
        File debugFile = new File(this.plugin.getDataFolder(), "debug.txt");
        if (debugFile.exists() && !debugFile.delete()) {
            this.plugin.getLogger().warning("Failed to delete debug.txt file!");
        }
        this.writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(debugFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        this.writer.append(this.plugin.getDescription().getName()).append(" Version: ").append(this.plugin.getDescription().getVersion());
        this.writer.append("\nServer: ").append(Bukkit.getServer().getBukkitVersion()).append(" (").append(Bukkit.getServer().getVersion()).append(")");
        this.writer.append("\nJava: ").append(System.getProperty("java.version"));
        this.writer.append("\n\nPlugins:\n");
        for (Plugin p : Bukkit.getServer().getPluginManager().getPlugins()) {
            this.writer.append(p.getName()).append(' ').append(p.getDescription().getVersion()).append('\n');
        }
        this.writer.append("\nPlugin Config:\n");
        try (BufferedReader configReader = new BufferedReader(new InputStreamReader(Files.newInputStream(new File(this.plugin.getDataFolder(), "config.yml").toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line;
            while ((line = configReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                if (line.contains("Host") || line.contains("Password") || line.contains("User")) {
                    line = line.replaceAll("^(\\s+\\w+):.*$", "$1: ********");
                }
                this.writer.append(line).append('\n');
            }
        }
        this.writer.append("\n\n\nSelf-test results:\n");
        ((MarriageMaster)this.getMarriagePlugin()).getPlaceholderManager().testPlaceholders(this.writer);
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.messageDone.send((CommandSender)sender, new Object[0]);
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender commandSender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return EMPTY_TAB_COMPLETE_LIST;
    }

    @Override
    @Nullable
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        return EMPTY_HELP_LIST;
    }
}

