/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.API.AcceptPendingRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.BackpackCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.ChatCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.CustomHelpCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.DebugCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.GiftCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.HelpCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.HomeCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.HugCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.KissCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.ListCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.ListPriestsCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.MarryDivorceCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.MarryMarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.PartnersCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.PvPCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.ReloadCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.RequestAcceptCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.RequestCancelCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.RequestDenyCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.SeenCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.SetColorCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.SetPriestCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.SurnameCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.TpCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.UpdateCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands.VersionCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Database.MarriagePlayerData;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Command.CommandExecutorWithSubCommandsGeneric;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Command.RegisterablePluginCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Command.SubCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManagerImplementation
extends CommandExecutorWithSubCommandsGeneric<MarryCommand>
implements CommandManager {
    private final MarriageMaster plugin;
    private String[] switchesOn;
    private String[] switchesOff;
    private String[] switchesToggle;
    private String[] switchesAll;
    private String[] switchesRemove;
    private RegisterablePluginCommand marryCommand;
    private MarryCommand marryActionCommand;
    private Message helpFormat;

    public CommandManagerImplementation(MarriageMaster plugin) {
        this.plugin = plugin;
    }

    public void init() {
        this.switchesOn = this.plugin.getLanguage().getSwitch("On", "on");
        this.switchesOff = this.plugin.getLanguage().getSwitch("Off", "off");
        this.switchesToggle = this.plugin.getLanguage().getSwitch("Toggle", "toggle");
        this.switchesAll = this.plugin.getLanguage().getSwitch("All", "all");
        this.switchesRemove = this.plugin.getLanguage().getSwitch("Remove", "remove");
        this.marryCommand = new RegisterablePluginCommand((Plugin)this.plugin, "marry", this.plugin.getLanguage().getCommandAliases("Main"));
        this.marryCommand.registerCommand();
        this.marryCommand.setExecutor(this);
        this.marryCommand.setTabCompleter((TabCompleter)this);
        this.helpFormat = (Message)((Message)((Message)((Message)this.plugin.getLanguage().getMessage("Commands.HelpFormat").placeholder("MainCommand")).placeholder("SubCommand")).placeholder("Parameters")).placeholder("Description");
        try {
            Reflection.setStaticField(MarryCommand.class, "marriagePlugin", this.plugin);
            Reflection.setStaticField(MarryCommand.class, "showHelp", this.getClass().getDeclaredMethod("sendHelp", CommandSender.class, String.class, Collection.class));
            Reflection.setStaticField(MarryCommand.class, "messageNoPermission", CommonMessages.getMessageNoPermission());
            Reflection.setStaticField(MarryCommand.class, "messageNotFromConsole", CommonMessages.getMessageNotFromConsole());
            Reflection.setStaticField(MarryCommand.class, "messageNotMarried", CommonMessages.getMessageNotMarried());
            Reflection.setStaticField(MarryCommand.class, "helpPartnerSelector", "<" + CommonMessages.getHelpPartnerNameVariable() + ">");
            Reflection.setStaticField(AcceptPendingRequest.class, "closeMethod", MarriagePlayerData.class.getMethod("closeRequest", at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest.class));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, (Object)((Object)ConsoleColor.RED) + "Unable to set the help format. Default format will be used." + (Object)((Object)ConsoleColor.RESET), e);
        }
        this.registerSubCommand(new ListCommand(this.plugin));
        this.registerSubCommand(new ListPriestsCommand(this.plugin));
        if (this.plugin.areMultiplePartnersAllowed()) {
            this.registerSubCommand(new PartnersCommand(this.plugin));
        }
        this.marryActionCommand = new MarryMarryCommand(this.plugin);
        this.registerSubCommand(this.marryActionCommand);
        this.registerSubCommand(new MarryDivorceCommand(this.plugin));
        if (this.plugin.getConfiguration().isChatEnabled()) {
            this.registerSubCommand(new ChatCommand(this.plugin));
        }
        this.registerSubCommand(new TpCommand(this.plugin));
        this.registerSubCommand(new HomeCommand(this.plugin));
        if (this.plugin.getConfiguration().getPvPAllowBlocking()) {
            this.registerSubCommand(new PvPCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isGiftEnabled()) {
            this.registerSubCommand(new GiftCommand(this.plugin));
        }
        if (this.plugin.getBackpacksIntegration() != null && this.plugin.getConfiguration().isBackpackShareEnabled()) {
            this.registerSubCommand(new BackpackCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isKissEnabled()) {
            this.registerSubCommand(new KissCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isHugEnabled()) {
            this.registerSubCommand(new HugCommand(this.plugin));
        }
        this.registerSubCommand(new SeenCommand(this.plugin));
        if (this.plugin.getConfiguration().isAllowPlayersToChangeMarriageColor()) {
            this.registerSubCommand(new SetColorCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isSurnamesEnabled()) {
            this.registerSubCommand(new SurnameCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isSetPriestCommandEnabled()) {
            this.registerSubCommand(new SetPriestCommand(this.plugin));
        }
        this.registerSubCommand(new UpdateCommand(this.plugin));
        this.registerSubCommand(new ReloadCommand(this.plugin));
        this.registerSubCommand(new VersionCommand(this.plugin));
        HelpCommand helpCommand = new HelpCommand(this.plugin, this.commands);
        this.registerSubCommand(helpCommand);
        this.registerSubCommand(new RequestAcceptCommand(this.plugin));
        this.registerSubCommand(new RequestDenyCommand(this.plugin));
        this.registerSubCommand(new RequestCancelCommand(this.plugin));
        this.registerSubCommand(new DebugCommand(this.plugin));
        switch (this.plugin.getConfiguration().getDefaultCommand()) {
            case "customhelp": 
            case "custom_help": {
                this.setDefaultSubCommand(new CustomHelpCommand(this.plugin));
                break;
            }
            default: {
                this.setDefaultSubCommand(helpCommand);
            }
        }
    }

    @Override
    public void close() {
        this.marryCommand.unregisterCommand();
        super.close();
    }

    public void sendHelp(CommandSender target, String marryAlias, Collection<HelpData> data) {
        for (HelpData d : data) {
            this.helpFormat.send(target, marryAlias, d.getTranslatedSubCommand(), d.getParameter(), d.getDescription());
        }
    }

    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length > 0) {
            SubCommand subCommand = (SubCommand)this.subCommandMap.get(args[0].toLowerCase(Locale.ENGLISH));
            if (subCommand != null) {
                subCommand.doExecute(sender, alias, args[0], args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
                return true;
            }
            Player target = this.plugin.getServer().getPlayer(args[0]);
            if (target != null && args.length <= 2) {
                this.marryActionCommand.doExecute(sender, alias, "marry", args);
                return true;
            }
        }
        ((MarryCommand)this.defaultSubCommand).doExecute(sender, alias, "help", args);
        return true;
    }

    @Override
    public boolean isOnSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesOn, str);
    }

    @Override
    public boolean isOffSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesOff, str);
    }

    @Override
    public boolean isToggleSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesToggle, str);
    }

    @Override
    public boolean isAllSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesAll, str);
    }

    @Override
    public boolean isRemoveSwitch(@Nullable String str) {
        return StringUtils.arrayContainsIgnoreCase(this.switchesRemove, str);
    }

    @Override
    @NotNull
    public String getOnSwitchTranslation() {
        return this.switchesOn[0];
    }

    @Override
    @NotNull
    public String getOffSwitchTranslation() {
        return this.switchesOff[0];
    }

    @Override
    @NotNull
    public String getToggleSwitchTranslation() {
        return this.switchesToggle[0];
    }

    @Override
    @NotNull
    public String getAllSwitchTranslation() {
        return this.switchesAll[0];
    }

    @Override
    @NotNull
    public String getRemoveSwitchTranslation() {
        return this.switchesRemove[0];
    }

    @Override
    @Nullable
    public List<String> getSimpleTabComplete(@NotNull CommandSender sender, String ... args) {
        List<String> names = null;
        if (sender instanceof Player && this.plugin.areMultiplePartnersAllowed() && args != null && args.length == 1 && (names = this.plugin.getPlayerData((OfflinePlayer)((Player)sender)).getMatchingPartnerNames(args[0])).isEmpty()) {
            names = null;
        }
        return names;
    }

    @Override
    public boolean registerAcceptPendingRequest(@NotNull at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest request) {
        if (((MarriagePlayer)request.getPlayerThatHasToAccept()).getOpenRequest() != null || !((MarriagePlayer)request.getPlayerThatHasToAccept()).isOnline() || !(request.getPlayerThatHasToAccept() instanceof MarriagePlayerData)) {
            return false;
        }
        for (MarriagePlayer p : (MarriagePlayer[])request.getPlayersThatCanCancel()) {
            if (p instanceof MarriagePlayerData && p.isOnline()) continue;
            return false;
        }
        for (MarriagePlayer p : (MarriagePlayer[])request.getPlayersThatCanCancel()) {
            ((MarriagePlayerData)p).addRequest(request);
        }
        ((MarriagePlayerData)request.getPlayerThatHasToAccept()).addRequest(request);
        if (!((MarriagePlayer)request.getPlayerThatHasToAccept()).hasPermission("marry.accept")) {
            request.deny(request.getPlayerThatHasToAccept());
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        List<String> results = super.onTabComplete(sender, command, alias, args);
        if (results != null && (args.length == 1 && this.marryActionCommand.canUse(sender) || results.isEmpty() && args.length == 2 && (!(sender instanceof Player) || this.plugin.getPlayerData((OfflinePlayer)((Player)sender)).isPriest()))) {
            results.addAll(this.marryActionCommand.tabComplete(sender, alias, "marry", args));
        }
        return results;
    }
}

