/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarriageMasterCancellableEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarryChatEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarryChatMultiTargetEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageFormat;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ChatCommand
extends MarryCommand
implements Listener {
    private final Message messageJoined;
    private final Message messageLeft;
    private final Message messageListeningStarted;
    private final Message messageListeningStopped;
    private final Message messageTargetSet;
    private final String displayNameAll;
    private final String helpParameterMessage;
    private final String privateMessageFormat;
    private final String setTargetDescription;
    private final Set<Player> listeners = ConcurrentHashMap.newKeySet();
    private final String[] setTargetParameters;
    private final String[] switchesToggle;
    private final String[] switchesAll;
    private final boolean allowChatSurveillance;
    private MarryCommand chatToggleCommand;
    private MarryCommand chatListenCommand;

    public ChatCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "chat", plugin.getLanguage().getTranslated("Commands.Description.Chat"), "marry.chat", true, true, plugin.getLanguage().getCommandAliases("Chat"));
        this.messageJoined = plugin.getLanguage().getMessage("Ingame.Chat.Joined");
        this.messageLeft = plugin.getLanguage().getMessage("Ingame.Chat.Left");
        this.messageListeningStarted = plugin.getLanguage().getMessage("Ingame.Chat.ListeningStarted");
        this.messageListeningStopped = plugin.getLanguage().getMessage("Ingame.Chat.ListeningStopped");
        this.messageTargetSet = plugin.getLanguage().getMessage("Ingame.Chat.TargetSet");
        this.privateMessageFormat = plugin.getLanguage().getMessage("Ingame.Chat.Format").getFallback().replace("{SenderDisplayName}", "%1$s").replace("{ReceiverDisplayName}", "%2$s").replace("{Message}", "%3$s").replace("{SenderName}", "%4$s").replace("{ReceiverName}", "%5$s").replace("{MagicHeart}", "%6$s");
        this.displayNameAll = plugin.getLanguage().getTranslated("Ingame.Chat.DisplayNameAll");
        this.helpParameterMessage = "<" + plugin.getLanguage().getTranslated("Commands.MessageVariable") + ">";
        this.setTargetDescription = plugin.getLanguage().getTranslated("Commands.Description.ChatSetTarget");
        this.setTargetParameters = plugin.getLanguage().getCommandAliases("ChatSetTarget", new String[]{"target", "settarget"});
        this.switchesToggle = plugin.getLanguage().getSwitch("Toggle", "toggle");
        this.switchesAll = plugin.getLanguage().getSwitch("All", "all");
        this.allowChatSurveillance = plugin.getConfiguration().isChatSurveillanceEnabled();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void afterRegister() {
        MarriageMaster plugin = (MarriageMaster)this.getMarriagePlugin();
        this.chatToggleCommand = new ChatToggleCommand(plugin, this);
        plugin.getCommandManager().registerSubCommand(this.chatToggleCommand);
        if (this.allowChatSurveillance) {
            this.chatListenCommand = new ChatListenCommand(plugin, this);
            plugin.getCommandManager().registerSubCommand(this.chatListenCommand);
        }
    }

    @Override
    public void beforeUnregister() {
        MarriageMaster plugin = (MarriageMaster)this.getMarriagePlugin();
        plugin.getCommandManager().unRegisterSubCommand(this.chatToggleCommand);
        this.chatToggleCommand.close();
        if (this.allowChatSurveillance) {
            plugin.getCommandManager().unRegisterSubCommand(this.chatListenCommand);
            this.chatListenCommand.close();
        }
    }

    @Override
    public void close() {
        this.listeners.clear();
        if (this.chatToggleCommand != null) {
            this.chatToggleCommand.close();
            this.chatToggleCommand = null;
        }
        if (this.chatListenCommand != null) {
            this.chatListenCommand.close();
            this.chatListenCommand = null;
        }
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer player = (at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
            if (args.length == 0) {
                this.showHelp(sender, mainCommandAlias);
            } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isToggleSwitch(args[0])) {
                this.toggleChatSetting(player);
            } else if (this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2 && StringUtils.arrayContainsIgnoreCase(this.setTargetParameters, args[0])) {
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target != null && player.isPartner(target)) {
                    player.setPrivateChatTarget(this.getMarriagePlugin().getPlayerData(target));
                    this.messageTargetSet.send(sender, new Object[0]);
                } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isAllSwitch(args[1])) {
                    player.setPrivateChatTarget((Marriage)null);
                    this.messageTargetSet.send(sender, new Object[0]);
                } else {
                    CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
                }
            } else if (player.getPrivateChatTarget() == null || ((at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer)((Marriage)player.getPrivateChatTarget()).getPartner(player)).isOnline()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < args.length; ++i) {
                    if (i != 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(args[i]);
                }
                this.doChat(player, stringBuilder.toString());
            } else {
                CommonMessages.getMessagePartnerOffline().send(sender, new Object[0]);
            }
        });
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> data;
        block7: {
            data = new ArrayList<String>();
            if (args.length <= 0) break block7;
            if (args.length == 2 && StringUtils.arrayContainsIgnoreCase(this.setTargetParameters, args[0])) {
                at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer player = (at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
                data.addAll(player.getMatchingPartnerNames(args[1]));
                String string = args[1].toLowerCase(Locale.ENGLISH);
                for (String s : this.switchesAll) {
                    if (!s.toLowerCase(Locale.ENGLISH).startsWith(string)) continue;
                    data.add(s);
                }
            } else {
                if (args.length == 1) {
                    String arg = args[0].toLowerCase(Locale.ENGLISH);
                    for (String s : this.switchesToggle) {
                        if (!s.toLowerCase(Locale.ENGLISH).startsWith(arg)) continue;
                        data.add(s);
                    }
                    for (String s : this.setTargetParameters) {
                        if (!s.toLowerCase(Locale.ENGLISH).startsWith(arg)) continue;
                        data.add(s);
                    }
                }
                Player playerSender = (Player)sender;
                String string = args[args.length - 1].toLowerCase(Locale.ENGLISH);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase(Locale.ENGLISH).startsWith(string) || !playerSender.canSee(player)) continue;
                    data.add(player.getName());
                }
            }
        }
        return data.isEmpty() ? null : data;
    }

    @Override
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        ArrayList<HelpData> help = new ArrayList<HelpData>();
        help.add(new HelpData(this.getTranslatedName(), this.helpParameterMessage, this.getDescription()));
        if (this.getMarriagePlugin().areMultiplePartnersAllowed()) {
            help.add(new HelpData(this.getTranslatedName() + " " + this.setTargetParameters[0], "<" + CommonMessages.getHelpPartnerNameVariable() + " / " + ((CommandManager)this.getMarriagePlugin().getCommandManager()).getAllSwitchTranslation() + ">", this.setTargetDescription));
        }
        return help;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent event) {
        at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer player = (at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer)this.getMarriagePlugin().getPlayerData(event.getPlayer());
        if (player.isPrivateChatDefault()) {
            event.setCancelled(true);
            this.doChat(player, event.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLeave(PlayerQuitEvent event) {
        if (this.allowChatSurveillance) {
            this.listeners.remove(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.allowChatSurveillance && event.getPlayer().hasPermission("marry.listenchat.autojoin")) {
            this.listeners.add(event.getPlayer());
        }
    }

    private void toggleChatSetting(at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer player) {
        if (player.isPrivateChatDefault()) {
            player.setPrivateChatDefault(false);
            player.send(this.messageLeft, new Object[0]);
        } else {
            player.setPrivateChatDefault(true);
            player.send(this.messageJoined, new Object[0]);
        }
    }

    private void toggleListenChat(Player player, boolean on) {
        if (on) {
            this.listeners.add(player);
            this.messageListeningStarted.send((CommandSender)player, new Object[0]);
        } else {
            this.listeners.remove(player);
            this.messageListeningStopped.send((CommandSender)player, new Object[0]);
        }
    }

    private void toggleListenChat(Player player) {
        this.toggleListenChat(player, !this.listeners.contains(player));
    }

    private Player getRecipient(at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer sender, List<Marriage> recipients) {
        Player recipient = null;
        if (sender.getPrivateChatTarget() == null) {
            MarriagePlayer last = null;
            for (Marriage m : sender.getMultiMarriageData()) {
                at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer p = (at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer)m.getPartner(sender);
                if (p == null || !p.isOnline() || p.getPlayerOnline() == null) continue;
                last = p;
                recipients.add(m);
            }
            if (recipients.size() == 1 && last != null) {
                recipient = (Player)last.getPlayerOnline();
            }
        } else {
            OfflinePlayer player2 = (OfflinePlayer)((at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer)((Marriage)sender.getPrivateChatTarget()).getPartner(sender)).getPlayer();
            if (player2.isOnline() && player2.getPlayer() != null) {
                recipient = player2.getPlayer();
                recipients.add((Marriage)sender.getPrivateChatTarget());
            }
        }
        return recipient;
    }

    @NotNull
    private List<Player> collectRecipientPlayers(at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer sender, Player recipient, List<Marriage> recipients) {
        ArrayList<Player> playerRecipients;
        if (recipient == null) {
            playerRecipients = new ArrayList(this.listeners.size() + recipients.size() + 1);
            for (Marriage target : recipients) {
                Player p = (Player)((at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer)target.getPartner(sender)).getPlayerOnline();
                if (this.listeners.contains(p)) continue;
                playerRecipients.add(p);
            }
        } else {
            playerRecipients = new ArrayList<Player>(this.listeners.size() + 2);
            if (!this.listeners.contains(recipient)) {
                playerRecipients.add(recipient);
            }
        }
        if (!this.listeners.contains(sender.getPlayerOnline())) {
            playerRecipients.add((Player)sender.getPlayerOnline());
        }
        playerRecipients.addAll(this.listeners);
        return playerRecipients;
    }

    private void doChat(at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer sender, String msg) {
        MarriageMasterCancellableEvent marryChatEvent;
        ArrayList<Marriage> recipients = new ArrayList<Marriage>(sender.getMultiMarriageData().size());
        Player recipient = this.getRecipient(sender, recipients);
        if (recipients.isEmpty()) {
            sender.send(CommonMessages.getMessagePartnerOffline(), new Object[0]);
            return;
        }
        String magicHeart = "266\u2764\u00a7f";
        if (recipients.size() == 1) {
            marryChatEvent = new MarryChatEvent(sender, (Marriage)recipients.get(0), msg);
            Bukkit.getPluginManager().callEvent((Event)marryChatEvent);
            if (marryChatEvent.isCancelled()) {
                return;
            }
            msg = ((MarryChatEvent)marryChatEvent).getMessage();
            magicHeart = ((Marriage)recipients.get(0)).getMagicHeart();
        } else {
            marryChatEvent = new MarryChatMultiTargetEvent(sender, recipients, msg);
            Bukkit.getPluginManager().callEvent((Event)marryChatEvent);
            if (marryChatEvent.isCancelled() || recipients.isEmpty()) {
                return;
            }
            msg = ((MarryChatMultiTargetEvent)marryChatEvent).getMessage();
            if (recipients.size() == 1) {
                recipient = (Player)((at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer)((Marriage)recipients.get(0)).getPartner(sender)).getPlayerOnline();
                magicHeart = ((Marriage)recipients.get(0)).getMagicHeart();
            }
        }
        msg = ChatCommand.cleanupMessage(msg, sender);
        List<Player> playerRecipients = this.collectRecipientPlayers(sender, recipient, recipients);
        String recipientDisplayName = recipient != null ? recipient.getDisplayName() : this.displayNameAll;
        String recipientName = recipient != null ? recipient.getName() : this.displayNameAll;
        String formattedMessage = String.format(this.privateMessageFormat, sender.getDisplayName(), recipientDisplayName, msg, sender.getName(), recipientName, magicHeart);
        Message message = new Message(formattedMessage);
        message.send(playerRecipients, new Object[0]);
        if (this.allowChatSurveillance) {
            this.plugin.getServer().getConsoleSender().sendMessage(formattedMessage);
        }
    }

    @NotNull
    private static String cleanupMessage(@NotNull String msg, @NotNull at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer sender) {
        msg = msg.replace('\u00a7', '&');
        if (sender.hasPermission("marry.chat.color")) {
            msg = MessageColor.translateAlternateColorCodes(msg);
        }
        if (sender.hasPermission("marry.chat.format")) {
            msg = MessageFormat.translateAlternateFormatCodes(msg);
        }
        msg = sender.hasPermission("marry.chat.magic") ? msg.replace("&k", MessageFormat.MAGIC.toString()) : msg.replace(MessageFormat.MAGIC.toString(), "&k");
        return msg;
    }

    public static class ChatListenCommand
    extends MarryCommand {
        private ChatCommand chatCommand;

        public ChatListenCommand(MarriageMaster plugin, ChatCommand chatCommand) {
            super((JavaPlugin)plugin, "listenchat", plugin.getLanguage().getTranslated("Commands.Description.ChatListen"), "marry.listenchat", true, plugin.getLanguage().getCommandAliases("ChatListen"));
            this.chatCommand = chatCommand;
        }

        @Override
        public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            if (args.length == 1) {
                if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isToggleSwitch(args[0])) {
                    this.chatCommand.toggleListenChat((Player)sender);
                } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isOnSwitch(args[0])) {
                    this.chatCommand.toggleListenChat((Player)sender, true);
                } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isOffSwitch(args[0])) {
                    this.chatCommand.toggleListenChat((Player)sender, false);
                } else {
                    this.showHelp(sender, mainCommandAlias);
                }
            } else {
                this.chatCommand.toggleListenChat((Player)sender);
            }
        }

        @Override
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            return EMPTY_TAB_COMPLETE_LIST;
        }

        @Override
        public void close() {
            this.chatCommand = null;
        }
    }

    public static class ChatToggleCommand
    extends MarryCommand {
        private ChatCommand chatCommand;

        public ChatToggleCommand(MarriageMaster plugin, ChatCommand chatCommand) {
            super((JavaPlugin)plugin, "chattoggle", plugin.getLanguage().getTranslated("Commands.Description.ChatToggle"), "marry.chat", true, plugin.getLanguage().getCommandAliases("ChatToggle"));
            this.chatCommand = chatCommand;
        }

        @Override
        public void close() {
            this.chatCommand = null;
        }

        @Override
        public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            this.chatCommand.toggleChatSetting((at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender));
        }

        @Override
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            return null;
        }
    }
}

