/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Commands;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.Range;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.HelpData;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BackpackCommand
extends MarryCommand {
    private final Message messageOnlyInSurvival;
    private final Message messageShareOff;
    private final Message messageShareOn;
    private final Message messageOpened;
    private final Message messageShareDenied;
    private final String descriptionOn;
    private final String descriptionOff;
    private final double range;

    public BackpackCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "backpack", plugin.getLanguage().getTranslated("Commands.Description.Backpack"), "marry.backpack", true, true, plugin.getLanguage().getCommandAliases("Backpack"));
        this.messageOnlyInSurvival = plugin.getLanguage().getMessage("Ingame.Backpack.OnlyInSurvival");
        this.messageShareOn = plugin.getLanguage().getMessage("Ingame.Backpack.ShareOn");
        this.messageShareOff = plugin.getLanguage().getMessage("Ingame.Backpack.ShareOff");
        this.messageOpened = plugin.getLanguage().getMessage("Ingame.Backpack.Opened");
        this.messageShareDenied = plugin.getLanguage().getMessage("Ingame.Backpack.ShareDenied");
        this.descriptionOn = plugin.getLanguage().getTranslated("Commands.Description.BackpackOn");
        this.descriptionOff = plugin.getLanguage().getTranslated("Commands.Description.BackpackOff");
        this.range = plugin.getConfiguration().getRangeSquared(Range.Backpack);
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        if (((MarriageMaster)this.getMarriagePlugin()).getBackpacksIntegration() == null) {
            return;
        }
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        if (args.length == 1) {
            if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isOnSwitch(args[0])) {
                player.setShareBackpack(true);
                this.messageShareOn.send(sender, new Object[0]);
            } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isOffSwitch(args[0])) {
                player.setShareBackpack(false);
                this.messageShareOff.send(sender, new Object[0]);
            } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isToggleSwitch(args[0])) {
                if (player.isSharingBackpack()) {
                    player.setShareBackpack(false);
                    this.messageShareOff.send(sender, new Object[0]);
                } else {
                    player.setShareBackpack(true);
                    this.messageShareOn.send(sender, new Object[0]);
                }
            } else if (this.getMarriagePlugin().areMultiplePartnersAllowed()) {
                MarriagePlayer partner = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
                if (player.isPartner(partner)) {
                    this.openBackpack(player, partner);
                } else {
                    CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
                }
            } else {
                this.showHelp(sender, mainCommandAlias);
            }
        } else if (player.getNearestPartnerMarriageData() != null) {
            this.openBackpack(player, (MarriagePlayer)player.getNearestPartnerMarriageData().getPartner(player));
        }
    }

    private void openBackpack(MarriagePlayer opener, MarriagePlayer partner) {
        Player sender = (Player)opener.getPlayerOnline();
        if (sender.getGameMode() == GameMode.SURVIVAL || sender.hasPermission("marry.bypass.backpackgamemode")) {
            Player partnerPlayer = (Player)partner.getPlayerOnline();
            if (partnerPlayer == null || !partnerPlayer.isOnline()) {
                CommonMessages.getMessagePartnerOffline().send((CommandSender)sender, new Object[0]);
            } else if (partner.isSharingBackpack()) {
                if (this.getMarriagePlugin().isInRangeSquared(sender, partnerPlayer, this.range)) {
                    ((MarriageMaster)this.getMarriagePlugin()).getBackpacksIntegration().openBackpack(sender, partnerPlayer, true);
                    this.messageOpened.send((CommandSender)partnerPlayer, new Object[0]);
                } else {
                    CommonMessages.getMessagePartnerNotInRange().send((CommandSender)sender, new Object[0]);
                }
            } else {
                this.messageShareDenied.send((CommandSender)sender, new Object[0]);
            }
        } else {
            this.messageOnlyInSurvival.send((CommandSender)sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
    }

    @Override
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)requester);
        if (player.isMarried()) {
            List<HelpData> helpList = super.getHelp(requester);
            if (player.isSharingBackpack()) {
                helpList.add(new HelpData(this.getTranslatedName() + " " + ((CommandManager)this.getMarriagePlugin().getCommandManager()).getOffSwitchTranslation(), null, this.descriptionOff));
            } else {
                helpList.add(new HelpData(this.getTranslatedName() + " " + ((CommandManager)this.getMarriagePlugin().getCommandManager()).getOnSwitchTranslation(), null, this.descriptionOn));
            }
            return helpList;
        }
        return EMPTY_HELP_LIST;
    }
}

