/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.BackpackIntegration;

import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.BackpackIntegration.BackpackPluginIncompatibleException;
import at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.BackpackIntegration.IBackpackIntegration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import at.pcgamingfreaks.MinePacks.MinePacks;
import java.util.MissingResourceException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MinepacksV1Integration
implements IBackpackIntegration {
    private static final String PLUGIN_NAME = "MinePacks";
    private static final Version MIN_VERSION = new Version("1.17.7");
    private MinePacks minepacks;
    private final String version;

    public MinepacksV1Integration() throws NullPointerException, BackpackPluginIncompatibleException {
        Plugin bukkitPlugin = Bukkit.getPluginManager().getPlugin(PLUGIN_NAME);
        if (!(bukkitPlugin instanceof MinePacks)) {
            throw new MissingResourceException("Plugin MinePacks is not available!", this.getClass().getName(), PLUGIN_NAME);
        }
        this.version = bukkitPlugin.getDescription().getVersion();
        Version installedVersion = new Version(this.version, true);
        if (MIN_VERSION.newerThan(installedVersion)) {
            throw new BackpackPluginIncompatibleException("Your Minepacks version is outdated! Please update in order to use it with this plugin!\nYou have installed: " + installedVersion + " Required: " + MIN_VERSION);
        }
        this.minepacks = (MinePacks)bukkitPlugin;
    }

    @Override
    public void openBackpack(@NotNull Player opener, @NotNull Player owner, boolean editable) {
        this.minepacks.openBackpack(opener, (OfflinePlayer)owner, editable);
    }

    @Override
    public void close() {
        this.minepacks = null;
    }

    @Override
    @NotNull
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean isBackpackItem(ItemStack item) {
        return false;
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

