/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Listener;

import at.pcgamingfreaks.MarriageMaster.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Database.ILanguage;
import at.pcgamingfreaks.MarriageMaster.Placeholder.Placeholders;
import at.pcgamingfreaks.Message.Message;
import at.pcgamingfreaks.Message.Placeholder.Processors.FormattedStringPlaceholderProcessor;
import at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class JoinLeaveInfoBase {
    private final Message messageOnline;
    private final Message messageOffline;
    private final Message messageNowOnline;
    private final Message messageNowOffline;
    private final Message messageAllOffline;
    private final Message messageOnlineMulti;
    private final String multiOnlineFormat;
    private final String multiOnlineSeparator;

    protected JoinLeaveInfoBase(@NotNull ILanguage language) {
        this.messageOnline = language.getMessage("Ingame.JoinLeaveInfo.PartnerOnline");
        this.messageOffline = language.getMessage("Ingame.JoinLeaveInfo.PartnerOffline");
        this.messageAllOffline = language.getMessage("Ingame.JoinLeaveInfo.AllPartnersOffline");
        this.messageNowOnline = language.getMessage("Ingame.JoinLeaveInfo.PartnerNowOnline").placeholders(Placeholders.PLAYER_NAME);
        this.messageNowOffline = language.getMessage("Ingame.JoinLeaveInfo.PartnerNowOffline").placeholders(Placeholders.PLAYER_NAME);
        this.messageOnlineMulti = language.getMessage("Ingame.JoinLeaveInfo.PartnerOnlineMulti").placeholder("OnlinePartners", (IPlaceholderProcessor)FormattedStringPlaceholderProcessor.INSTANCE);
        this.multiOnlineFormat = language.getTranslated("Ingame.JoinLeaveInfo.MultiOnlineFormat").replace("{Name}", "%1$s").replace("{DisplayName}", "%2$s");
        this.multiOnlineSeparator = language.getTranslated("Ingame.JoinLeaveInfo.MultiOnlineSeparator");
    }

    protected abstract void runTaskLater(@NotNull Runnable var1);

    public void onJoin(MarriagePlayer player) {
        for (Object partner : player.getOnlinePartners()) {
            MarriagePlayer mpPartner = (MarriagePlayer)partner;
            if (!mpPartner.canSee(player)) continue;
            mpPartner.send(this.messageNowOnline, player);
        }
        this.runTaskLater(player.getPartners().size() == 1 ? new OnePartnerRunnable(player) : new MultiPartnerRunnable(player));
    }

    public void onLeave(MarriagePlayer player) {
        for (Object partner : player.getOnlinePartners()) {
            MarriagePlayer mpPartner = (MarriagePlayer)partner;
            if (!mpPartner.canSee(player)) continue;
            mpPartner.send(this.messageNowOffline, player);
        }
    }

    private class MultiPartnerRunnable
    implements Runnable {
        private MarriagePlayer player;

        public MultiPartnerRunnable(MarriagePlayer player) {
            this.player = player;
        }

        @Override
        public void run() {
            if (this.player.isOnline()) {
                Collection onlinePartners = this.player.getOnlinePartners();
                StringBuilder stringBuilder = new StringBuilder();
                String separator = "";
                for (MarriagePlayer p : onlinePartners) {
                    if (!this.player.canSee(p)) continue;
                    stringBuilder.append(separator);
                    separator = JoinLeaveInfoBase.this.multiOnlineSeparator;
                    stringBuilder.append(String.format(JoinLeaveInfoBase.this.multiOnlineFormat, p.getName(), p.getDisplayName()));
                }
                if (stringBuilder.length() == 0) {
                    this.player.send(JoinLeaveInfoBase.this.messageAllOffline, new Object[0]);
                } else {
                    this.player.send(JoinLeaveInfoBase.this.messageOnlineMulti, stringBuilder.toString());
                }
            }
        }
    }

    private class OnePartnerRunnable
    implements Runnable {
        private MarriagePlayer player;

        public OnePartnerRunnable(MarriagePlayer player) {
            this.player = player;
        }

        @Override
        public void run() {
            Object partner;
            if (this.player.isOnline() && (partner = this.player.getPartner()) != null) {
                this.player.send(partner.isOnline() && this.player.canSee(partner) ? JoinLeaveInfoBase.this.messageOnline : JoinLeaveInfoBase.this.messageOffline, new Object[0]);
            }
        }
    }
}

