/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Database;

import at.pcgamingfreaks.Database.Cache.ICacheablePlayer;
import at.pcgamingfreaks.MarriageMaster.API.Home;
import at.pcgamingfreaks.MarriageMaster.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Database.BaseDatabase;
import at.pcgamingfreaks.MarriageMaster.Database.DatabaseElement;
import at.pcgamingfreaks.Message.IMessage;
import at.pcgamingfreaks.Message.MessageBuilder;
import at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.UUIDConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarriagePlayerDataBase<MARRIAGE_PLAYER extends MarriagePlayer, COMMAND_SENDER, HOME extends Home, MARRIAGE extends Marriage<MARRIAGE_PLAYER, COMMAND_SENDER, HOME>, PLAYER, PLAYER_ONLINE, MESSAGE extends IMessage>
implements DatabaseElement,
MarriagePlayer<MARRIAGE, MARRIAGE_PLAYER, PLAYER, PLAYER_ONLINE, MESSAGE>,
ICacheablePlayer {
    private String name;
    private String offlineDisplayName;
    private final UUID uuid;
    private final int hash;
    private boolean priest = false;
    private boolean privateChat = false;
    private boolean sharesBackpack = false;
    private boolean married = false;
    private Object databaseKey = null;
    private MARRIAGE privateChatTarget = null;
    private final Map<MARRIAGE_PLAYER, MARRIAGE> partnersMarriages = new ConcurrentHashMap<MARRIAGE_PLAYER, MARRIAGE>();
    protected MessageComponent displayNameMessageComponent;
    protected MessageComponent offlineDisplayNameMessageComponent;
    private int lastKnownDisplayNameHash;

    protected MarriagePlayerDataBase(@Nullable UUID uuid, @NotNull String name) {
        this.setName(name);
        this.uuid = uuid != null ? uuid : UUIDConverter.getUUIDFromNameAsUUID((String)name, (boolean)false);
        this.hash = this.uuid.hashCode();
    }

    protected MarriagePlayerDataBase(@Nullable UUID uuid, @NotNull String name, boolean priest) {
        this(uuid, name);
        this.priest = priest;
    }

    protected MarriagePlayerDataBase(@Nullable UUID uuid, @NotNull String name, boolean priest, boolean sharesBackpack, @Nullable Object databaseKey) {
        this(uuid, name, priest);
        this.sharesBackpack = sharesBackpack;
        this.databaseKey = databaseKey;
    }

    public boolean equals(Object otherPlayer) {
        return otherPlayer instanceof MarriagePlayerDataBase && this.uuid.equals(((MarriagePlayerDataBase)otherPlayer).uuid);
    }

    public int hashCode() {
        return this.hash;
    }

    public void setName(@NotNull String name) {
        this.name = name;
        this.offlineDisplayName = MessageColor.GRAY + name;
        this.offlineDisplayNameMessageComponent = new MessageBuilder().appendLegacy(this.offlineDisplayName).getAsComponent();
    }

    public void setPriestData(boolean is) {
        this.priest = is;
    }

    public void setSharesBackpack(boolean state) {
        this.sharesBackpack = state;
    }

    public void addMarriage(MARRIAGE marriage) {
        this.partnersMarriages.put(marriage.getPartner(this), marriage);
        this.married = true;
    }

    public void removeMarriage(MARRIAGE marriage) {
        this.partnersMarriages.remove(marriage.getPartner(this));
        boolean bl = this.married = !this.partnersMarriages.isEmpty();
        if (marriage.equals(this.privateChatTarget)) {
            this.privateChatTarget = null;
        }
    }

    @Nullable
    public abstract String getOnlineName();

    @Override
    public boolean canSee(@NotNull MARRIAGE_PLAYER player) {
        return this.canSee((MARRIAGE_PLAYER)player.getPlayerOnline());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.name;
    }

    @NotNull
    public MessageComponent getDisplayNameMessageComponent() {
        if (!this.isOnline()) {
            return this.offlineDisplayNameMessageComponent;
        }
        boolean computeComponent = this.displayNameMessageComponent == null;
        String displayName = this.getDisplayName();
        if (!computeComponent) {
            boolean bl = computeComponent = this.lastKnownDisplayNameHash != displayName.hashCode();
        }
        if (computeComponent) {
            MessageBuilder builder = new MessageBuilder((MessageComponent)null);
            builder.appendLegacy(displayName);
            this.displayNameMessageComponent = builder.getAsComponent();
            this.lastKnownDisplayNameHash = displayName.hashCode();
        }
        return this.displayNameMessageComponent;
    }

    @Override
    @NotNull
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public boolean isPriest() {
        return this.priest || this.hasPermission("marry.priest");
    }

    @Override
    public void setPriest(boolean set) {
        this.priest = set;
        BaseDatabase.getInstance().updatePriestStatus(this);
    }

    @Override
    public boolean isSharingBackpack() {
        return this.sharesBackpack;
    }

    @Override
    public void setShareBackpack(boolean share) {
        this.sharesBackpack = share;
        BaseDatabase.getInstance().updateBackpackShareState(this);
    }

    @Override
    public void setPrivateChatDefault(boolean enable) {
        this.privateChat = enable;
    }

    @Override
    public boolean isPrivateChatDefault() {
        return this.privateChat && this.isMarried();
    }

    @Override
    public MARRIAGE getPrivateChatTarget() {
        return this.privateChatTarget;
    }

    @Override
    public void setPrivateChatTarget(MARRIAGE_PLAYER target) {
        this.privateChatTarget = this.getMarriageData(target);
    }

    @Override
    public void setPrivateChatTarget(MARRIAGE target) {
        this.privateChatTarget = target;
    }

    @Override
    @NotNull
    public List<String> getMatchingPartnerNames(String namePart) {
        namePart = namePart.toLowerCase();
        ArrayList<String> names = new ArrayList<String>(this.getPartners().size());
        for (MarriagePlayer partner : this.getPartners()) {
            if (!partner.getName().toLowerCase().startsWith(namePart)) continue;
            names.add(partner.getName());
        }
        return names;
    }

    @Override
    public boolean isPartner(@NotNull MARRIAGE_PLAYER player) {
        return this.getPartners().contains(player);
    }

    @Override
    @Nullable
    public MARRIAGE_PLAYER getPartner() {
        return (MARRIAGE_PLAYER)(this.isMarried() ? (MarriagePlayer)this.getPartners().iterator().next() : null);
    }

    @Override
    @Nullable
    public MARRIAGE getMarriageData() {
        return (MARRIAGE)(this.isMarried() ? (Marriage)this.getMultiMarriageData().iterator().next() : null);
    }

    @Override
    @Nullable
    public MARRIAGE_PLAYER getPartner(@NotNull String name) {
        for (MarriagePlayer partner : this.getPartners()) {
            if (!partner.getName().equalsIgnoreCase(name)) continue;
            return (MARRIAGE_PLAYER)partner;
        }
        return null;
    }

    @Override
    @Nullable
    public MARRIAGE_PLAYER getPartner(@NotNull UUID uuid) {
        for (MarriagePlayer partner : this.getPartners()) {
            if (!partner.getUUID().equals(uuid)) continue;
            return (MARRIAGE_PLAYER)partner;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<MARRIAGE_PLAYER> getPartners() {
        return this.partnersMarriages.keySet();
    }

    @Override
    @NotNull
    public Collection<MARRIAGE> getMultiMarriageData() {
        return this.partnersMarriages.values();
    }

    @Override
    public MARRIAGE getMarriageData(@NotNull MARRIAGE_PLAYER player) {
        return (MARRIAGE)((Marriage)this.partnersMarriages.get(player));
    }

    public boolean canBeUncached() {
        return !this.isMarried() && !this.isPriest();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getOfflineDisplayName() {
        return this.offlineDisplayName;
    }

    @Override
    public boolean isMarried() {
        return this.married;
    }

    @Override
    public Object getDatabaseKey() {
        return this.databaseKey;
    }

    public void setDatabaseKey(Object databaseKey) {
        this.databaseKey = databaseKey;
    }
}

