/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Database;

import at.pcgamingfreaks.MarriageMaster.API.Home;
import at.pcgamingfreaks.MarriageMaster.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Database.BaseDatabase;
import at.pcgamingfreaks.MarriageMaster.Database.DatabaseElement;
import at.pcgamingfreaks.MarriageMaster.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.Message.MessageColor;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarriageDataBase<MARRIAGE_PLAYER extends MarriagePlayer, COMMAND_SENDER, HOME extends Home>
implements Marriage<MARRIAGE_PLAYER, COMMAND_SENDER, HOME>,
DatabaseElement {
    private final MARRIAGE_PLAYER player1;
    private final MARRIAGE_PLAYER player2;
    private final MARRIAGE_PLAYER priest;
    private final int hash;
    private final Date weddingDate;
    protected String surname;
    @NotNull
    private String chatPrefix;
    private HOME home;
    private boolean pvpEnabled;
    @NotNull
    private MessageColor color;
    private Object databaseKey;

    protected MarriageDataBase(@NotNull MARRIAGE_PLAYER player1, @NotNull MARRIAGE_PLAYER player2, @Nullable MARRIAGE_PLAYER priest, @NotNull Date weddingDate, @Nullable String surname, boolean pvpEnabled, @Nullable MessageColor color, @Nullable HOME home, @Nullable Object databaseKey) {
        this.player1 = player1;
        this.player2 = player2;
        this.priest = priest;
        this.surname = surname;
        this.pvpEnabled = pvpEnabled;
        this.weddingDate = (Date)weddingDate.clone();
        this.databaseKey = databaseKey;
        this.home = home;
        this.chatPrefix = "";
        if (player1 instanceof MarriagePlayerDataBase && player2 instanceof MarriagePlayerDataBase) {
            ((MarriagePlayerDataBase)player1).addMarriage(this);
            ((MarriagePlayerDataBase)player2).addMarriage(this);
        }
        this.hash = player1.hashCode() * 53 + player2.hashCode();
        this.color = color == null ? MessageColor.values()[this.hash & 0xF] : color;
    }

    protected MarriageDataBase(@NotNull MARRIAGE_PLAYER player1, @NotNull MARRIAGE_PLAYER player2, @Nullable MARRIAGE_PLAYER priest, @NotNull Date weddingDate, @Nullable String surname) {
        this(player1, player2, priest, weddingDate, surname, false, null, null, null);
    }

    protected MarriageDataBase(@NotNull MARRIAGE_PLAYER player1, @NotNull MARRIAGE_PLAYER player2, @Nullable MARRIAGE_PLAYER priest, @Nullable String surname) {
        this(player1, player2, priest, new Date(), surname);
    }

    public boolean equals(Object otherMarriage) {
        return otherMarriage instanceof MarriageDataBase && this.player1.equals(((MarriageDataBase)otherMarriage).player1) && this.player2.equals(((MarriageDataBase)otherMarriage).player2);
    }

    public int hashCode() {
        return this.hash;
    }

    public void setHomeData(HOME home) {
        this.home = home;
    }

    public void updateSurname(String surname) {
        String oldSurname = this.getSurname();
        this.surname = surname;
        BaseDatabase.getInstance().cachedSurnameUpdate(this, oldSurname, false);
    }

    public void updatePvPState(boolean newState) {
        this.pvpEnabled = newState;
    }

    public void updateDivorce() {
        ((MarriagePlayerDataBase)this.getPartner1()).removeMarriage(this);
        ((MarriagePlayerDataBase)this.getPartner2()).removeMarriage(this);
    }

    @Override
    @NotNull
    public MARRIAGE_PLAYER getPartner1() {
        return this.player1;
    }

    @Override
    @NotNull
    public MARRIAGE_PLAYER getPartner2() {
        return this.player2;
    }

    @Override
    public boolean isBothOnline() {
        return this.player1.isOnline() && this.player2.isOnline();
    }

    @Override
    @Nullable
    public MARRIAGE_PLAYER getPartner(@NotNull MarriagePlayer player) {
        return (MARRIAGE_PLAYER)(this.player1.equals(player) ? this.player2 : (this.player2.equals(player) ? this.player1 : null));
    }

    @Override
    public boolean isHomeSet() {
        return this.getHome() != null;
    }

    @Override
    public void setHome(HOME home) {
        this.home = home;
        BaseDatabase.getInstance().updateHome(this);
    }

    @Override
    @NotNull
    public Date getWeddingDate() {
        return (Date)this.weddingDate.clone();
    }

    @Override
    public boolean isPVPEnabled() {
        return this.pvpEnabled;
    }

    @Override
    public void setPVPEnabled(boolean pvpEnabled) {
        this.pvpEnabled = pvpEnabled;
        BaseDatabase.getInstance().updatePvPState(this);
    }

    @Override
    public void setColor(@Nullable MessageColor color) {
        this.updateColor(color);
        BaseDatabase.getInstance().updateMarriageColor(this);
    }

    @Override
    @NotNull
    public String getMagicHeart() {
        return this.getColor() + "\u2764\u00a7f";
    }

    public void updateColor(@Nullable MessageColor color) {
        if (color == null || MessageColor.RESET.equals((Object)color)) {
            color = MessageColor.values()[this.hash & 0xF];
        } else if (color.isRGB()) {
            color = color.getFallbackColor();
        }
        this.color = color;
    }

    @Override
    public boolean hasPlayer(@NotNull MARRIAGE_PLAYER player) {
        return this.getPartner1().equals(player) || this.getPartner2().equals(player);
    }

    @Override
    @NotNull
    public String getMarriageChatMessagePrefix() {
        return this.chatPrefix;
    }

    @Override
    public void setMarriageChatMessagePrefix(@NotNull String chatPrefix) {
        this.chatPrefix = chatPrefix.substring(0, Math.min(20, chatPrefix.length()));
    }

    @Override
    public void divorce() {
        this.updateDivorce();
        BaseDatabase.getInstance().cachedDivorce(this);
    }

    @Override
    public MARRIAGE_PLAYER getPriest() {
        return this.priest;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @NotNull
    public String getChatPrefix() {
        return this.chatPrefix;
    }

    @Override
    public HOME getHome() {
        return this.home;
    }

    @Override
    @NotNull
    public MessageColor getColor() {
        return this.color;
    }

    @Override
    public Object getDatabaseKey() {
        return this.databaseKey;
    }

    public void setDatabaseKey(Object databaseKey) {
        this.databaseKey = databaseKey;
    }
}

