/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Database.FilesMigrator;

import at.pcgamingfreaks.MarriageMaster.Database.FilesMigrator.Home;
import at.pcgamingfreaks.MarriageMaster.Database.FilesMigrator.MigrationMarriage;
import at.pcgamingfreaks.MarriageMaster.Database.FilesMigrator.MigrationPlayer;
import at.pcgamingfreaks.yaml.YAML;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Files {
    private final Set<String> priests = new HashSet<String>();
    private final Set<MigrationMarriage> marriages = new HashSet<MigrationMarriage>();
    private final Map<String, YAML> marryMap = new TreeMap<String, YAML>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, MigrationPlayer> player = new TreeMap<String, MigrationPlayer>(String.CASE_INSENSITIVE_ORDER);
    private final boolean useUUIDs;
    private final Logger logger;
    private final File pluginDir;

    public Files(boolean useUUIDs, Logger logger, File pluginDir) {
        this.useUUIDs = useUUIDs;
        this.logger = logger;
        this.pluginDir = pluginDir;
        this.player.put(useUUIDs ? "00000000000000000000000000000000" : "none", new MigrationPlayer("none", "00000000000000000000000000000000", false, false));
        this.player.put(useUUIDs ? "00000000000000000000000000000001" : "Console", new MigrationPlayer("Console", "00000000000000000000000000000001", false, false));
        this.loadPriests();
        this.loadAllPlayers();
        this.prepareData();
    }

    public void close() {
        this.logger.info("Cleaning some memory ...");
        for (Map.Entry<String, YAML> stringYAMLEntry : this.marryMap.entrySet()) {
            stringYAMLEntry.getValue().dispose();
        }
        this.priests.clear();
        this.marryMap.clear();
        this.player.clear();
        this.logger.info("Finished cleaning memory.");
    }

    public Set<MigrationMarriage> getMarriages() {
        return this.marriages;
    }

    public Set<MigrationPlayer> getPlayers() {
        HashSet<MigrationPlayer> players = new HashSet<MigrationPlayer>();
        for (Map.Entry<String, MigrationPlayer> e : this.player.entrySet()) {
            players.add(e.getValue());
        }
        return players;
    }

    private void prepareData() {
        this.logger.info("Preparing data for database ...");
        for (Map.Entry<String, YAML> e : this.marryMap.entrySet()) {
            if (this.useUUIDs) {
                this.player.put(e.getKey(), new MigrationPlayer(e.getValue().getString("Name", ""), e.getKey(), e.getValue().getBoolean("isPriest", false), e.getValue().getBoolean("ShareBackpack", false)));
                continue;
            }
            this.player.put(e.getKey(), new MigrationPlayer(e.getKey(), null, e.getValue().getBoolean("isPriest", false), e.getValue().getBoolean("ShareBackpack", false)));
        }
        Iterator<Map.Entry<String, YAML>> iterator = this.marryMap.entrySet().iterator();
        HashSet<String> checked = new HashSet<String>();
        while (iterator.hasNext()) {
            Map.Entry<String, YAML> e;
            e = iterator.next();
            if (checked.contains(e.getKey())) continue;
            String s = this.useUUIDs ? e.getValue().getString("MarriedToUUID", "") : e.getValue().getString("MarriedTo", "");
            MigrationPlayer p1 = this.player.get(e.getKey());
            MigrationPlayer p = e.getValue().getString("MarriedBy", null) != null ? this.player.get(e.getValue().getString("MarriedBy", null)) : null;
            MigrationPlayer p2 = this.player.get(s);
            checked.add(s);
            this.marriages.add(new MigrationMarriage(p1, p2, p, e.getValue().getString("Surname", null), e.getValue().getBoolean("PvP", false), this.getHome(e.getValue())));
        }
        this.logger.info("Data prepared.");
    }

    private Home getHome(YAML yaml) {
        try {
            return new Home(yaml.getDouble("MarriedHome.location.X"), yaml.getDouble("MarriedHome.location.Y"), yaml.getDouble("MarriedHome.location.Z"), yaml.getString("MarriedHome.location.World"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void loadPriests() {
        this.logger.info("Loading priests ...");
        File file = new File(this.pluginDir, "priests.yml");
        this.priests.clear();
        if (file.exists()) {
            try (Scanner scanner = new Scanner(file, "UTF-8");){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.isEmpty()) continue;
                    this.priests.add(line.replace("\r", ""));
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed loading priests!", e);
            }
        }
        this.logger.info("Priests loaded.");
    }

    private void loadAllPlayers() {
        File[] allFiles;
        this.logger.info("Loading players ...");
        File file = new File(this.pluginDir, "players");
        if (file.exists() && (allFiles = file.listFiles()) != null && allFiles.length > 0) {
            for (File item : allFiles) {
                String temp = item.getName();
                if (!temp.endsWith(".yml")) continue;
                this.loadPlayer(temp.substring(0, temp.length() - 4));
            }
        }
        this.logger.info("Players loaded.");
    }

    private void loadPlayer(String player) {
        File file = new File(this.pluginDir, "players" + File.separator + player + ".yml");
        if (file.exists()) {
            try {
                this.marryMap.put(player, new YAML(file));
                if (this.marryMap.get(player).getString("MarriedTo", "").equalsIgnoreCase(player)) {
                    this.marryMap.get(player).dispose();
                    this.marryMap.remove(player);
                    if (!file.delete()) {
                        this.logger.warning("Failed to delete file (" + file.getAbsolutePath() + ").");
                    }
                } else {
                    this.marryMap.get(player).set("isPriest", (Object)this.priests.contains(player));
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load player data for " + player, e);
            }
        }
    }
}

