/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Database;

import at.pcgamingfreaks.Database.Cache.IUnCacheStrategyConfig;
import at.pcgamingfreaks.Database.DatabaseConnectionConfiguration;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseConfiguration
extends DatabaseConnectionConfiguration,
IUnCacheStrategyConfig {
    @NotNull
    default public String getDatabaseType() {
        return this.getConfigE().getString("Database.Type", "MySQL").toLowerCase(Locale.ENGLISH);
    }

    default public boolean useUUIDSeparators() {
        return this.getConfigE().getBoolean("Database.UseUUIDSeparators", false);
    }

    public boolean useOnlineUUIDs();

    @Contract(value="_, !null -> !null")
    @NotNull
    default public String getSQLTable(@NotNull String table, @Nullable String defaultValue) {
        return this.getConfigE().getString("Database.SQL.Tables." + table, defaultValue);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public String getSQLField(@NotNull String field, @Nullable String defaultValue) {
        return this.getConfigE().getString("Database.SQL.Tables.Fields." + field, defaultValue);
    }

    default public void setDatabaseType(@NotNull String type) {
    }
}

