/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Database.Backend;

import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.Database.ConnectionProvider.ConnectionProvider;
import at.pcgamingfreaks.Database.ConnectionProvider.SQLiteConnectionProvider;
import at.pcgamingfreaks.Database.DBTools;
import at.pcgamingfreaks.MarriageMaster.API.Home;
import at.pcgamingfreaks.MarriageMaster.Database.Backend.SQL;
import at.pcgamingfreaks.MarriageMaster.Database.Cache;
import at.pcgamingfreaks.MarriageMaster.Database.DatabaseConfiguration;
import at.pcgamingfreaks.MarriageMaster.Database.IPlatformSpecific;
import at.pcgamingfreaks.MarriageMaster.Database.MarriageDataBase;
import at.pcgamingfreaks.MarriageMaster.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.Version;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLite<MARRIAGE_PLAYER extends MarriagePlayerDataBase, MARRIAGE extends MarriageDataBase, HOME extends Home>
extends SQL<MARRIAGE_PLAYER, MARRIAGE, HOME> {
    public SQLite(@NotNull IPlatformSpecific<MARRIAGE_PLAYER, MARRIAGE, HOME> platform, @NotNull DatabaseConfiguration dbConfig, boolean bungee, boolean surname, @NotNull Cache<MARRIAGE_PLAYER, MARRIAGE> cache, @NotNull Logger logger, @Nullable ConnectionProvider connectionProvider, @NotNull String pluginName, @NotNull File dataFolder) {
        super(platform, dbConfig, bungee, surname, cache, logger, (ConnectionProvider)(connectionProvider == null ? new SQLiteConnectionProvider(logger, pluginName, dataFolder.getAbsolutePath() + File.separator + "database.db") : connectionProvider));
    }

    @Override
    @NotNull
    public Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        try (Statement statement = connection.createStatement();){
            statement.execute("PRAGMA foreign_keys = ON");
        }
        return connection;
    }

    private void doPHQuery(@NotNull Statement statement, @NotNull @Language(value="SQL") String query) throws SQLException {
        statement.execute(this.replacePlaceholders(query));
    }

    private void tryPHQuery(@NotNull Statement statement, @NotNull @Language(value="SQL") String query) throws SQLException {
        try {
            statement.execute(this.replacePlaceholders(query));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void checkDatabase() {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            Version dbVersion = this.getDatabaseVersion(statement);
            if (dbVersion.olderThan("2.3")) {
                this.tryPHQuery(statement, "ALTER TABLE {TMarriages} ADD COLUMN {FColor} VARCHAR(20) DEFAULT NULL;");
                this.tryPHQuery(statement, "ALTER TABLE {THomes} ADD COLUMN {FHomeYaw} FLOAT NOT NULL DEFAULT 0;");
                this.tryPHQuery(statement, "ALTER TABLE {THomes} ADD COLUMN {FHomePitch} FLOAT NOT NULL DEFAULT 0;");
            }
            this.doPHQuery(statement, "CREATE TABLE IF NOT EXISTS {TPlayers} ({FPlayerID} INTEGER PRIMARY KEY NOT NULL, {FName} VARCHAR(16) NOT NULL, {FUUID} CHAR(36) UNIQUE DEFAULT NULL, {FShareBackpack} TINYINT(1) NOT NULL DEFAULT 0);");
            this.doPHQuery(statement, "CREATE TABLE IF NOT EXISTS {TPriests} ({FPlayerID} INTEGER PRIMARY KEY NOT NULL,CONSTRAINT fk_{TPriests}_{TPlayers}_{FPlayerID} FOREIGN KEY ({FPlayerID}) REFERENCES {TPlayers} ({FPlayerID}) ON DELETE CASCADE ON UPDATE CASCADE);");
            this.doPHQuery(statement, "CREATE TABLE IF NOT EXISTS {TMarriages} ({FMarryID} INTEGER PRIMARY KEY NOT NULL,{FPlayer1} INT NOT NULL,{FPlayer2} INT NOT NULL,{FPriest} INT NULL,{FSurname} VARCHAR(45) NULL,{FPvPState} TINYINT(1) NOT NULL DEFAULT 0,{FDate} DATE NOT NULL, {FColor} VARCHAR(20) DEFAULT NULL,CONSTRAINT fk_{TMarriages}_{TPlayers}_{FPlayer1} FOREIGN KEY ({FPlayer1}) REFERENCES {TPlayers} ({FPlayerID}) ON DELETE CASCADE ON UPDATE CASCADE,CONSTRAINT fk_{TMarriages}_{TPlayers}_{FPlayer2} FOREIGN KEY ({FPlayer2}) REFERENCES {TPlayers} ({FPlayerID}) ON DELETE CASCADE ON UPDATE CASCADE,CONSTRAINT fk_{TMarriages}_{TPlayers}_{FPriest} FOREIGN KEY ({FPriest}) REFERENCES {TPlayers} ({FPlayerID}) ON DELETE SET NULL ON UPDATE CASCADE);");
            this.doPHQuery(statement, "CREATE TABLE IF NOT EXISTS {THomes} ({FMarryID} INTEGER PRIMARY KEY NOT NULL,{FHomeX} DOUBLE NOT NULL,{FHomeY} DOUBLE NOT NULL,{FHomeZ} DOUBLE NOT NULL, {FHomeYaw} FLOAT NOT NULL DEFAULT 0, {FHomePitch} FLOAT NOT NULL DEFAULT 0,{FHomeWorld} VARCHAR(45) NOT NULL DEFAULT 'world',CONSTRAINT fk_{THomes}_{TMarriages}_{FMarryID} FOREIGN KEY ({FMarryID}) REFERENCES {TMarriages} ({FMarryID}) ON DELETE CASCADE ON UPDATE CASCADE);");
            DBTools.runStatement((Connection)connection, (String)"INSERT OR REPLACE INTO `marriagemaster_metadata` (`key`, `value`) VALUES ('db_version',?);", (Object[])new Object[]{this.platform.getPluginVersion()});
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, ConsoleColor.RED + "Failed to create SQLite tables!" + ConsoleColor.RESET, e);
        }
    }

    @NotNull
    private Version getDatabaseVersion(@NotNull Statement stmt) throws SQLException {
        boolean tableWithTypoExists = false;
        try (ResultSet rs = stmt.executeQuery("SELECT `name` FROM sqlite_master WHERE type='table' AND name='mariagemaster_metadata';");){
            tableWithTypoExists = rs.next();
        }
        if (tableWithTypoExists) {
            try {
                stmt.execute("ALTER TABLE `mariagemaster_metadata` RENAME TO `marriagemaster_metadata`;");
            }
            catch (SQLException ignored) {
                stmt.execute("DROP TABLE IF EXISTS `mariagemaster_metadata`");
            }
        }
        stmt.execute("CREATE TABLE IF NOT EXISTS `marriagemaster_metadata` (`key` CHAR(32) PRIMARY KEY NOT NULL, `value` TEXT);");
        rs = stmt.executeQuery("SELECT `value` FROM `marriagemaster_metadata` WHERE `key`='db_version';");
        var4_5 = null;
        try {
            if (rs.next()) {
                Version version = new Version(rs.getString("value"));
                return version;
            }
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var4_5 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        return new Version("0");
    }

    @Override
    protected void buildQueries() {
        super.buildQueries();
        this.querySetPriest = this.querySetPriest.replace("REPLACE INTO", "INSERT OR REPLACE INTO").replace(" VALUE ", " VALUES ");
        this.queryUpdateHome = this.queryUpdateHome.replace("REPLACE INTO", "INSERT OR REPLACE INTO");
        this.queryAddPlayer = this.queryAddPlayer.replace("INSERT IGNORE INTO", "INSERT OR IGNORE INTO");
    }

    @Override
    protected void loadTableAndFieldNames() {
    }

    @Override
    @NotNull
    public String getDatabaseTypeName() {
        return "SQLite";
    }

    @Override
    public boolean supportsBungeeCord() {
        return false;
    }
}

