/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Database.Backend;

import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.DataHandler.HasPlaceholders;
import at.pcgamingfreaks.DataHandler.ILoadableStringFieldsHolder;
import at.pcgamingfreaks.DataHandler.IStringFieldsWithPlaceholdersHolder;
import at.pcgamingfreaks.DataHandler.Loadable;
import at.pcgamingfreaks.Database.ConnectionProvider.ConnectionProvider;
import at.pcgamingfreaks.Database.DBTools;
import at.pcgamingfreaks.MarriageMaster.API.Home;
import at.pcgamingfreaks.MarriageMaster.Database.Backend.DatabaseBackend;
import at.pcgamingfreaks.MarriageMaster.Database.Backend.SQLBasedDatabase;
import at.pcgamingfreaks.MarriageMaster.Database.Cache;
import at.pcgamingfreaks.MarriageMaster.Database.DatabaseConfiguration;
import at.pcgamingfreaks.MarriageMaster.Database.DatabaseElement;
import at.pcgamingfreaks.MarriageMaster.Database.FilesMigrator.MigrationMarriage;
import at.pcgamingfreaks.MarriageMaster.Database.FilesMigrator.MigrationPlayer;
import at.pcgamingfreaks.MarriageMaster.Database.FilteredHashSet;
import at.pcgamingfreaks.MarriageMaster.Database.Helper.DbElementStatementWithKeyFirstRunnable;
import at.pcgamingfreaks.MarriageMaster.Database.Helper.DbElementStatementWithKeyRunnable;
import at.pcgamingfreaks.MarriageMaster.Database.Helper.StructMarriageSQL;
import at.pcgamingfreaks.MarriageMaster.Database.IPlatformSpecific;
import at.pcgamingfreaks.MarriageMaster.Database.MarriageDataBase;
import at.pcgamingfreaks.MarriageMaster.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.Message.MessageColor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SQL<MARRIAGE_PLAYER extends MarriagePlayerDataBase, MARRIAGE extends MarriageDataBase, HOME extends Home>
extends DatabaseBackend<MARRIAGE_PLAYER, MARRIAGE, HOME>
implements SQLBasedDatabase,
IStringFieldsWithPlaceholdersHolder,
ILoadableStringFieldsHolder {
    protected static final long RETRY_DELAY = 5L;
    private static final Random RANDOM = new Random();
    @NotNull
    protected final DatabaseConfiguration dbConfig;
    protected final ConnectionProvider connectionProvider;
    @Loadable
    protected String tableUser = "marry_players";
    @Loadable
    protected String tablePartner = "marry_partners";
    @Loadable
    protected String tablePriests = "marry_priests";
    @Loadable
    protected String tableHome = "marry_home";
    @Loadable
    protected String fieldPlayerID = "player_id";
    @Loadable
    protected String fieldPriestID = "player_id";
    @Loadable
    protected String fieldMarryID = "marry_id";
    @Loadable(metadata="Player")
    protected String fieldName = "name";
    @Loadable(metadata="Player")
    protected String fieldUUID = "uuid";
    @Loadable(metadata="Player")
    protected String fieldShareBackpack = "sharebackpack";
    @Loadable(metadata="Marry")
    protected String fieldPlayer1 = "player1";
    @Loadable(metadata="Marry")
    protected String fieldPlayer2 = "player2";
    @Loadable(metadata="Marry")
    protected String fieldPriest = "priest";
    @Loadable(metadata="Marry")
    protected String fieldSurname = "surname";
    @Loadable(metadata="Marry")
    protected String fieldPVPState = "pvp_state";
    @Loadable(metadata="Marry")
    protected String fieldDate = "date";
    @Loadable(metadata="Marry")
    protected String fieldColor = "color";
    @Loadable
    protected String fieldHomeX = "home_x";
    @Loadable
    protected String fieldHomeY = "home_y";
    @Loadable
    protected String fieldHomeZ = "home_z";
    @Loadable
    protected String fieldHomeWorld = "home_world";
    @Loadable
    protected String fieldHomeServer = "home_server";
    @Loadable
    protected String fieldHomeYaw = "home_yaw";
    @Loadable
    protected String fieldHomePitch = "home_pitch";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryDelHome = "DELETE FROM {THomes} WHERE {FMarryID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryUpdateHome = "REPLACE INTO {THomes} ({FMarryID},{FHomeX},{FHomeY},{FHomeZ},{FHomeYaw},{FHomePitch},{FHomeWorld},{FHomeServer}) VALUES (?,?,?,?,?,?,?,?);";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryPvPState = "UPDATE {TMarriages} SET {FPvPState}=? WHERE {FMarryID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String querySetSurname = "UPDATE {TMarriages} SET {FSurname}=? WHERE {FMarryID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryDelMarriage = "DELETE FROM {TMarriages} WHERE {FMarryID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String querySetBackpackShareState = "UPDATE {TPlayers} SET {FShareBackpack}=? WHERE {FPlayerID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryMarry = "INSERT INTO {TMarriages} ({FPlayer1},{FPlayer2},{FPriest},{FPvPState},{FDate}) VALUES (?,?,?,?,?);";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryLoadHome = "SELECT * FROM {THomes} WHERE {FMarryID}=?";
    @HasPlaceholders
    @Language(value="SQL")
    protected String querySetPriest = "REPLACE INTO {TPriests} ({FPriestID}) VALUE (?);";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryRemovePriest = "DELETE FROM {TPriests} WHERE {FPriestID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryLoadPlayer = "SELECT * FROM {TPlayers} WHERE {FUUID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryAddPlayer = "INSERT IGNORE INTO {TPlayers} ({FName},{FUUID},{FShareBackpack}) VALUES (?,?,?);";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryLoadHomes = "SELECT * FROM {THomes};";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryIsPriest = "SELECT * FROM {TPriests} WHERE {FPriestID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryLoadPlayerFromId = "SELECT * FROM {TPlayers} WHERE {FPlayerID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryLoadPlayersFromID = "SELECT * FROM {TPlayers} WHERE {FPlayerID} IN ({IDs});";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryLoadPriests = "SELECT {FPriestID} FROM {TPriests};";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryLoadMarriages = "SELECT * FROM {TMarriages};";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryLoadMarriage = "SELECT * FROM {TMarriages} WHERE {FMarryID}=?";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryUpdatePlayer = "UPDATE {TPlayers} SET {FName}=? WHERE {FPlayerID}=?;";
    @HasPlaceholders
    @Language(value="SQL")
    protected String queryUpdateMarriageColor = "UPDATE {TMarriages} SET {FColor}=? WHERE {FMarryID}=?;";

    protected SQL(@NotNull IPlatformSpecific<MARRIAGE_PLAYER, MARRIAGE, HOME> platform, @NotNull DatabaseConfiguration dbConfig, boolean bungee, boolean surname, @NotNull Cache<MARRIAGE_PLAYER, MARRIAGE> cache, @NotNull Logger logger, @NotNull ConnectionProvider connectionProvider) {
        super(platform, dbConfig, bungee, surname, cache, logger);
        this.dbConfig = dbConfig;
        this.connectionProvider = connectionProvider;
        this.loadTableAndFieldNames();
        this.buildQueries();
    }

    @Override
    public void startup() throws Exception {
        this.getConnection().close();
        this.checkDatabase();
        super.startup();
    }

    @Override
    public void close() {
        try {
            this.connectionProvider.close();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to close sql connection provider!", e);
        }
        super.close();
    }

    @Override
    @NotNull
    public Connection getConnection() throws SQLException {
        return this.connectionProvider.getConnection();
    }

    @NotNull
    protected String getEngine() {
        return "";
    }

    protected void loadTableAndFieldNames() {
        this.loadFields();
    }

    protected void buildQueries() {
        if (!this.useBungee) {
            this.queryUpdateHome = this.queryUpdateHome.replace(",{FHomeServer}", "").replace("(?,?,?,?,?,?,?,?)", "(?,?,?,?,?,?,?)");
        }
        if (this.surnameEnabled) {
            this.queryMarry = "INSERT INTO {TMarriages} ({FPlayer1},{FPlayer2},{FPriest},{FPvPState},{FDate},{FSurname}) VALUES (?,?,?,?,?,?);";
        }
        this.replacePlaceholders();
    }

    @Language(value="SQL")
    @NotNull
    public String replacePlaceholders(@Language(value="SQL") @NotNull String query) {
        return query.replaceAll("(\\{\\w+})", "`$1`").replaceAll("`(\\{\\w+})`_(\\w+)", "`$1_$2`").replaceAll("fk_`(\\{\\w+})`_`(\\{\\w+})`_`(\\{\\w+})`", "`fk_$1_$2_$3`").replace("{TPlayers}", this.tableUser).replace("{TMarriages}", this.tablePartner).replace("{TPriests}", this.tablePriests).replace("{THomes}", this.tableHome).replace("{FPlayerID}", this.fieldPlayerID).replace("{FName}", this.fieldName).replace("{FUUID}", this.fieldUUID).replace("{FShareBackpack}", this.fieldShareBackpack).replace("{FMarryID}", this.fieldMarryID).replace("{FSurname}", this.fieldSurname).replace("{FPlayer1}", this.fieldPlayer1).replace("{FPlayer2}", this.fieldPlayer2).replace("{FPriest}", this.fieldPriest).replace("{FPvPState}", this.fieldPVPState).replace("{FDate}", this.fieldDate).replace("{FColor}", this.fieldColor).replace("{FHomeServer}", this.fieldHomeServer).replace("{FHomeX}", this.fieldHomeX).replace("{FHomeY}", this.fieldHomeY).replace("{FHomeZ}", this.fieldHomeZ).replace("{FHomeYaw}", this.fieldHomeYaw).replace("{FHomePitch}", this.fieldHomePitch).replace("{FHomeWorld}", this.fieldHomeWorld).replace("{FPriestID}", this.fieldPriestID);
    }

    public String loadField(@NotNull String fieldName, @NotNull String metadata, @Nullable String currentValue) {
        if (fieldName.startsWith("field")) {
            return this.dbConfig.getSQLField(metadata + fieldName.substring(5), currentValue);
        }
        return this.dbConfig.getSQLTable(metadata + fieldName.substring(5), currentValue);
    }

    protected abstract void checkDatabase();

    protected void runAsync(@NotNull Runnable runnable, @NotNull DatabaseElement databaseElement) {
        this.runAsync(runnable, databaseElement.getDatabaseKey() == null ? 5L : 0L);
    }

    protected void runStatementAsyncIncludeKey(@Language(value="SQL") @NotNull String query, @NotNull DatabaseElement databaseElement, Object ... args) {
        this.runAsync((Runnable)new DbElementStatementWithKeyRunnable(this, databaseElement, query, args), databaseElement);
    }

    protected void runStatementAsyncIncludeKeyFirst(@Language(value="SQL") @NotNull String query, @NotNull DatabaseElement databaseElement, Object ... args) {
        this.runAsync((Runnable)new DbElementStatementWithKeyFirstRunnable(this, databaseElement, query, args), databaseElement);
    }

    @Override
    public void checkUUIDs() {
        try (Connection connection = this.getConnection();){
            DBTools.validateUUIDs((Logger)this.logger, (Connection)connection, (String)this.tableUser, (String)this.fieldName, (String)this.fieldUUID, (String)this.fieldPlayerID, (boolean)this.useUUIDSeparators, (boolean)this.useOnlineUUIDs);
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Failed to update player UUIDs in database!", e);
        }
    }

    @Override
    public void loadAll() {
        HashSet<StructMarriageSQL> marriagesSet = new HashSet<StructMarriageSQL>();
        FilteredHashSet<Integer> playerToLoad = new FilteredHashSet<Integer>(element -> element >= 0);
        try (Connection connection = this.getConnection();){
            Iterator rs2;
            this.logger.info("Loading marriages ...");
            try {
                PreparedStatement ps = connection.prepareStatement(this.queryLoadMarriages);
                Object object = null;
                try {
                    rs2 = ps.executeQuery();
                    Throwable throwable = null;
                    try {
                        while (rs2.next()) {
                            marriagesSet.add(new StructMarriageSQL(rs2.getInt(this.fieldMarryID), rs2.getInt(this.fieldPlayer1), rs2.getInt(this.fieldPlayer2), rs2.getInt(this.fieldPriest), rs2.getBoolean(this.fieldPVPState), rs2.getString(this.fieldColor), this.surnameEnabled ? rs2.getString(this.fieldSurname) : null, rs2.getTimestamp(this.fieldDate)));
                            playerToLoad.add(rs2.getInt(this.fieldPlayer1));
                            playerToLoad.add(rs2.getInt(this.fieldPlayer2));
                            if (rs2.getObject(this.fieldPriest) == null) continue;
                            playerToLoad.add(rs2.getInt(this.fieldPriest));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable rs2) {
                    object = rs2;
                    throw rs2;
                }
                finally {
                    if (ps != null) {
                        if (object != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable rs2) {
                                ((Throwable)object).addSuppressed(rs2);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load marriages!", e);
                this.platform.spawnDatabaseLoadingErrorMessage("Failed to load marriages - " + e.getMessage());
            }
            this.logger.info("Marriages loaded");
            this.logger.info("Loading priests ...");
            HashSet<Integer> priests = new HashSet<Integer>();
            try {
                PreparedStatement ps = connection.prepareStatement(this.queryLoadPriests);
                rs2 = null;
                try (ResultSet rs32 = ps.executeQuery();){
                    while (rs32.next()) {
                        priests.add(rs32.getInt(this.fieldPriestID));
                    }
                }
                catch (Throwable rs32) {
                    rs2 = rs32;
                    throw rs32;
                }
                finally {
                    if (ps != null) {
                        if (rs2 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable rs32) {
                                ((Throwable)((Object)rs2)).addSuppressed(rs32);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load priests!", e);
                this.platform.spawnDatabaseLoadingErrorMessage("Failed to load priests - " + e.getMessage());
            }
            this.logger.info("Priests loaded");
            this.logger.info("Loading players ...");
            if (!playerToLoad.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                rs2 = playerToLoad.iterator();
                while (rs2.hasNext()) {
                    int pid = (Integer)rs2.next();
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(pid);
                }
                try (Statement stmt = connection.createStatement();
                     ResultSet rs4 = stmt.executeQuery(this.queryLoadPlayersFromID.replace("`{IDs}`", stringBuilder.toString()));){
                    while (rs4.next()) {
                        Object player = this.platform.producePlayer(this.getUUIDFromIdentifier(rs4.getString(this.fieldUUID)), rs4.getString(this.fieldName), rs4.getBoolean(this.fieldShareBackpack), priests.contains(rs4.getInt(this.fieldPlayerID)), rs4.getInt(this.fieldPlayerID));
                        this.cache.cache(player);
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Failed to load players!", e);
                    this.platform.spawnDatabaseLoadingErrorMessage("Failed to load players - " + e.getMessage());
                }
            }
            this.logger.info("Players loaded");
            this.logger.info("Writing marriages into cache ...");
            for (StructMarriageSQL sm : marriagesSet) {
                Object player1 = this.cache.getPlayerFromDbKey(sm.p1ID);
                Object player2 = this.cache.getPlayerFromDbKey(sm.p2ID);
                if (player1 != null && player2 != null) {
                    this.cache.cache(this.platform.produceMarriage(this.cache.getPlayerFromDbKey(sm.p1ID), this.cache.getPlayerFromDbKey(sm.p2ID), this.cache.getPlayerFromDbKey(sm.priest), sm.date, sm.surname, sm.pvp, sm.color, null, sm.marryID));
                    continue;
                }
                this.logger.warning("Player " + (player1 == null ? "1" : "2") + " for marriage " + sm.marryID + " has not been loaded. Skipping");
            }
            this.logger.info("Marriages loaded into cache");
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Failed loading plugin data from database with unknown error!", e);
            this.platform.spawnDatabaseLoadingErrorMessage(e.getMessage());
        }
        this.loadHomes();
    }

    public void loadMarriage(int marriageId) {
        this.runAsync(() -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement ps = connection.prepareStatement(this.queryLoadMarriage);){
                ps.setInt(1, marriageId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        Object priest;
                        MARRIAGE_PLAYER player1 = this.playerFromId(connection, rs.getInt(this.fieldPlayer1));
                        MARRIAGE_PLAYER player2 = this.playerFromId(connection, rs.getInt(this.fieldPlayer2));
                        Object MARRIAGE_PLAYER = priest = rs.getObject(this.fieldPriest) == null ? null : (Object)this.playerFromId(connection, rs.getInt(this.fieldPriest));
                        if (player1 == null || player2 == null) {
                            this.logger.log(Level.WARNING, "Failed to load marriage (id: {}) because one of its players could not be loaded successful!", marriageId);
                            return;
                        }
                        String surname = this.surnameEnabled ? rs.getString(this.fieldSurname) : null;
                        String color = rs.getString(this.fieldColor);
                        Object marriage = this.platform.produceMarriage(player1, player2, priest, rs.getTimestamp(this.fieldDate), surname, rs.getBoolean(this.fieldPVPState), color == null ? null : MessageColor.valueOf((String)color), null, marriageId);
                        this.cache.cache(marriage);
                        this.loadHome(marriage);
                    }
                }
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Failed to load marriage!", e);
            }
        });
    }

    @Nullable
    protected MARRIAGE_PLAYER playerFromId(@NotNull Connection connection, int id) throws SQLException {
        block30: {
            if (this.cache.isPlayerFromDbKeyLoaded(id)) {
                return (MARRIAGE_PLAYER)this.cache.getPlayerFromDbKey(id);
            }
            try (PreparedStatement ps = connection.prepareStatement(this.queryLoadPlayerFromId);){
                Object MARRIAGE_PLAYER;
                ps.setInt(1, id);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) break block30;
                    Object player = this.platform.producePlayer(this.getUUIDFromIdentifier(rs.getString(this.fieldUUID)), rs.getString(this.fieldName), false, rs.getBoolean(this.fieldShareBackpack), rs.getInt(this.fieldPlayerID));
                    this.cache.cache(player);
                    MARRIAGE_PLAYER = player;
                }
                return MARRIAGE_PLAYER;
            }
        }
        return null;
    }

    protected void loadHomes() {
        this.logger.info("Loading homes ...");
        HashMap homes = new HashMap();
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(this.queryLoadHomes);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String homeServer = this.useBungee ? rs.getString(this.fieldHomeServer) : null;
                homes.put(rs.getInt(this.fieldMarryID), this.platform.produceHome("", rs.getString(this.fieldHomeWorld), homeServer, rs.getDouble(this.fieldHomeX), rs.getDouble(this.fieldHomeY), rs.getDouble(this.fieldHomeZ), rs.getFloat(this.fieldHomeYaw), rs.getFloat(this.fieldHomePitch)));
            }
            for (MarriageDataBase marriage : this.cache.getLoadedMarriages()) {
                if (!(marriage.getDatabaseKey() instanceof Integer)) continue;
                marriage.setHomeData((Home)homes.get((Integer)marriage.getDatabaseKey()));
            }
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Failed to load homes!", e);
            this.platform.spawnDatabaseLoadingErrorMessage("Failed to load homes - " + e.getMessage());
        }
        homes.clear();
        this.logger.info("Homes loaded");
    }

    public void loadHome(MARRIAGE marriage) {
        this.runAsync(() -> {
            if (marriage.getDatabaseKey() instanceof Integer) {
                try (Connection connection = this.getConnection();
                     PreparedStatement ps = connection.prepareStatement(this.queryLoadHome);){
                    ps.setInt(1, (Integer)marriage.getDatabaseKey());
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            String homeServer = this.useBungee ? rs.getString(this.fieldHomeServer) : null;
                            marriage.setHomeData(this.platform.produceHome("", rs.getString(this.fieldHomeWorld), homeServer, rs.getDouble(this.fieldHomeX), rs.getDouble(this.fieldHomeY), rs.getDouble(this.fieldHomeZ), rs.getFloat(this.fieldHomeYaw), rs.getFloat(this.fieldHomePitch)));
                        } else {
                            marriage.setHomeData(null);
                        }
                    }
                }
                catch (SQLException e) {
                    this.logger.log(Level.SEVERE, "Failed to load home for marriage " + marriage.getPartner1().getName() + " - " + marriage.getPartner2().getName(), e);
                }
            }
        }, (DatabaseElement)marriage);
    }

    @Override
    public void load(@NotNull MARRIAGE_PLAYER player) {
        this.runAsync(() -> this.doLoad(player));
    }

    protected void doLoad(@NotNull MARRIAGE_PLAYER player) {
        try (Connection connection = this.getConnection();){
            if (((MarriagePlayerDataBase)player).getDatabaseKey() == null) {
                if (!this.queryPlayer(player, connection)) {
                    this.add(player, connection);
                }
            } else if (player.isOnline()) {
                this.update(player, connection);
            }
        }
        catch (SQLTransactionRollbackException e) {
            this.runAsync(() -> this.doLoad(player), RANDOM.nextInt(4));
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Failed to load player data for " + ((MarriagePlayerDataBase)player).getName() + " (" + ((MarriagePlayerDataBase)player).getUUID() + ")!", e);
        }
    }

    protected void add(@NotNull MARRIAGE_PLAYER player, @NotNull Connection connection) throws SQLException {
        try (PreparedStatement psAdd = connection.prepareStatement(this.queryAddPlayer, 1);){
            int i = 1;
            psAdd.setString(i++, ((MarriagePlayerDataBase)player).getName());
            psAdd.setString(i++, this.getUsedPlayerIdentifier(player));
            psAdd.setBoolean(i++, ((MarriagePlayerDataBase)player).isSharingBackpack());
            if (psAdd.getParameterMetaData().getParameterCount() == i) {
                psAdd.setString(i, this.getUsedPlayerIdentifier(player));
            }
            psAdd.executeUpdate();
            try (ResultSet rs = psAdd.getGeneratedKeys();){
                if (rs.next()) {
                    ((MarriagePlayerDataBase)player).setDatabaseKey(rs.getInt(1));
                    this.cache.addDbKey(player);
                } else {
                    this.queryPlayer(player, connection);
                }
            }
        }
    }

    protected void update(MARRIAGE_PLAYER player, Connection connection) throws SQLException {
        String onlineName = ((MarriagePlayerDataBase)player).getOnlineName();
        if (onlineName == null || onlineName.equals(((MarriagePlayerDataBase)player).getName())) {
            return;
        }
        ((MarriagePlayerDataBase)player).setName(onlineName);
        DBTools.runStatement((Connection)connection, (String)this.queryUpdatePlayer, (Object[])new Object[]{onlineName, ((MarriagePlayerDataBase)player).getDatabaseKey()});
    }

    protected boolean queryPlayer(MARRIAGE_PLAYER player, Connection connection) throws SQLException {
        int dbId;
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        PreparedStatement ps;
        block54: {
            ps = connection.prepareStatement(this.queryLoadPlayer);
            throwable2 = null;
            try {
                ps.setString(1, this.getUsedPlayerIdentifier(player));
                rs2 = ps.executeQuery();
                throwable = null;
                try {
                    if (rs2.next()) {
                        dbId = rs2.getInt(this.fieldPlayerID);
                        ((MarriagePlayerDataBase)player).setDatabaseKey(dbId);
                        this.cache.addDbKey(player);
                        ((MarriagePlayerDataBase)player).setSharesBackpack(rs2.getBoolean(this.fieldShareBackpack));
                        this.update(player, connection);
                        break block54;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
            finally {
                if (ps != null) {
                    if (throwable2 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        ps = connection.prepareStatement(this.queryIsPriest);
        throwable2 = null;
        try {
            ps.setInt(1, dbId);
            rs2 = ps.executeQuery();
            throwable = null;
            try {
                ((MarriagePlayerDataBase)player).setPriestData(rs2.next());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (rs2 != null) {
                    if (throwable != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        rs2.close();
                    }
                }
            }
        }
        catch (Throwable throwable8) {
            throwable2 = throwable8;
            throw throwable8;
        }
        finally {
            if (ps != null) {
                if (throwable2 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable9) {
                        throwable2.addSuppressed(throwable9);
                    }
                } else {
                    ps.close();
                }
            }
        }
        return true;
    }

    @Override
    public void updateBackpackShareState(@NotNull MARRIAGE_PLAYER player) {
        this.runStatementAsyncIncludeKey(this.querySetBackpackShareState, (DatabaseElement)player, ((MarriagePlayerDataBase)player).isSharingBackpack());
    }

    @Override
    public void updatePriestStatus(@NotNull MARRIAGE_PLAYER player) {
        this.runStatementAsyncIncludeKey(((MarriagePlayerDataBase)player).isPriest() ? this.querySetPriest : this.queryRemovePriest, (DatabaseElement)player, new Object[0]);
    }

    @Override
    public void updateHome(@NotNull MARRIAGE marriage) {
        Object home = ((MarriageDataBase)marriage).getHome();
        if (home == null) {
            this.runStatementAsyncIncludeKey(this.queryDelHome, (DatabaseElement)marriage, new Object[0]);
        } else if (this.useBungee) {
            this.runStatementAsyncIncludeKeyFirst(this.queryUpdateHome, (DatabaseElement)marriage, ((Home)home).getX(), ((Home)home).getY(), ((Home)home).getZ(), Float.valueOf(((Home)home).getYaw()), Float.valueOf(((Home)home).getPitch()), ((Home)home).getWorldName(), ((Home)home).getHomeServer());
        } else {
            this.runStatementAsyncIncludeKeyFirst(this.queryUpdateHome, (DatabaseElement)marriage, ((Home)home).getX(), ((Home)home).getY(), ((Home)home).getZ(), Float.valueOf(((Home)home).getYaw()), Float.valueOf(((Home)home).getPitch()), ((Home)home).getWorldName());
        }
    }

    @Override
    public void updatePvPState(@NotNull MARRIAGE marriage) {
        this.runStatementAsyncIncludeKey(this.queryPvPState, (DatabaseElement)marriage, ((MarriageDataBase)marriage).isPVPEnabled());
    }

    @Override
    public void updateMarriageColor(@NotNull MARRIAGE marriage) {
        this.runStatementAsyncIncludeKey(this.queryUpdateMarriageColor, (DatabaseElement)marriage, ((MarriageDataBase)marriage).getColor().name());
    }

    @Override
    public void divorce(@NotNull MARRIAGE marriage) {
        this.runStatementAsyncIncludeKey(this.queryDelMarriage, (DatabaseElement)marriage, new Object[0]);
    }

    @Override
    public void marry(@NotNull MARRIAGE marriage) {
        this.runAsync(() -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement ps = connection.prepareStatement(this.queryMarry, 1);){
                DBTools.setParameters((PreparedStatement)ps, (Object[])new Object[]{((MarriagePlayerDataBase)marriage.getPartner1()).getDatabaseKey(), ((MarriagePlayerDataBase)marriage.getPartner2()).getDatabaseKey(), marriage.getPriest() != null ? ((MarriagePlayerDataBase)marriage.getPriest()).getDatabaseKey() : null, marriage.isPVPEnabled(), new Timestamp(marriage.getWeddingDate().getTime())});
                if (this.surnameEnabled) {
                    ps.setString(6, marriage.getSurname());
                }
                ps.executeUpdate();
                try (ResultSet rs = ps.getGeneratedKeys();){
                    if (rs.next()) {
                        marriage.setDatabaseKey(rs.getInt(1));
                        this.cache.addDbKey(marriage);
                        if (this.marriageSavedCallback != null) {
                            this.marriageSavedCallback.run((MarriageDataBase)marriage);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Failed to save marriage " + marriage.getPartner1().getName() + " - " + marriage.getPartner2().getName(), e);
            }
        });
    }

    @Override
    public void updateSurname(@NotNull MARRIAGE marriage) {
        this.runStatementAsyncIncludeKey(this.querySetSurname, (DatabaseElement)marriage, ((MarriageDataBase)marriage).getSurname());
    }

    @Override
    public void migratePlayer(@NotNull MigrationPlayer player) {
        block91: {
            try (Connection connection = this.getConnection();
                 PreparedStatement ps = connection.prepareStatement(this.queryAddPlayer, 1);){
                Throwable throwable;
                block90: {
                    int i = 1;
                    ps.setString(i++, player.name);
                    ps.setString(i++, this.useUUIDSeparators ? player.uuid.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5") : player.uuid);
                    ps.setBoolean(i, player.shareBackpack);
                    ps.executeUpdate();
                    throwable = null;
                    try (ResultSet rs = ps.getGeneratedKeys();){
                        if (rs.next()) {
                            player.id = rs.getInt(1);
                            break block90;
                        }
                        this.logger.info("No auto ID for player \"" + player.name + "\", try to load id from database ...");
                        try (PreparedStatement ps2 = connection.prepareStatement(this.queryLoadPlayer);){
                            ps2.setString(1, player.uuid);
                            try (ResultSet rs2 = ps2.executeQuery();){
                                if (rs2.next()) {
                                    player.id = rs.getInt(this.fieldPlayerID);
                                    break block90;
                                }
                                this.logger.warning(ConsoleColor.RED + "No ID for player \"" + player.name + "\", there is something wrong with this player! You should check that!" + ConsoleColor.RESET);
                                return;
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                if (!player.priest || player.id < 0) break block91;
                throwable = null;
                try (PreparedStatement addPriest = connection.prepareStatement(this.querySetPriest);){
                    addPriest.setInt(1, player.id);
                    addPriest.execute();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, ConsoleColor.RED + "Failed migrating player \"" + player.name + "\"!" + ConsoleColor.RESET, e);
            }
        }
    }

    @Override
    public void migrateMarriage(@NotNull MigrationMarriage marriage) {
        if (marriage.player1 == null || marriage.player2 == null || marriage.player1.id < 0 || marriage.player2.id < 0) {
            return;
        }
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(this.queryMarry, 1);){
            DBTools.setParameters((PreparedStatement)ps, (Object[])new Object[]{marriage.player1.id, marriage.player2.id, marriage.priest == null ? null : Integer.valueOf(marriage.priest.id), marriage.pvpState, new Timestamp(System.currentTimeMillis())});
            if (this.surnameEnabled) {
                ps.setString(6, marriage.surname);
            }
            ps.executeUpdate();
            try (ResultSet rs = ps.getGeneratedKeys();){
                if (rs.next()) {
                    marriage.id = rs.getInt(1);
                    if (marriage.home != null && marriage.id >= 0) {
                        try {
                            DBTools.runStatement((Connection)connection, (String)this.queryUpdateHome, (Object[])new Object[]{marriage.id, marriage.home.x, marriage.home.y, marriage.home.z, marriage.home.world});
                        }
                        catch (SQLException e) {
                            this.logger.log(Level.WARNING, ConsoleColor.RED + "Failed adding home for marriage \"" + marriage.player1.name + " <-> " + marriage.player2.name + "\"!" + ConsoleColor.RESET, e);
                        }
                    }
                } else {
                    this.logger.warning("No ID for marriage \"" + marriage.player1.name + "<->" + marriage.player2.name + "\"!");
                }
            }
        }
        catch (SQLException e) {
            this.logger.log(Level.WARNING, ConsoleColor.RED + "Failed adding marriage \"" + marriage.player1.name + " <-> " + marriage.player2.name + "\"!" + ConsoleColor.RESET, e);
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

