/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Database.Backend;

import at.pcgamingfreaks.Configuration;
import at.pcgamingfreaks.Database.ConnectionProvider.ConnectionProvider;
import at.pcgamingfreaks.Database.ConnectionProvider.MySQLConnectionProvider;
import at.pcgamingfreaks.Database.DBTools;
import at.pcgamingfreaks.Database.DatabaseConnectionConfiguration;
import at.pcgamingfreaks.MarriageMaster.API.Home;
import at.pcgamingfreaks.MarriageMaster.Database.Backend.SQL;
import at.pcgamingfreaks.MarriageMaster.Database.Cache;
import at.pcgamingfreaks.MarriageMaster.Database.DatabaseConfiguration;
import at.pcgamingfreaks.MarriageMaster.Database.IPlatformSpecific;
import at.pcgamingfreaks.MarriageMaster.Database.MarriageDataBase;
import at.pcgamingfreaks.MarriageMaster.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.Version;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MySQL<MARRIAGE_PLAYER extends MarriagePlayerDataBase, MARRIAGE extends MarriageDataBase, HOME extends Home>
extends SQL<MARRIAGE_PLAYER, MARRIAGE, HOME> {
    private Version serverVersion = null;

    public MySQL(@NotNull IPlatformSpecific<MARRIAGE_PLAYER, MARRIAGE, HOME> platform, @NotNull DatabaseConfiguration dbConfig, boolean bungee, boolean surname, @NotNull Cache<MARRIAGE_PLAYER, MARRIAGE> cache, @NotNull Logger logger, @Nullable ConnectionProvider connectionProvider, @NotNull String pluginName) {
        super(platform, dbConfig, bungee, surname, cache, logger, (ConnectionProvider)(connectionProvider == null ? new MySQLConnectionProvider(logger, pluginName, (DatabaseConnectionConfiguration)dbConfig) : connectionProvider));
    }

    @Override
    public boolean supportsBungeeCord() {
        return true;
    }

    @Override
    @NotNull
    public String getDatabaseTypeName() {
        return "MySQL";
    }

    @Override
    @NotNull
    protected String getEngine() {
        return " ENGINE=InnoDB";
    }

    @Override
    protected void buildQueries() {
        this.queryAddPlayer = "INSERT IGNORE INTO {TPlayers} ({FName},{FUUID},{FShareBackpack}) SELECT ?,?,? FROM (SELECT 1) AS `tmp` WHERE NOT EXISTS (SELECT * FROM {TPlayers} WHERE {FUUID}=?);";
        super.buildQueries();
    }

    void queryDatabaseVersion(@NotNull Connection connection) {
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT VERSION();");){
            if (rs.next()) {
                String version = rs.getString(1);
                this.logger.info("MySQL server version: " + version);
                this.serverVersion = new Version(version);
            }
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Failed to obtain MySQL server version!", e);
        }
        if (this.serverVersion == null) {
            this.logger.warning("Unable to obtain MySQL server version.");
            this.serverVersion = new Version("1.0");
        }
    }

    @Override
    protected void checkDatabase() {
        try (Connection connection = this.getConnection();){
            this.queryDatabaseVersion(connection);
            String dateDefault = "NOW()";
            if (this.serverVersion.olderThan(new Version("6.0"))) {
                try (Statement stmt = connection.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT NOW();");){
                    dateDefault = "'" + (rs.next() ? rs.getString(1) : "2019-07-19 12:12:12") + "'";
                }
            }
            String queryTPlayers = this.replacePlaceholders("CREATE TABLE IF NOT EXISTS {TPlayers} (\n{FPlayerID} INT UNSIGNED NOT NULL AUTO_INCREMENT,\n{FName} VARCHAR(16) NOT NULL,\n{FUUID} CHAR(36) DEFAULT NULL,\n{FShareBackpack} TINYINT(1) NOT NULL DEFAULT 0,\nPRIMARY KEY ({FPlayerID}),\nUNIQUE INDEX {FUUID}_UNIQUE ({FUUID})\n)" + this.getEngine() + ";");
            String queryTMarriages = this.replacePlaceholders("CREATE TABLE IF NOT EXISTS {TMarriages} (\n{FMarryID} INT UNSIGNED NOT NULL AUTO_INCREMENT,\n{FPlayer1} INT UNSIGNED NOT NULL,\n{FPlayer2} INT UNSIGNED NOT NULL,\n{FPriest} INT UNSIGNED NULL,\n{FSurname} VARCHAR(45) NULL,\n{FPvPState} TINYINT(1) NOT NULL DEFAULT 0,\n{FDate} DATETIME NOT NULL DEFAULT " + dateDefault + ",\n{FColor} VARCHAR(20) NULL DEFAULT NULL,\nPRIMARY KEY ({FMarryID}),\nINDEX {FPlayer1}_idx ({FPlayer1}),\nINDEX {FPlayer2}_idx ({FPlayer2}),\nINDEX {FPriest}_idx ({FPriest}),\nCONSTRAINT fk_{TMarriages}_{TPlayers}_{FPlayer1} FOREIGN KEY ({FPlayer1}) REFERENCES {TPlayers} ({FPlayerID}) ON DELETE CASCADE ON UPDATE CASCADE,\nCONSTRAINT fk_{TMarriages}_{TPlayers}_{FPlayer2} FOREIGN KEY ({FPlayer2}) REFERENCES {TPlayers} ({FPlayerID}) ON DELETE CASCADE ON UPDATE CASCADE,\nCONSTRAINT fk_{TMarriages}_{TPlayers}_{FPriest} FOREIGN KEY ({FPriest}) REFERENCES {TPlayers} ({FPlayerID}) ON DELETE SET NULL ON UPDATE CASCADE\n)" + this.getEngine() + ";");
            String queryTHomes = this.replacePlaceholders("CREATE TABLE IF NOT EXISTS {THomes} (\n{FMarryID} INT UNSIGNED NOT NULL,\n{FHomeX} DOUBLE NOT NULL,\n{FHomeY} DOUBLE NOT NULL,\n{FHomeZ} DOUBLE NOT NULL,\n{FHomeYaw} FLOAT NOT NULL DEFAULT 0,\n{FHomePitch} FLOAT NOT NULL DEFAULT 0,\n{FHomeWorld} VARCHAR(45) NOT NULL DEFAULT 'world',\n" + (this.useBungee ? "{FHomeServer} VARCHAR(45) DEFAULT NULL,\n" : "") + "PRIMARY KEY ({FMarryID}),\nCONSTRAINT fk_{THomes}_{TMarriages}_{FMarryID} FOREIGN KEY ({FMarryID}) REFERENCES {TMarriages} ({FMarryID}) ON DELETE CASCADE ON UPDATE CASCADE\n)" + this.getEngine() + ";");
            DBTools.updateDB((Connection)connection, (String)queryTPlayers);
            DBTools.updateDB((Connection)connection, (String)queryTMarriages);
            DBTools.updateDB((Connection)connection, (String)queryTHomes);
            this.checkPriestsTable(connection);
            DBTools.runStatement((Connection)connection, (String)this.replacePlaceholders("UPDATE {TMarriages} SET {FDate}=NOW() WHERE {FDate}=0;"), (Object[])new Object[0]);
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Failed to setup database tables!", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkPriestsTable(@NotNull Connection connection) throws SQLException {
        Throwable throwable;
        ResultSet rs;
        boolean exists = false;
        try (PreparedStatement preparedStatement = connection.prepareStatement("SHOW TABLES LIKE ?;");){
            preparedStatement.setString(1, this.tablePriests);
            rs = preparedStatement.executeQuery();
            throwable = null;
            try {
                if (rs.next()) {
                    exists = true;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        if (exists) {
            var4_4 = null;
            try (Statement stmt = connection.createStatement();){
                rs = stmt.executeQuery(this.replacePlaceholders("SHOW KEYS FROM {TPriests} WHERE Key_name = 'PRIMARY'"));
                throwable = null;
                try {
                    String primKey;
                    if (!rs.next() || (primKey = rs.getString("Column_name")).equalsIgnoreCase(this.fieldPriestID)) return;
                    this.logger.warning("PriestId field name currently used (" + primKey + ") in the database does not math the configured one in the config (" + this.fieldPriestID + ")!\nIf you would like to change the name of the field please change both the name in the database and the config.\nChanging config to: " + primKey);
                    this.dbConfig.getConfigE().set("Database.SQL.Tables.Fields.PriestID", (Object)primKey);
                    try {
                        ((Configuration)this.dbConfig).save();
                    }
                    catch (FileNotFoundException e) {
                        this.logger.log(Level.WARNING, "Failed to save priest column name in config!", e);
                    }
                    this.fieldPriestID = primKey;
                    return;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var4_4 = throwable6;
                throw throwable6;
            }
        }
        String queryTPriests = this.replacePlaceholders("CREATE TABLE IF NOT EXISTS {TPriests} (\n{FPriestID} INT UNSIGNED NOT NULL,\nPRIMARY KEY ({FPriestID}),\nCONSTRAINT fk_{TPriests}_{TPlayers}_{FPriestID} FOREIGN KEY ({FPriestID}) REFERENCES {TPlayers} ({FPlayerID}) ON DELETE CASCADE ON UPDATE CASCADE\n)" + this.getEngine() + ";");
        DBTools.updateDB((Connection)connection, (String)queryTPriests);
    }
}

