/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Database.Backend;

import at.pcgamingfreaks.MarriageMaster.API.Home;
import at.pcgamingfreaks.MarriageMaster.Database.Cache;
import at.pcgamingfreaks.MarriageMaster.Database.DatabaseConfiguration;
import at.pcgamingfreaks.MarriageMaster.Database.FilesMigrator.MigrationMarriage;
import at.pcgamingfreaks.MarriageMaster.Database.FilesMigrator.MigrationPlayer;
import at.pcgamingfreaks.MarriageMaster.Database.IPlatformSpecific;
import at.pcgamingfreaks.MarriageMaster.Database.MarriageDataBase;
import at.pcgamingfreaks.MarriageMaster.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.MarriageMaster.Database.MarriageSavedCallback;
import java.util.UUID;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class DatabaseBackend<MARRIAGE_PLAYER extends MarriagePlayerDataBase, MARRIAGE extends MarriageDataBase, HOME extends Home> {
    protected static final String MESSAGE_UPDATE_UUIDS = "Start updating database to UUIDs ...";
    protected static final String MESSAGE_UPDATED_UUIDS = "Updated %d accounts to UUIDs.";
    protected final IPlatformSpecific<MARRIAGE_PLAYER, MARRIAGE, HOME> platform;
    protected final boolean useBungee;
    protected final boolean useUUIDSeparators;
    protected final boolean useOnlineUUIDs;
    protected final boolean surnameEnabled;
    protected final Cache<MARRIAGE_PLAYER, MARRIAGE> cache;
    protected final Logger logger;
    protected MarriageSavedCallback marriageSavedCallback = null;

    protected DatabaseBackend(@NotNull IPlatformSpecific<MARRIAGE_PLAYER, MARRIAGE, HOME> platform, @NotNull DatabaseConfiguration dbConfig, boolean useBungee, boolean surnameEnabled, @NotNull Cache<MARRIAGE_PLAYER, MARRIAGE> cache, @NotNull Logger logger) {
        this.platform = platform;
        this.useBungee = useBungee;
        this.logger = logger;
        this.surnameEnabled = surnameEnabled;
        this.cache = cache;
        this.useUUIDSeparators = dbConfig.useUUIDSeparators();
        this.useOnlineUUIDs = dbConfig.useOnlineUUIDs();
    }

    public void close() {
    }

    public void startup() throws Exception {
        this.checkUUIDs();
    }

    public abstract boolean supportsBungeeCord();

    protected String getUsedPlayerIdentifier(MARRIAGE_PLAYER player) {
        return this.useUUIDSeparators ? ((MarriagePlayerDataBase)player).getUUID().toString() : ((MarriagePlayerDataBase)player).getUUID().toString().replace("-", "");
    }

    @NotNull
    protected UUID getUUIDFromIdentifier(@NotNull String identifier) {
        return UUID.fromString(this.useUUIDSeparators ? identifier : identifier.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
    }

    protected void runAsync(@NotNull Runnable runnable) {
        this.runAsync(runnable, 0L);
    }

    protected void runAsync(@NotNull Runnable runnable, long delay) {
        this.platform.runAsync(runnable, delay);
    }

    @NotNull
    public abstract String getDatabaseTypeName();

    public abstract void checkUUIDs();

    public abstract void loadAll();

    public abstract void load(@NotNull MARRIAGE_PLAYER var1);

    public abstract void updateHome(@NotNull MARRIAGE var1);

    public abstract void updatePvPState(@NotNull MARRIAGE var1);

    public abstract void updateBackpackShareState(@NotNull MARRIAGE_PLAYER var1);

    public abstract void updatePriestStatus(@NotNull MARRIAGE_PLAYER var1);

    public abstract void updateSurname(@NotNull MARRIAGE var1);

    public abstract void updateMarriageColor(@NotNull MARRIAGE var1);

    public abstract void marry(@NotNull MARRIAGE var1);

    public abstract void divorce(@NotNull MARRIAGE var1);

    public abstract void migratePlayer(@NotNull MigrationPlayer var1);

    public abstract void migrateMarriage(@NotNull MigrationMarriage var1);

    public void setMarriageSavedCallback(MarriageSavedCallback marriageSavedCallback) {
        this.marriageSavedCallback = marriageSavedCallback;
    }
}

