/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bungee.Listener;

import at.pcgamingfreaks.MarriageMaster.Bungee.Commands.HomeCommand;
import at.pcgamingfreaks.MarriageMaster.Bungee.Commands.TpCommand;
import at.pcgamingfreaks.MarriageMaster.Bungee.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Database.PluginChannelCommunicatorBase;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;

public class PluginChannelCommunicator
extends PluginChannelCommunicatorBase
implements Listener {
    private final Plugin plugin;
    private HomeCommand home = null;
    private TpCommand tp = null;

    public PluginChannelCommunicator(MarriageMaster plugin) {
        super(plugin.getLogger(), plugin.getDatabase());
        this.plugin = plugin;
        plugin.getProxy().registerChannel("marriagemaster:main");
        plugin.getProxy().getPluginManager().registerListener((Plugin)plugin, (Listener)this);
        this.sendMessage(PluginChannelCommunicator.buildStringMessage("UseUUIDs", "true"), true);
        this.sendMessage(PluginChannelCommunicator.buildStringMessage("UseUUIDSeparators", plugin.getConfig().useUUIDSeparators() + ""), true);
        this.sendMessage(PluginChannelCommunicator.buildStringMessage("UUID_Type", plugin.getConfig().useOnlineUUIDs() ? "online" : "offline"), true);
    }

    public void setHomeCommand(HomeCommand home) {
        this.home = home;
    }

    public void setTpCommand(TpCommand tp) {
        this.tp = tp;
    }

    @EventHandler(priority=0)
    public void onPluginMessage(PluginMessageEvent event) {
        if (!(event.getSender() instanceof Server)) {
            return;
        }
        if (this.receive(event.getTag(), event.getData())) {
            ServerInfo source = ((Server)event.getSender()).getInfo();
            for (Map.Entry server : this.plugin.getProxy().getServers().entrySet()) {
                if (((ServerInfo)server.getValue()).equals(source)) continue;
                ((ServerInfo)server.getValue()).sendData("marriagemaster:main", event.getData(), false);
            }
        }
    }

    @Override
    protected void receiveUnknownChannel(@NotNull String channel, byte[] bytes) {
    }

    @Override
    protected boolean receiveMarriageMaster(@NotNull String cmd, @NotNull DataInputStream inputStream) throws IOException {
        switch (cmd) {
            case "home": {
                this.home.sendHome(UUID.fromString(inputStream.readUTF()), UUID.fromString(inputStream.readUTF()));
                break;
            }
            case "tp": {
                this.tp.sendTP(UUID.fromString(inputStream.readUTF()), UUID.fromString(inputStream.readUTF()));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void sendMessage(@NotNull byte[] data, boolean queue) {
        for (Map.Entry server : this.plugin.getProxy().getServers().entrySet()) {
            ((ServerInfo)server.getValue()).sendData("marriagemaster:main", data, queue);
        }
    }

    @Override
    protected void sendMessage(@NotNull byte[] data) {
        this.sendMessage(data, false);
    }

    public void sendMessage(@NotNull ServerInfo server, String ... msg) {
        server.sendData("marriagemaster:main", PluginChannelCommunicator.buildStringMessage(msg));
    }

    @Override
    public void close() {
        super.close();
        this.plugin.getProxy().unregisterChannel("marriagemaster:main");
    }
}

