/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bungee.Database;

import at.pcgamingfreaks.Config.Configuration;
import at.pcgamingfreaks.Config.ILanguageConfiguration;
import at.pcgamingfreaks.Config.YamlFileManager;
import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMaster.Bungee.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Bungee.SpecialInfoWorker.UpgradedInfo;
import at.pcgamingfreaks.MarriageMaster.Database.DatabaseConfiguration;
import at.pcgamingfreaks.MarriageMaster.MagicValues;
import at.pcgamingfreaks.Plugin.IPlugin;
import at.pcgamingfreaks.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.md_5.bungee.api.ProxyServer;

public class Config
extends Configuration
implements DatabaseConfiguration,
ILanguageConfiguration {
    public Config(MarriageMaster plugin) {
        super((IPlugin)plugin, new Version(MagicValues.BUNGEE_CONFIG_VERSION));
    }

    protected void doUpgrade(YamlFileManager oldConfig) {
        if (oldConfig.version().olderThan(new Version(90))) {
            this.getLogger().warning(ConsoleColor.RED + "Your config file is from v1.x and is not compatible with versions newer than 2.5!" + ConsoleColor.RESET);
            new UpgradedInfo(MarriageMaster.getInstance());
        } else {
            HashMap<String, String> reMappings = new HashMap<String, String>();
            if (oldConfig.version().olderThan("101")) {
                reMappings.put("Misc.AutoUpdate.Enable", "Misc.AutoUpdate");
            }
            if (oldConfig.version().olderThan("102")) {
                reMappings.put("Database.Cache.UnCache.Strategy", "Database.Cache.UnCache.Strategie");
            }
            super.doUpgrade(oldConfig, reMappings, oldConfig.getYamlE().getKeysFiltered("Database\\.SQL\\.(Tables\\.Fields\\..+|MaxLifetime|IdleTimeout)"));
        }
    }

    public boolean areMultiplePartnersAllowed() {
        return this.getConfigE().getBoolean("Marriage.AllowMultiplePartners", false);
    }

    public boolean isSelfMarriageAllowed() {
        return this.getConfigE().getBoolean("Marriage.AllowSelfMarriage", false);
    }

    public boolean isSurnamesEnabled() {
        return this.getConfigE().getBoolean("Marriage.Surnames.Enable", false);
    }

    public boolean isSurnamesForced() {
        return this.getConfigE().getBoolean("Marriage.Surnames.Forced", false);
    }

    @Override
    public boolean useOnlineUUIDs() {
        String type = this.getConfigE().getString("Database.UUID_Type", "auto").toLowerCase(Locale.ENGLISH);
        if (type.equals("auto")) {
            return ProxyServer.getInstance().getConfig().isOnlineMode();
        }
        return type.equals("online");
    }

    public boolean isChatHandlerEnabled() {
        return this.getConfigE().getBoolean("Chat.Global", true);
    }

    public boolean isTPHandlerEnabled() {
        return this.getConfigE().getBoolean("Teleport.Global", true);
    }

    public boolean isTPDelayed() {
        return this.getConfigE().getBoolean("Teleport.Delayed", false);
    }

    public Set<String> getTPBlackListedServersFrom() {
        return new HashSet<String>(Config.toLowerCase(this.getConfigE().getStringList("Teleport.BlockedFrom", new ArrayList(0))));
    }

    public Set<String> getTPBlackListedServersTo() {
        return new HashSet<String>(Config.toLowerCase(this.getConfigE().getStringList("Teleport.BlockedTo", new ArrayList(0))));
    }

    public boolean isHomeHandlerEnabled() {
        return this.getConfigE().getBoolean("Home.Global", true);
    }

    public boolean isHomeDelayed() {
        return this.getConfigE().getBoolean("Home.Delayed", false);
    }

    public Set<String> getHomeBlackListedServersFrom() {
        return new HashSet<String>(Config.toLowerCase(this.getConfigE().getStringList("Home.BlockedFrom", new ArrayList(0))));
    }

    public Set<String> getHomeBlackListedServersTo() {
        return new HashSet<String>(Config.toLowerCase(this.getConfigE().getStringList("Home.BlockedTo", new ArrayList(0))));
    }

    public boolean isJoinLeaveInfoEnabled() {
        return this.getConfigE().getBoolean("InfoOnPartnerJoinLeave.Enable", true);
    }

    public long getJoinInfoDelay() {
        return this.getConfigE().getLong("InfoOnPartnerJoinLeave.JoinDelay", 0L);
    }

    public boolean useUpdater() {
        return this.getConfigE().getBoolean("Misc.AutoUpdate.Enable", this.getConfigE().getBoolean("Misc.AutoUpdate", true));
    }

    public String getUpdateChannel() {
        String channel = this.getConfigE().getString("Misc.AutoUpdate.Channel", "Release");
        if ("Release".equals(channel) || "Master".equals(channel) || "Dev".equals(channel)) {
            return channel;
        }
        this.logger.info("Unknown update Channel: " + channel);
        return null;
    }

    private static List<String> toLowerCase(List<String> strings) {
        ArrayList<String> outList = new ArrayList<String>(strings.size());
        for (String str : strings) {
            outList.add(str.toLowerCase(Locale.ENGLISH));
        }
        return outList;
    }
}

