/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bungee.Commands;

import at.pcgamingfreaks.Bungee.Message.Message;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bungee.Listener.PluginChannelCommunicator;
import at.pcgamingfreaks.MarriageMaster.Bungee.MarriageMaster;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TpCommand
extends MarryCommand {
    private final Set<String> blockedFrom;
    private final Set<String> blockedTo;
    private final boolean delayed;
    private final Message messageBlockedFrom;
    private final Message messageBlockedTo;
    private final PluginChannelCommunicator communicator;

    public TpCommand(MarriageMaster plugin) {
        super((Plugin)plugin, "tp", plugin.getLanguage().getTranslated("Commands.Description.Tp"), "marry.tp", true, true, plugin.getLanguage().getCommandAliases("Tp"));
        this.blockedFrom = plugin.getConfig().getTPBlackListedServersFrom();
        this.blockedTo = plugin.getConfig().getTPBlackListedServersTo();
        this.delayed = plugin.getConfig().isTPDelayed();
        this.messageBlockedTo = plugin.getLanguage().getMessage("Ingame.TP.BlockedTo");
        this.messageBlockedFrom = plugin.getLanguage().getMessage("Ingame.TP.BlockedFrom");
        this.communicator = plugin.getPluginChannelCommunicator();
        this.communicator.setTpCommand(this);
    }

    @Override
    public void close() {
        this.communicator.setTpCommand(null);
    }

    @Override
    public void execute(@NotNull CommandSender sender, @Nullable String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer partner;
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((ProxiedPlayer)sender);
        MarriagePlayer marriagePlayer = partner = this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length >= 1 ? (MarriagePlayer)player.getPartner(args[0]) : (MarriagePlayer)((Marriage)player.getMarriageData()).getPartner(player);
        if (partner == null) {
            player.send(((MarriageMaster)this.getMarriagePlugin()).messageTargetPartnerNotFound, new Object[0]);
        } else if (partner.isOnline()) {
            String serverName = ((ProxiedPlayer)player.getPlayer()).getServer().getInfo().getName().toLowerCase(Locale.ENGLISH);
            if (!this.blockedFrom.contains(serverName) || player.hasPermission("marry.bypass.serverblacklist")) {
                if (!this.blockedTo.contains(serverName) || player.hasPermission("marry.bypass.serverblacklist")) {
                    if (this.delayed && !sender.hasPermission("marry.bypass.delay")) {
                        this.communicator.sendMessage(((ProxiedPlayer)player.getPlayer()).getServer().getInfo(), "delayTP", player.getUUID().toString(), player.getUUID().toString());
                    } else {
                        this.sendTP((ProxiedPlayer)sender, (ProxiedPlayer)partner.getPlayer());
                    }
                } else {
                    player.send(this.messageBlockedTo, new Object[0]);
                }
            } else {
                player.send(this.messageBlockedFrom, new Object[0]);
            }
        } else {
            player.send(((MarriageMaster)this.getMarriagePlugin()).messagePartnerOffline, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
    }

    public void sendTP(@NotNull UUID playerUUID, @NotNull UUID partnerUUID) {
        MarriagePlayer player;
        ProxiedPlayer pPlayer = this.plugin.getProxy().getPlayer(playerUUID);
        if (pPlayer != null && (player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(pPlayer)).isMarried()) {
            ProxiedPlayer pPartner;
            MarriagePlayer partner = (MarriagePlayer)player.getPartner(partnerUUID);
            ProxiedPlayer proxiedPlayer = pPartner = partner != null ? (ProxiedPlayer)partner.getPlayer() : null;
            if (pPartner != null) {
                this.sendTP(pPlayer, pPartner);
            }
        }
    }

    public void sendTP(ProxiedPlayer player, ProxiedPlayer partner) {
        ServerInfo partnerServer = partner.getServer().getInfo();
        if (!player.getServer().getInfo().getName().equals(partnerServer.getName())) {
            player.connect(partner.getServer().getInfo());
            this.plugin.getProxy().getScheduler().schedule(this.plugin, () -> this.communicator.sendMessage(partner.getServer().getInfo(), "tp", player.getUniqueId().toString(), partner.getUniqueId().toString()), 1L, TimeUnit.SECONDS);
        } else {
            this.communicator.sendMessage(partner.getServer().getInfo(), "tp", player.getUniqueId().toString(), partner.getUniqueId().toString());
        }
    }
}

