/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bungee.Commands;

import at.pcgamingfreaks.Bungee.Message.Message;
import at.pcgamingfreaks.MarriageMaster.API.Home;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bungee.Listener.PluginChannelCommunicator;
import at.pcgamingfreaks.MarriageMaster.Bungee.MarriageMaster;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class HomeCommand
extends MarryCommand {
    private final Message messagePlayerNoHome;
    private final Message messageNoHome;
    private final Message messageHomeBlockedTo;
    private final Message messageHomeBlockedFrom;
    private final Set<String> blockedFrom;
    private final Set<String> blockedTo;
    private final boolean delayed;
    private final PluginChannelCommunicator communicator;

    public HomeCommand(MarriageMaster plugin) {
        super((Plugin)plugin, "home", plugin.getLanguage().getTranslated("Commands.Description.Home"), "marry.home", false, true, plugin.getLanguage().getCommandAliases("Home"));
        this.messageNoHome = plugin.getLanguage().getMessage("Ingame.Home.NoHome");
        this.messagePlayerNoHome = plugin.getLanguage().getMessage("Ingame.Home.PlayerNoHome");
        this.messageHomeBlockedTo = plugin.getLanguage().getMessage("Ingame.Home.BlockedTo");
        this.messageHomeBlockedFrom = plugin.getLanguage().getMessage("Ingame.Home.BlockedFrom");
        this.delayed = plugin.getConfig().isHomeDelayed();
        this.blockedTo = plugin.getConfig().getHomeBlackListedServersTo();
        this.blockedFrom = plugin.getConfig().getHomeBlackListedServersFrom();
        this.communicator = plugin.getPluginChannelCommunicator();
        this.communicator.setHomeCommand(this);
    }

    @Override
    public void close() {
        this.communicator.setHomeCommand(null);
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((ProxiedPlayer)sender);
        if (player.isMarried() || sender.hasPermission("marry.home.others") && (!this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 1 || this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2)) {
            Marriage marriage = this.getTargetedMarriage(sender, player, args);
            if (marriage != null) {
                if (!marriage.isHomeSet()) {
                    if (sender.hasPermission("marry.home.others") && !((MarriagePlayer)marriage.getPartner1()).equals(player) && !((MarriagePlayer)marriage.getPartner2()).equals(player)) {
                        this.messagePlayerNoHome.send(sender, new Object[0]);
                    } else {
                        this.messageNoHome.send(sender, new Object[0]);
                    }
                } else if (!this.blockedFrom.contains(((ProxiedPlayer)sender).getServer().getInfo().getName().toLowerCase(Locale.ENGLISH))) {
                    if (!this.blockedTo.contains(((Home)marriage.getHome()).getHomeServer().toLowerCase(Locale.ENGLISH))) {
                        if (this.delayed && !player.hasPermission("marry.bypass.delay")) {
                            this.communicator.sendMessage(((ProxiedPlayer)sender).getServer().getInfo(), "delayHome", player.getUUID().toString(), ((MarriagePlayer)marriage.getPartner(player)).getUUID().toString());
                        } else {
                            this.sendHome((ProxiedPlayer)player.getPlayer(), marriage);
                        }
                    } else {
                        this.messageHomeBlockedTo.send(sender, new Object[0]);
                    }
                } else {
                    this.messageHomeBlockedFrom.send(sender, new Object[0]);
                }
            }
        } else {
            ((MarriageMaster)this.getMarriagePlugin()).messageNotMarried.send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        List<String> names = ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
        if (sender.hasPermission("marry.home.others")) {
            if (names == null) {
                names = new LinkedList<String>();
            }
            String arg = args[args.length - 1].toLowerCase(Locale.ENGLISH);
            for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
                if (names.contains(player.getName()) || sender.getName().equals(player.getName()) || !player.getName().toLowerCase(Locale.ENGLISH).startsWith(arg)) continue;
                names.add(player.getName());
            }
            if (names.isEmpty()) {
                names = null;
            }
        }
        return names;
    }

    @Override
    public boolean canUse(@NotNull CommandSender sender) {
        return super.canUse(sender) && (sender.hasPermission("marry.home.others") || ((MarriagePlayer)this.getMarriagePlugin().getPlayerData((ProxiedPlayer)sender)).isMarried());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Marriage getTargetedMarriage(CommandSender sender, MarriagePlayer player, String[] args) {
        if (this.getMarriagePlugin().areMultiplePartnersAllowed()) {
            if (args.length == 2 && sender.hasPermission("marry.home.others")) {
                MarriagePlayer target1 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
                MarriagePlayer target2 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[1]);
                if (target1.isMarried() && target2.isMarried() && target1.isPartner(target2)) {
                    return (Marriage)target1.getMarriageData(target2);
                }
                if (!target1.isMarried() || !target2.isMarried()) {
                    MarriagePlayer t = !target1.isMarried() ? target1 : target2;
                    ((MarriageMaster)this.getMarriagePlugin()).messagePlayerNotMarried.send(sender, new Object[]{t.getName()});
                    return null;
                } else {
                    ((MarriageMaster)this.getMarriagePlugin()).messagePlayersNotMarried.send(sender, new Object[0]);
                }
                return null;
            }
            if (args.length != 1) return (Marriage)player.getMarriageData();
            MarriagePlayer partner = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
            if (player.isPartner(partner)) return (Marriage)player.getMarriageData(partner);
            ((MarriageMaster)this.getMarriagePlugin()).messageTargetPartnerNotFound.send(sender, new Object[0]);
            return null;
        }
        if (args.length != 1) return (Marriage)player.getMarriageData();
        if (!sender.hasPermission("marry.home.others")) return (Marriage)player.getMarriageData();
        MarriagePlayer target = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
        if (target.isMarried()) {
            return (Marriage)target.getMarriageData();
        }
        ((MarriageMaster)this.getMarriagePlugin()).messagePlayerNotMarried.send(sender, new Object[]{target.getName()});
        return null;
    }

    public void sendHome(@NotNull UUID playerUUID, @NotNull UUID partnerUUID) {
        ProxiedPlayer pPlayer = this.plugin.getProxy().getPlayer(playerUUID);
        if (pPlayer != null) {
            Marriage marriage;
            MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(pPlayer);
            if (this.getMarriagePlugin().areMultiplePartnersAllowed()) {
                MarriagePlayer partner = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(partnerUUID);
                marriage = (Marriage)player.getMarriageData(partner);
            } else {
                marriage = (Marriage)player.getMarriageData();
            }
            if (marriage != null) {
                this.sendHome(pPlayer, marriage);
            }
        }
    }

    public void sendHome(ProxiedPlayer player, Marriage marriage) {
        if (marriage.getHome() == null) {
            return;
        }
        ServerInfo homeServer = this.plugin.getProxy().getServerInfo(((Home)marriage.getHome()).getHomeServer());
        if (!player.getServer().getInfo().getName().equals(homeServer.getName())) {
            player.connect(homeServer);
            this.plugin.getProxy().getScheduler().schedule(this.plugin, () -> this.sendHome(homeServer, player.getUniqueId(), (player.equals(((MarriagePlayer)marriage.getPartner1()).getPlayer()) ? (MarriagePlayer)marriage.getPartner2() : (MarriagePlayer)marriage.getPartner1()).getUUID()), 1L, TimeUnit.SECONDS);
        } else {
            this.sendHome(homeServer, player.getUniqueId(), (player.equals(((MarriagePlayer)marriage.getPartner1()).getPlayer()) ? (MarriagePlayer)marriage.getPartner2() : (MarriagePlayer)marriage.getPartner1()).getUUID());
        }
    }

    public void sendHome(ServerInfo homeServer, UUID player, UUID partner) {
        this.communicator.sendMessage(homeServer, "home", player.toString(), partner.toString());
    }
}

