/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bungee.Commands;

import at.pcgamingfreaks.Bungee.Command.CommandExecutorWithSubCommandsGeneric;
import at.pcgamingfreaks.Bungee.Message.Message;
import at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.Command.SubCommand;
import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bungee.Commands.ChatCommand;
import at.pcgamingfreaks.MarriageMaster.Bungee.Commands.HomeCommand;
import at.pcgamingfreaks.MarriageMaster.Bungee.Commands.TpCommand;
import at.pcgamingfreaks.MarriageMaster.Bungee.Commands.UpdateCommand;
import at.pcgamingfreaks.MarriageMaster.Bungee.MarriageMaster;
import at.pcgamingfreaks.Reflection;
import at.pcgamingfreaks.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManagerImplementation
extends CommandExecutorWithSubCommandsGeneric<MarryCommand>
implements Listener,
CommandManager {
    private final MarriageMaster plugin;
    private final HashSet<String> commandAliases = new HashSet();
    private String[] switchesOn;
    private String[] switchesOff;
    private String[] switchesToggle;
    private String[] switchesAll;
    private String[] switchesRemove;
    private Message helpFormat;

    public CommandManagerImplementation(MarriageMaster plugin) {
        this.plugin = plugin;
    }

    public void init() {
        this.switchesOn = this.plugin.getLanguage().getSwitch("On", "on");
        this.switchesOff = this.plugin.getLanguage().getSwitch("Off", "off");
        this.switchesToggle = this.plugin.getLanguage().getSwitch("Toggle", "toggle");
        this.switchesAll = this.plugin.getLanguage().getSwitch("All", "all");
        this.switchesRemove = this.plugin.getLanguage().getSwitch("Remove", "remove");
        this.commandAliases.add("marry");
        for (String alias : this.plugin.getLanguage().getCommandAliases("marry")) {
            this.commandAliases.add(alias.toLowerCase());
        }
        this.plugin.getProxy().getPluginManager().registerListener((Plugin)this.plugin, (Listener)this);
        this.helpFormat = (Message)((Message)((Message)((Message)this.plugin.getLanguage().getMessage("Commands.HelpFormat").placeholder("MainCommand")).placeholder("SubCommand")).placeholder("Parameters")).placeholder("Description");
        try {
            Reflection.setStaticField(MarryCommand.class, (String)"showHelp", (Object)this.getClass().getDeclaredMethod("sendHelp", CommandSender.class, String.class, Collection.class));
            Reflection.setStaticField(MarryCommand.class, (String)"marriagePlugin", (Object)this.plugin);
            Reflection.setStaticField(MarryCommand.class, (String)"messageNoPermission", (Object)this.plugin.messageNoPermission);
            Reflection.setStaticField(MarryCommand.class, (String)"messageNotMarried", (Object)this.plugin.messageNotMarried);
            Reflection.setStaticField(MarryCommand.class, (String)"messageNotFromConsole", (Object)this.plugin.messageNotFromConsole);
            Reflection.setStaticField(MarryCommand.class, (String)"helpPartnerSelector", (Object)("<" + this.plugin.helpPartnerNameVariable + ">"));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, ConsoleColor.RED + "Unable to set the help format. Default format will be used." + ConsoleColor.RESET, e);
        }
        if (this.plugin.getConfig().isChatHandlerEnabled()) {
            this.registerSubCommand((SubCommand)new ChatCommand(this.plugin));
        }
        if (this.plugin.getConfig().isTPHandlerEnabled()) {
            this.registerSubCommand((SubCommand)new TpCommand(this.plugin));
        }
        if (this.plugin.getConfig().isHomeHandlerEnabled()) {
            this.registerSubCommand((SubCommand)new HomeCommand(this.plugin));
        }
        if (this.plugin.getConfig().useUpdater()) {
            this.registerSubCommand((SubCommand)new UpdateCommand(this.plugin));
        }
    }

    public void close() {
        this.plugin.getProxy().getPluginManager().unregisterListener((Listener)this);
        super.close();
    }

    public void sendHelp(CommandSender target, String marryAlias, Collection<HelpData> data) {
        for (HelpData d : data) {
            this.helpFormat.send(target, new Object[]{marryAlias, d.getTranslatedSubCommand(), d.getParameter(), d.getDescription()});
        }
    }

    @EventHandler(priority=-64)
    public void onChat(ChatEvent event) {
        MarryCommand mC;
        String[] args;
        String cmd;
        if (event.isCommand() && this.commandAliases.contains(cmd = (args = event.getMessage().split("\\s+"))[0].toLowerCase().substring(1)) && args.length > 1 && (args = Arrays.copyOfRange(args, 1, args.length)).length > 0 && (mC = (MarryCommand)this.subCommandMap.get(args[0].toLowerCase())) != null) {
            mC.doExecute((CommandSender)event.getSender(), cmd, args[0], args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            event.setCancelled(true);
        }
    }

    @Override
    public boolean isOnSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesOn, (String)str);
    }

    @Override
    public boolean isOffSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesOff, (String)str);
    }

    @Override
    public boolean isToggleSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesToggle, (String)str);
    }

    @Override
    public boolean isAllSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesAll, (String)str);
    }

    @Override
    public boolean isRemoveSwitch(@Nullable String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesRemove, (String)str);
    }

    @Override
    @NotNull
    public String getOnSwitchTranslation() {
        return this.switchesOn[0];
    }

    @Override
    @NotNull
    public String getOffSwitchTranslation() {
        return this.switchesOff[0];
    }

    @Override
    @NotNull
    public String getToggleSwitchTranslation() {
        return this.switchesToggle[0];
    }

    @Override
    @NotNull
    public String getAllSwitchTranslation() {
        return this.switchesAll[0];
    }

    @Override
    @NotNull
    public String getRemoveSwitchTranslation() {
        return this.switchesRemove[0];
    }

    @Override
    @Nullable
    public List<String> getSimpleTabComplete(@NotNull CommandSender sender, String ... args) {
        List<String> names = null;
        if (sender instanceof ProxiedPlayer && this.plugin.areMultiplePartnersAllowed() && args != null && args.length == 1 && (names = this.plugin.getPlayerData((ProxiedPlayer)sender).getMatchingPartnerNames(args[0])).isEmpty()) {
            names = null;
        }
        return names;
    }
}

