/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.NotNull;

public class PluginClassLoaderBypass {
    private static final Class<?> PLUGIN_CLASS_LOADER;
    private static final Field FIELD_CLASSES;
    private static final Method SET_CLASS;
    private static final Method GET_PACKAGE;
    private static final Method DEFINE_CLASS;
    private static final Method DEFINE_PACKAGE;
    private static final Method DEFINE_PACKAGE_WITHOUT_MANIFEST;
    private final ClassLoader classLoader;
    private final JavaPluginLoader loader;
    private JarFile jar;
    private Manifest manifest;
    private URL url;

    public PluginClassLoaderBypass(ClassLoader classLoader) throws Exception {
        if (!classLoader.getClass().equals(PLUGIN_CLASS_LOADER)) {
            throw new IllegalArgumentException("The given class loader must be a Bukkit PluginClassLoader!");
        }
        this.classLoader = classLoader;
        this.loader = (JavaPluginLoader)PluginClassLoaderBypass.getField(PLUGIN_CLASS_LOADER, "loader").get(classLoader);
        try {
            this.jar = (JarFile)PluginClassLoaderBypass.getField(PLUGIN_CLASS_LOADER, "jar").get(classLoader);
            this.url = (URL)PluginClassLoaderBypass.getField(PLUGIN_CLASS_LOADER, "url").get(classLoader);
            this.manifest = (Manifest)PluginClassLoaderBypass.getField(PLUGIN_CLASS_LOADER, "manifest").get(classLoader);
        }
        catch (Exception e) {
            File file = (File)PluginClassLoaderBypass.getField(PLUGIN_CLASS_LOADER, "file").get(classLoader);
            this.jar = new JarFile(file, true);
            this.manifest = this.jar.getManifest();
            this.url = file.toURI().toURL();
        }
    }

    public void loadClass(String name) throws Exception {
        byte[] classBytes;
        JarEntry entry = this.jar.getJarEntry(this.getPath(name));
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        try (InputStream stream = this.jar.getInputStream(entry);){
            classBytes = this.loadJarData(name, stream);
        }
        this.checkPackage(name);
        Class<?> result = this.buildClass(name, classBytes, entry);
        this.installClass(name, result);
    }

    protected Class<?> buildClass(@NotNull String name, byte[] classBytes, JarEntry entry) throws Exception {
        CodeSigner[] signers = entry.getCodeSigners();
        CodeSource source = new CodeSource(this.url, signers);
        return (Class)DEFINE_CLASS.invoke((Object)this.classLoader, name, classBytes, 0, classBytes.length, source);
    }

    protected void checkPackage(@NotNull String name) throws Exception {
        block6: {
            int dot = name.lastIndexOf(46);
            if (dot != -1) {
                String pkgName = name.substring(0, dot);
                if (GET_PACKAGE.invoke((Object)this.classLoader, pkgName) == null) {
                    try {
                        if (this.manifest != null) {
                            DEFINE_PACKAGE.invoke((Object)this.classLoader, pkgName, this.manifest, this.url);
                        } else {
                            DEFINE_PACKAGE_WITHOUT_MANIFEST.invoke((Object)this.classLoader, pkgName, null, null, null, null, null, null, null);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (Package.getPackage(pkgName) != null) break block6;
                        throw new IllegalStateException("Cannot find package " + pkgName);
                    }
                }
            }
        }
    }

    protected void installClass(String name, Class<?> result) throws Exception {
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        SET_CLASS.invoke((Object)this.loader, name, result);
        Map classes = (Map)FIELD_CLASSES.get(this.classLoader);
        classes.put(name, result);
    }

    @NotNull
    protected String getPath(@NotNull String className) {
        return className.replace('.', '/').concat(".class");
    }

    protected byte[] loadJarData(@NotNull String name, @NotNull InputStream stream) throws Exception {
        return ByteStreams.toByteArray((InputStream)stream);
    }

    @NotNull
    protected static Field getField(@NotNull Class<?> clazz, @NotNull String name) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    @NotNull
    protected static Method getMethod(@NotNull Class<?> clazz, @NotNull String name, Class<?> ... args) throws Exception {
        Method method = clazz.getDeclaredMethod(name, args);
        method.setAccessible(true);
        return method;
    }

    static {
        Class<?> pcl = null;
        Field classes = null;
        Method setClass = null;
        Method getPackage = null;
        Method defineClass = null;
        Method definePackage = null;
        Method definePackageNF = null;
        try {
            pcl = Class.forName("org.bukkit.plugin.java.PluginClassLoader");
            classes = PluginClassLoaderBypass.getField(pcl, "classes");
            setClass = PluginClassLoaderBypass.getMethod(JavaPluginLoader.class, "setClass", String.class, Class.class);
            getPackage = PluginClassLoaderBypass.getMethod(ClassLoader.class, "getPackage", String.class);
            defineClass = PluginClassLoaderBypass.getMethod(SecureClassLoader.class, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, CodeSource.class);
            definePackage = PluginClassLoaderBypass.getMethod(URLClassLoader.class, "definePackage", String.class, Manifest.class, URL.class);
            definePackageNF = PluginClassLoaderBypass.getMethod(ClassLoader.class, "definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PLUGIN_CLASS_LOADER = pcl;
        FIELD_CLASSES = classes;
        SET_CLASS = setClass;
        GET_PACKAGE = getPackage;
        DEFINE_CLASS = defineClass;
        DEFINE_PACKAGE = definePackage;
        DEFINE_PACKAGE_WITHOUT_MANIFEST = definePackageNF;
    }
}

