/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.Replacer;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.PlaceholderName;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.PlaceholderReplacer;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.NotImplementedException;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlaceholderReplacerBase
implements PlaceholderReplacer {
    private static final String PLACEHOLDER_NOT_MARRIED_KEY = "NotMarried";
    private static final String PLACEHOLDER_DEFAULT_KEY = "Default.";
    private static final String NULL_MAGIC = "NULL";
    protected final MarriageMaster plugin;
    protected final String valueNotMarried;

    protected PlaceholderReplacerBase(@NotNull MarriageMaster plugin) {
        this.plugin = plugin;
        this.valueNotMarried = this.getPlaceholderValue(PLACEHOLDER_NOT_MARRIED_KEY);
    }

    @Nullable
    protected String getPlaceholderValue(@NotNull String placeholderKey) {
        return this.getPlaceholderValue(this.getName(), placeholderKey);
    }

    @Nullable
    protected String getPlaceholderValue(@NotNull String placeholder, @NotNull String placeholderKey) {
        String p = placeholder + "." + placeholderKey;
        String msg = this.plugin.getLanguage().isPlaceholderSet(p) ? this.plugin.getLanguage().getTranslatedPlaceholder(p) : this.plugin.getLanguage().getTranslatedPlaceholder(PLACEHOLDER_DEFAULT_KEY + placeholderKey);
        if (msg == "&cMarriage Master placeholder not found! Check your language file!") {
            this.plugin.getLogger().warning("No placeholder translation for key: " + p);
        }
        return msg.equals(NULL_MAGIC) ? null : msg;
    }

    @Override
    @Nullable
    public String replace(OfflinePlayer player) {
        MarriagePlayer playerData = this.plugin.getPlayerData(player);
        if (playerData.isMarried()) {
            return this.replaceMarried(playerData);
        }
        return this.valueNotMarried;
    }

    @Nullable
    protected String replaceMarried(MarriagePlayer player) {
        throw new NotImplementedException("The replaceMarried method for the placeholder has not been implemented!");
    }

    @Override
    @NotNull
    public String getName() {
        String name;
        if (this.getClass().isAnnotationPresent(PlaceholderName.class) && !(name = this.getClass().getAnnotation(PlaceholderName.class).name()).isEmpty()) {
            return name;
        }
        return this.getClass().getSimpleName();
    }

    @Override
    @NotNull
    public Collection<String> getAliases() {
        LinkedList<String> aliasesList = new LinkedList<String>();
        if (this.getClass().isAnnotationPresent(PlaceholderName.class)) {
            String[] aliases;
            for (String alias : aliases = this.getClass().getAnnotation(PlaceholderName.class).aliases()) {
                if (alias.isEmpty()) continue;
                aliasesList.add(alias);
            }
        }
        return aliasesList;
    }

    @Override
    @Nullable
    public String getFormat() {
        return null;
    }
}

