/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.Replacer.MultiPartner;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.PlaceholderFormatted;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.PlaceholderName;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.Replacer.Formatted.PartnerNameFormatted;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.Replacer.PlaceholderReplacerBaseValue;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PlaceholderName(aliases={"Partner%d", "Partner_%d", "Partner_Name_%d"})
@PlaceholderFormatted(formattedClass=PartnerNameFormatted.class)
public class PartnerNameId
extends PlaceholderReplacerBaseValue {
    private final int id;
    private final String noPartnerForSlot;

    public PartnerNameId(@NotNull MarriageMaster plugin, int id) {
        super(plugin);
        this.id = id;
        this.noPartnerForSlot = this.getPlaceholderValue("NoPlaceholderForSlot");
    }

    @Override
    @Nullable
    protected String replaceMarried(MarriagePlayer player) {
        Collection partners = player.getPartners();
        MarriagePlayer partner = player;
        int i = 0;
        for (MarriagePlayer p : partners) {
            if (i == this.id) {
                partner = p;
                break;
            }
            ++i;
        }
        if (partner == null) {
            return this.noPartnerForSlot;
        }
        return partner.getName();
    }

    @Override
    @NotNull
    public String getName() {
        return "PartnerName" + this.id;
    }

    @Override
    @NotNull
    public Collection<String> getAliases() {
        Collection<String> aliasesCollection = super.getAliases();
        ArrayList<String> aliases = new ArrayList<String>(aliasesCollection.size());
        for (String alias : aliasesCollection) {
            aliases.add(String.format(alias, this.id));
        }
        return aliases;
    }
}

