/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.Hooks;

import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.Hooks.PlaceholderAPIHook;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Placeholder.PlaceholderManager;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class ClipsPlaceholderHook
extends PlaceholderExpansion
implements PlaceholderAPIHook {
    private final MarriageMaster plugin;
    private final PlaceholderManager placeholderManager;

    public ClipsPlaceholderHook(MarriageMaster plugin, PlaceholderManager placeholderManager) {
        this.plugin = plugin;
        this.placeholderManager = placeholderManager;
        if (this.register()) {
            this.plugin.getLogger().info(ConsoleColor.GREEN + "PlaceholderAPI hook was successfully registered!" + ConsoleColor.RESET);
        } else {
            this.plugin.getLogger().info(ConsoleColor.RED + "PlaceholderAPI hook failed to registered!" + ConsoleColor.RESET);
            this.plugin.getLogger().info("If you currently have the eCloud extension installed please remove it and try again!");
        }
    }

    public String onRequest(@NotNull OfflinePlayer player, @NotNull String identifier) {
        return this.placeholderManager.replacePlaceholder(player, identifier);
    }

    @Override
    public void close() {
        boolean result = false;
        try {
            result = (Boolean)PlaceholderAPI.class.getDeclaredMethod("unregisterExpansion", PlaceholderExpansion.class).invoke(null, this);
        }
        catch (NoSuchMethodException ignored) {
            try {
                result = (Boolean)PlaceholderExpansion.class.getDeclaredMethod("unregister", new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to unregister placeholder hook from PAPI!", e);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to unregister placeholder hook from PAPI!", e);
        }
        if (result) {
            this.plugin.getLogger().info(ConsoleColor.GREEN + "PlaceholderAPI hook was successfully unregistered!" + ConsoleColor.RESET);
        } else {
            this.plugin.getLogger().info(ConsoleColor.RED + "PlaceholderAPI hook failed to unregistered!" + ConsoleColor.RESET);
        }
    }

    @NotNull
    public String getName() {
        return this.plugin.getDescription().getName();
    }

    @NotNull
    public String getIdentifier() {
        return this.plugin.getDescription().getName().toLowerCase(Locale.ENGLISH);
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @NotNull
    public List<String> getPlaceholders() {
        return this.placeholderManager.getPlaceholdersList();
    }

    public boolean persist() {
        return true;
    }

    @Override
    public void testPlaceholders(@NotNull BufferedWriter writer) throws IOException {
        writer.append("\nPlaceholderAPI integration test:\n");
        PlaceholderHook hook = (PlaceholderHook)PlaceholderAPI.getPlaceholders().get(this.getIdentifier());
        if (hook == this) {
            writer.append("Success!\n\n");
        } else if (hook instanceof ClipsPlaceholderHook) {
            writer.append("Failed! marriagemaster placeholders are hooked to the right class, but the wrong instance!");
        } else {
            writer.append("Failed! marriagemaster_ placeholders are linked to: ").append(hook.getClass().getName());
        }
    }
}

