/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit;

import at.pcgamingfreaks.MarriageMaster.Bukkit.BadRabbit;
import at.pcgamingfreaks.MarriageMaster.MagicValues;
import at.pcgamingfreaks.Version;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MarriageMasterBadRabbit
extends BadRabbit {
    private boolean standalone = true;

    @Override
    public void onLoad() {
        Plugin pcgfPluginLib = Bukkit.getPluginManager().getPlugin("PCGF_PluginLib");
        if (pcgfPluginLib != null) {
            if (new Version(pcgfPluginLib.getDescription().getVersion()).olderThan(new Version(MagicValues.MIN_PCGF_PLUGIN_LIB_VERSION))) {
                this.getLogger().info("PCGF-PluginLib to old! Switching to standalone mode!");
            } else {
                this.getLogger().info("PCGF-PluginLib installed. Switching to normal mode!");
                this.standalone = false;
            }
        } else {
            this.getLogger().info("PCGF-PluginLib not installed. Switching to standalone mode!");
        }
        if (this.standalone) {
            this.loadIMessageClasses();
        }
        super.onLoad();
    }

    @Override
    @NotNull
    protected JavaPlugin createInstance() throws Exception {
        JavaPlugin newPluginInstance;
        if (this.standalone) {
            Class<?> standaloneClass = Class.forName("at.pcgamingfreaks.MarriageMasterStandalone.Bukkit.MarriageMaster");
            newPluginInstance = (JavaPlugin)standaloneClass.newInstance();
        } else {
            Class<?> standaloneClass = Class.forName("at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster");
            newPluginInstance = (JavaPlugin)standaloneClass.newInstance();
        }
        return newPluginInstance;
    }

    void loadIMessageClasses() {
        try {
            File tempJarFile = File.createTempFile("IMessage", ".jar");
            try {
                Class<?> utilsClass = Class.forName("at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Utils");
                Method extractMethod = utilsClass.getDeclaredMethod("extractFile", Class.class, Logger.class, String.class, File.class);
                extractMethod.invoke(null, ((Object)((Object)this)).getClass(), this.getLogger(), "IMessage.jar", tempJarFile);
                URLClassLoader loader = new URLClassLoader(new URL[]{tempJarFile.toURI().toURL()}, this.getClassLoader());
                Class<?> iMessage = loader.loadClass("at.pcgamingfreaks.Message.IMessage");
                Class<?> iMessageBukkit = loader.loadClass("at.pcgamingfreaks.Bukkit.Message.IMessage");
                Map classes = (Map)MarriageMasterBadRabbit.getField(this.getClassLoader().getClass(), "classes").get(this.getClassLoader());
                classes.put("at.pcgamingfreaks.Message.IMessage", iMessage);
                classes.put("at.pcgamingfreaks.Bukkit.Message.IMessage", iMessageBukkit);
                loader.close();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to load IMessage interfaces", e);
            }
            if (!tempJarFile.delete()) {
                this.getLogger().warning("Failed to delete temp file '" + tempJarFile.getAbsolutePath() + "'.");
                tempJarFile.deleteOnExit();
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Failed to load IMessage interfaces", e);
        }
    }
}

