/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Management.Requests;

import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Management.MarriageManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Placeholder.Placeholders;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class PriestDivorceAcceptRequest
extends AcceptPendingRequest {
    private static Message messageDivorcePlayerOff;
    private static Message messageDivorcePriestOff;
    private static Message messageDivorceDeny;
    private static Message messageDivorceYouDeny;
    private static Message messageDivorceConfirm;
    private static Message messageDivorcePlayerCancelled;
    private static Message messageDivorcePriestCancelled;
    private static Message messageDivorceYouCancelled;
    private static Message messageDivorceYouCancelledPriest;
    private final boolean first;
    private final Marriage marriage;
    private final MarriagePlayer partner;
    private final MarriagePlayer priest;
    private final MarriageManager manager;

    public static void loadMessages(MarriageMaster plugin) {
        messageDivorceDeny = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.Deny").placeholders(Placeholders.PLAYER_NAME);
        messageDivorceYouDeny = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.YouDeny").placeholders(Placeholders.PLAYER_NAME);
        messageDivorceConfirm = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Divorce.Confirm").placeholders(Placeholders.PRIEST_NAME)).placeholders(Placeholders.PARTNER_NAME);
        messageDivorcePlayerOff = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.PlayerOff").placeholders(Placeholders.PLAYER_NAME);
        messageDivorcePriestOff = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.PriestOff").placeholders(Placeholders.PLAYER_NAME);
        messageDivorcePriestCancelled = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Divorce.PriestCancelled").placeholders(Placeholders.PRIEST_NAME)).placeholders(Placeholders.PARTNER_NAME);
        messageDivorcePlayerCancelled = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Divorce.PlayerCancelled").placeholders(Placeholders.mkPlayerNameRegex("(Player)?"))).placeholders(Placeholders.PARTNER_NAME);
        messageDivorceYouCancelled = (Message)plugin.getLanguage().getMessage("Ingame.Divorce.YouCancelled").placeholders(Placeholders.PLAYER_NAME);
        messageDivorceYouCancelledPriest = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Divorce.YouCancelledPriest").placeholders(Placeholders.PLAYER1_NAME)).placeholders(Placeholders.PLAYER2_NAME);
    }

    public static void unLoadMessages() {
        messageDivorcePriestCancelled = null;
        messageDivorcePlayerCancelled = null;
        messageDivorceConfirm = null;
        messageDivorceYouDeny = null;
        messageDivorceDeny = null;
        messageDivorcePriestOff = null;
        messageDivorcePlayerOff = null;
        messageDivorceYouCancelledPriest = null;
        messageDivorceYouCancelled = null;
    }

    public PriestDivorceAcceptRequest(@NotNull MarriageManager manager, @NotNull MarriagePlayer hasToAccept, @NotNull MarriagePlayer priest, @NotNull Marriage marriage, boolean first) {
        MarriagePlayer[] marriagePlayerArray;
        if (((MarriagePlayer)marriage.getPartner(hasToAccept)).isOnline()) {
            MarriagePlayer[] marriagePlayerArray2 = new MarriagePlayer[2];
            marriagePlayerArray2[0] = (MarriagePlayer)marriage.getPartner(hasToAccept);
            marriagePlayerArray = marriagePlayerArray2;
            marriagePlayerArray2[1] = priest;
        } else {
            MarriagePlayer[] marriagePlayerArray3 = new MarriagePlayer[1];
            marriagePlayerArray = marriagePlayerArray3;
            marriagePlayerArray3[0] = priest;
        }
        super(hasToAccept, marriagePlayerArray);
        this.first = first;
        this.marriage = marriage;
        this.priest = priest;
        this.manager = manager;
        this.partner = (MarriagePlayer)marriage.getPartner(hasToAccept);
        hasToAccept.send(messageDivorceConfirm, priest, this.partner);
    }

    @Override
    protected void onAccept() {
        if (this.first) {
            MarriageMaster.getInstance().getCommandManager().registerAcceptPendingRequest(new PriestDivorceAcceptRequest(this.manager, this.partner, this.priest, this.marriage, false));
        } else {
            this.manager.priestFinishDivorce(this.marriage, (CommandSender)this.priest.getPlayerOnline());
        }
    }

    @Override
    protected void onDeny() {
        MarriagePlayer player = (MarriagePlayer)this.getPlayerThatHasToAccept();
        if (this.partner.isOnline()) {
            this.partner.send(messageDivorceDeny, player);
        }
        this.priest.send(messageDivorceDeny, player);
        player.send(messageDivorceYouDeny, this.partner);
    }

    @Override
    protected void onCancel(@NotNull MarriagePlayer player) {
        if (player.equals(this.priest)) {
            ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(messageDivorcePriestCancelled, player, this.partner);
            player.send(messageDivorceYouCancelledPriest, this.marriage.getPartner1(), this.marriage.getPartner2());
        } else {
            this.priest.send(messageDivorcePlayerCancelled, player, this.getPlayerThatHasToAccept());
            player.send(messageDivorceYouCancelled, this.partner);
        }
    }

    @Override
    protected void onDisconnect(@NotNull MarriagePlayer player) {
        if (player.equals(this.getPlayerThatHasToAccept())) {
            ((MarriagePlayer[])this.getPlayersThatCanCancel())[0].send(messageDivorcePlayerOff, player);
            ((MarriagePlayer[])this.getPlayersThatCanCancel())[1].send(messageDivorcePlayerOff, player);
        } else if (player.equals(((MarriagePlayer[])this.getPlayersThatCanCancel())[0])) {
            ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(messageDivorcePlayerOff, player);
            ((MarriagePlayer[])this.getPlayersThatCanCancel())[1].send(messageDivorcePlayerOff, player);
        } else {
            ((MarriagePlayer)this.getPlayerThatHasToAccept()).send(messageDivorcePriestOff, player);
            ((MarriagePlayer[])this.getPlayersThatCanCancel())[0].send(messageDivorcePriestOff, player);
        }
    }
}

