/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Management;

import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.Bukkit.Message.MessageBuilder;
import at.pcgamingfreaks.Bukkit.Message.Sender.SendMethod;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.DivorceEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.DivorcedEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarriedEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarryEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.SurnameChangeEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.SurnameChangedEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.MarriageData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.MarriagePlayerData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Management.Requests.PriestDivorceAcceptRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Management.Requests.PriestMarryAcceptRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Management.Requests.SelfDivorceAcceptRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Management.Requests.SelfMarryAcceptRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Range;
import at.pcgamingfreaks.MarriageMaster.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.MarriageMaster.Placeholder.Placeholders;
import at.pcgamingfreaks.MarriageMaster.Placeholder.Processors.DisplayNamePlaceholderProcessor;
import at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.Message.Placeholder.Placeholder;
import at.pcgamingfreaks.Message.Placeholder.Processors.FloatPlaceholderProcessor;
import at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import at.pcgamingfreaks.Message.Placeholder.Processors.ParameterTypeAwarePlaceholderProcessor;
import at.pcgamingfreaks.Message.Placeholder.Processors.PassthroughMessageComponentPlaceholderProcessor;
import java.util.Date;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarriageManager
implements at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriageManager {
    public static final String CONSOLE_NAME = "Console";
    public static final String CONSOLE_DISPLAY_NAME = MessageColor.GRAY + "Console";
    public static final String COLOR_CODE_REGEX = "&[a-fA-F0-9l-orL-OR]";
    public static final MessageComponent CONSOLE_DISPLAY_NAME_COMPONENT = ((MessageBuilder)new MessageBuilder().appendLegacy(CONSOLE_DISPLAY_NAME)).getAsComponent();
    private final MarriageMaster plugin;
    private final String surnameNotAllowedCharactersRex;
    private final String dialogDoYouWant;
    private final String dialogMarried;
    private final Message messageSurnameSuccess;
    private final Message messageSurnameFailed;
    private final Message messageSurnameToShort;
    private final Message messageSurnameToLong;
    private final Message messageSurnameAlreadyUsed;
    private final Message messageAlreadyMarried;
    private final Message messageNotWithHimself;
    private final Message messageSurnameNeeded;
    private final Message messageMarried;
    private final Message messageHasMarried;
    private final Message messageBroadcastMarriage;
    private final Message messageNotInRange;
    private final Message messageAlreadyOpenRequest;
    private final Message messageNotYourself;
    private final Message messageSelfNotInRange;
    private final Message messageSelfAlreadyMarried;
    private final Message messageSelfOtherAlreadyMarried;
    private final Message messageSelfAlreadyOpenRequest;
    private final Message messageSelfConfirm;
    private final Message messageSelfMarryRequestSent;
    private final Message messageAlreadySamePair;
    private final Message messageSelfAlreadySamePair;
    private final Message messageBroadcastDivorce;
    private final Message messageDivorced;
    private final Message messageDivorcedPlayer;
    private final Message messageDivorceNotInRange;
    private final Message messageSelfNotOnYourOwn;
    private final Message messageSelfDivorced;
    private final Message messageSelfBroadcastDivorce;
    private final Message messageSelfDivorcedPlayer;
    private final Message messageSelfDivorceRequestSent;
    private final Message messageSelfDivorceConfirm;
    private final Message messageSelfDivorceNotInRange;
    private final boolean surnameAllowColors;
    private final boolean confirm;
    private final boolean bothOnDivorce;
    private final boolean autoDialog;
    private final boolean otherPlayerOnSelfDivorce;
    private final int surnameMinLength;
    private final int surnameMaxLength;
    private final double rangeMarry;
    private final double rangeDivorce;
    private final double rangeMarrySquared;
    private final double rangeDivorceSquared;

    public MarriageManager(MarriageMaster plugin) {
        this.plugin = plugin;
        this.surnameAllowColors = plugin.getConfiguration().getSurnamesAllowColors();
        this.surnameNotAllowedCharactersRex = plugin.getConfiguration().getSurnamesAllowedCharacters().equalsIgnoreCase("all") ? null : "[^" + plugin.getConfiguration().getSurnamesAllowedCharacters() + "]";
        this.surnameMinLength = plugin.getConfiguration().getSurnamesMinLength();
        this.surnameMaxLength = plugin.getConfiguration().getSurnamesMaxLength();
        this.rangeMarry = plugin.getConfiguration().getRange(Range.Marry);
        this.rangeDivorce = plugin.getConfiguration().getRange(Range.Divorce);
        boolean announceMarriage = plugin.getConfiguration().isMarryAnnouncementEnabled();
        boolean announceDivorce = plugin.getConfiguration().isDivorceAnnouncementEnabled();
        this.confirm = plugin.getConfiguration().isMarryConfirmationEnabled();
        this.bothOnDivorce = plugin.getConfiguration().isConfirmationBothPlayersOnDivorceEnabled();
        this.autoDialog = plugin.getConfiguration().isMarryConfirmationAutoDialogEnabled();
        this.otherPlayerOnSelfDivorce = plugin.getConfiguration().isConfirmationOtherPlayerOnSelfDivorceEnabled();
        this.rangeMarrySquared = this.rangeMarry > 0.0 ? this.rangeMarry * this.rangeMarry : this.rangeMarry;
        this.rangeDivorceSquared = this.rangeDivorce > 0.0 ? this.rangeDivorce * this.rangeDivorce : this.rangeDivorce;
        this.dialogDoYouWant = plugin.getLanguage().getDialog("DoYouWant").replace("{Player1Name}", "%1$s").replace("{Player1DisplayName}", "%2$s").replace("{Player2Name}", "%3$s").replace("{Player2DisplayName}", "%4$s");
        this.dialogMarried = plugin.getLanguage().getDialog("Married").replace("{Player1Name}", "%1$s").replace("{Player1DisplayName}", "%2$s").replace("{Player2Name}", "%3$s").replace("{Player2DisplayName}", "%4$s");
        Placeholder rangePlaceholder = new Placeholder("Range", (IPlaceholderProcessor)new FloatPlaceholderProcessor(1));
        ParameterTypeAwarePlaceholderProcessor priestProcessor = new ParameterTypeAwarePlaceholderProcessor();
        priestProcessor.add(MarriagePlayer.class, (IPlaceholderProcessor)DisplayNamePlaceholderProcessor.INSTANCE);
        priestProcessor.add(MarriagePlayerData.class, (IPlaceholderProcessor)DisplayNamePlaceholderProcessor.INSTANCE);
        priestProcessor.add(MarriagePlayerDataBase.class, (IPlaceholderProcessor)DisplayNamePlaceholderProcessor.INSTANCE);
        priestProcessor.add(MessageComponent.class, (IPlaceholderProcessor)PassthroughMessageComponentPlaceholderProcessor.INSTANCE);
        Placeholder[] priestPlaceholders = new Placeholder[]{new Placeholder("PriestName", null, -1), new Placeholder("PriestDisplayName", (IPlaceholderProcessor)priestProcessor, -1)};
        this.messageSurnameSuccess = this.getMSG("Ingame.Surname.SetSuccessful");
        this.messageSurnameFailed = this.getMSG("Ingame.Surname.SetFailed");
        this.messageSurnameToShort = (Message)((Message)this.getMSG("Ingame.Surname.ToShort").replaceAll("\\{MinLength}", this.surnameMinLength + "")).replaceAll("\\{MaxLength}", this.surnameMaxLength + "");
        this.messageSurnameToLong = (Message)((Message)this.getMSG("Ingame.Surname.ToLong").replaceAll("\\{MinLength}", this.surnameMinLength + "")).replaceAll("\\{MaxLength}", this.surnameMaxLength + "");
        this.messageSurnameAlreadyUsed = this.getMSG("Ingame.Surname.AlreadyUsed");
        this.messageAlreadySamePair = (Message)((Message)this.getMSG("Ingame.Marry.AlreadySamePair").placeholders(Placeholders.PLAYER1_NAME)).placeholders(Placeholders.PLAYER2_NAME);
        this.messageAlreadyMarried = (Message)this.getMSG("Ingame.Marry.AlreadyMarried").placeholders(Placeholders.PLAYER_NAME);
        this.messageNotWithHimself = (Message)this.getMSG("Ingame.Marry.NotWithHimself").placeholders(Placeholders.PLAYER_NAME);
        this.messageSurnameNeeded = this.getMSG("Ingame.Marry.SurnameNeeded");
        this.messageMarried = (Message)((Message)this.getMSG("Ingame.Marry.Married").placeholders(Placeholders.PLAYER1_NAME)).placeholders(Placeholders.PLAYER2_NAME);
        this.messageHasMarried = (Message)((Message)this.getMSG("Ingame.Marry.HasMarried").placeholders(priestPlaceholders)).placeholders(Placeholders.PARTNER_NAME);
        this.messageBroadcastMarriage = (Message)((Message)((Message)this.getMSG("Ingame.Marry.Broadcast").placeholders(priestPlaceholders)).placeholders(Placeholders.PLAYER1_NAME)).placeholders(Placeholders.PLAYER2_NAME);
        if (!announceMarriage) {
            this.messageBroadcastMarriage.setSendMethod(SendMethod.DISABLED);
        }
        this.messageNotInRange = (Message)this.getMSG("Ingame.Marry.NotInRange").placeholders(new Placeholder[]{rangePlaceholder});
        this.messageAlreadyOpenRequest = (Message)this.getMSG("Ingame.Marry.AlreadyOpenRequest").placeholders(Placeholders.PLAYER_NAME);
        this.messageSelfConfirm = (Message)this.getMSG("Ingame.Marry.Self.Confirm").placeholders(Placeholders.PLAYER_NAME);
        this.messageNotYourself = this.getMSG("Ingame.Marry.Self.NotYourself");
        this.messageSelfNotInRange = (Message)this.getMSG("Ingame.Marry.Self.NotInRange").placeholders(new Placeholder[]{rangePlaceholder});
        this.messageSelfAlreadySamePair = (Message)this.getMSG("Ingame.Marry.Self.AlreadySamePair").placeholders(Placeholders.mkPlayerNameRegex("(Partner)?"));
        this.messageSelfAlreadyMarried = (Message)this.getMSG("Ingame.Marry.Self.AlreadyMarried").placeholders(Placeholders.PLAYER_NAME);
        this.messageSelfMarryRequestSent = this.getMSG("Ingame.Marry.Self.RequestSent");
        this.messageSelfOtherAlreadyMarried = (Message)this.getMSG("Ingame.Marry.Self.OtherAlreadyMarried").placeholders(Placeholders.PLAYER_NAME);
        this.messageSelfAlreadyOpenRequest = this.getMSG("Ingame.Marry.Self.AlreadyOpenRequest");
        this.messageSelfNotOnYourOwn = this.getMSG("Ingame.Marry.Self.NotOnYourOwn");
        this.messageDivorced = (Message)((Message)this.getMSG("Ingame.Divorce.Divorced").placeholders(Placeholders.PLAYER1_NAME)).placeholders(Placeholders.PLAYER2_NAME);
        this.messageDivorcedPlayer = (Message)((Message)this.getMSG("Ingame.Divorce.DivorcedPlayer").placeholders(priestPlaceholders)).placeholders(Placeholders.PARTNER_NAME);
        this.messageBroadcastDivorce = (Message)((Message)((Message)this.getMSG("Ingame.Divorce.Broadcast").placeholders(priestPlaceholders)).placeholders(Placeholders.PLAYER1_NAME)).placeholders(Placeholders.PLAYER2_NAME);
        if (!announceDivorce) {
            this.messageBroadcastDivorce.setSendMethod(SendMethod.DISABLED);
        }
        this.messageDivorceNotInRange = (Message)this.getMSG("Ingame.Divorce.NotInRange").placeholders(new Placeholder[]{rangePlaceholder});
        this.messageSelfDivorced = (Message)this.getMSG("Ingame.Divorce.Self.Divorced").placeholders(Placeholders.PLAYER_NAME);
        this.messageSelfDivorceConfirm = (Message)this.getMSG("Ingame.Divorce.Self.Confirm").placeholders(Placeholders.PLAYER_NAME);
        this.messageSelfDivorcedPlayer = (Message)this.getMSG("Ingame.Divorce.Self.DivorcedPlayer").placeholders(Placeholders.PLAYER_NAME);
        this.messageSelfBroadcastDivorce = (Message)((Message)this.getMSG("Ingame.Divorce.Self.Broadcast").placeholders(Placeholders.PLAYER1_NAME)).placeholders(Placeholders.PLAYER2_NAME);
        if (!announceDivorce) {
            this.messageSelfBroadcastDivorce.setSendMethod(SendMethod.DISABLED);
        }
        this.messageSelfDivorceRequestSent = (Message)this.getMSG("Ingame.Divorce.Self.RequestSent").placeholders(Placeholders.PLAYER_NAME);
        this.messageSelfDivorceNotInRange = (Message)this.getMSG("Ingame.Divorce.Self.NotInRange").placeholders(new Placeholder[]{rangePlaceholder});
        SelfMarryAcceptRequest.loadMessages(plugin);
        PriestMarryAcceptRequest.loadMessages(plugin);
        SelfDivorceAcceptRequest.loadMessages(plugin);
        PriestDivorceAcceptRequest.loadMessages(plugin);
    }

    public void close() {
        SelfMarryAcceptRequest.unLoadMessages();
        PriestMarryAcceptRequest.unLoadMessages();
        SelfDivorceAcceptRequest.unLoadMessages();
        PriestDivorceAcceptRequest.unLoadMessages();
    }

    private Message getMSG(String path) {
        return this.plugin.getLanguage().getMessage(path);
    }

    public boolean isAutoDialogEnabled() {
        return this.autoDialog;
    }

    public boolean isConfirmEnabled() {
        return this.confirm;
    }

    @Override
    public String cleanupSurname(String surname) {
        String surnameCleaned;
        String s;
        if (surname == null || surname.isEmpty()) {
            return null;
        }
        if (this.plugin.getCommandManager().isRemoveSwitch(surname) || "null".equalsIgnoreCase(surname) || "none".equalsIgnoreCase(surname)) {
            return null;
        }
        surname = surname.replace('\u00a7', '&').replace("&k", "");
        if (this.surnameNotAllowedCharactersRex != null && !(s = surname.replaceAll(COLOR_CODE_REGEX, "")).equals(surnameCleaned = s.replaceAll(this.surnameNotAllowedCharactersRex, ""))) {
            surname = surnameCleaned;
        }
        return this.surnameAllowColors ? MessageColor.translateAlternateColorCodes((char)'&', (String)surname) : surname;
    }

    @Override
    public boolean isSurnameAvailable(@NotNull String surname) {
        return !this.plugin.getDatabase().getSurnames().contains(surname);
    }

    @Override
    public boolean isSurnameValid(@NotNull String surname) {
        return this.isSurnameLengthValid(surname = this.cleanupSurname(surname)) && this.isSurnameAvailable(surname);
    }

    @Override
    public boolean isSurnameLengthValid(@NotNull String surname) {
        return surname.length() >= this.surnameMinLength && surname.length() <= this.surnameMaxLength;
    }

    @Override
    public void setSurname(@NotNull Marriage marriage, String surname) {
        this.setSurname(marriage, surname, (CommandSender)Bukkit.getConsoleSender());
    }

    @Override
    public void setSurname(@NotNull Marriage marriage, String surname, @NotNull CommandSender changer) {
        if ((surname = this.cleanupSurname(surname)) == null && this.plugin.isSurnamesForced()) {
            this.messageSurnameFailed.send(changer, new Object[0]);
        } else if (surname == null || surname.length() >= this.surnameMinLength) {
            if (surname == null || surname.length() <= this.surnameMaxLength) {
                if (surname == null || this.isSurnameAvailable(surname)) {
                    SurnameChangeEvent event = new SurnameChangeEvent(marriage, surname, changer);
                    this.plugin.getServer().getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        surname = event.getNewSurname();
                        if (marriage.setSurname(surname)) {
                            this.messageSurnameSuccess.send(changer, new Object[0]);
                            this.plugin.getServer().getPluginManager().callEvent((Event)new SurnameChangedEvent(marriage, surname, changer));
                        } else {
                            this.messageSurnameFailed.send(changer, new Object[0]);
                        }
                    } else {
                        this.messageSurnameAlreadyUsed.send(changer, new Object[0]);
                    }
                }
            } else {
                this.messageSurnameToLong.send(changer, new Object[0]);
            }
        } else {
            this.messageSurnameToShort.send(changer, new Object[0]);
        }
    }

    @Override
    public void marry(@NotNull Player player1, @NotNull Player player2) {
        this.marry(this.plugin.getPlayerData((OfflinePlayer)player1), this.plugin.getPlayerData((OfflinePlayer)player2), (String)null);
    }

    @Override
    public void marry(@NotNull Player player1, @NotNull Player player2, @NotNull CommandSender priest) {
        this.marry(this.plugin.getPlayerData((OfflinePlayer)player1), this.plugin.getPlayerData((OfflinePlayer)player2), priest, (String)null);
    }

    @Override
    public void marry(@NotNull Player player1, @NotNull Player player2, String surname) {
        this.marry(this.plugin.getPlayerData((OfflinePlayer)player1), this.plugin.getPlayerData((OfflinePlayer)player2), surname);
    }

    @Override
    public void marry(@NotNull Player player1, @NotNull Player player2, @NotNull CommandSender priest, String surname) {
        this.marry(this.plugin.getPlayerData((OfflinePlayer)player1), this.plugin.getPlayerData((OfflinePlayer)player2), priest, surname);
    }

    @Override
    public void marry(@NotNull MarriagePlayer player1, @NotNull MarriagePlayer player2) {
        this.marry(player1, player2, (String)null);
    }

    @Override
    public void marry(@NotNull MarriagePlayer player1, @NotNull MarriagePlayer player2, @NotNull CommandSender priest) {
        this.marry(player1, player2, priest, (String)null);
    }

    @Override
    public void marry(@NotNull MarriagePlayer player1, @NotNull MarriagePlayer player2, @NotNull MarriagePlayer priest) {
        this.marry(player1, player2, priest, (String)null);
    }

    @Override
    public void marry(@NotNull MarriagePlayer player1, @NotNull MarriagePlayer player2, String surname) {
        this.marry(player1, player2, player1, surname);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean marrySurnameTest(@NotNull CommandSender priest, @Nullable String surname) {
        if (this.plugin.isSurnamesEnabled() && surname != null && !surname.isEmpty()) {
            if (surname.length() >= this.surnameMinLength) {
                if (surname.length() <= this.surnameMaxLength) {
                    if (this.isSurnameAvailable(surname)) return true;
                    this.messageSurnameAlreadyUsed.send(priest, new Object[0]);
                    return false;
                }
                this.messageSurnameToLong.send(priest, new Object[0]);
                return false;
            }
            this.messageSurnameToShort.send(priest, new Object[0]);
            return false;
        }
        if (!this.plugin.isSurnamesForced() || surname != null && !surname.isEmpty()) return true;
        this.messageSurnameNeeded.send(priest, new Object[0]);
        return false;
    }

    private boolean marryOnlineTest(@NotNull CommandSender priest, @NotNull OfflinePlayer player1, @NotNull OfflinePlayer player2) {
        if (!player1.isOnline()) {
            CommonMessages.getMessagePlayerNotOnline().send(priest, new Object[]{player1.getName()});
        } else if (!player2.isOnline()) {
            CommonMessages.getMessagePlayerNotOnline().send(priest, new Object[]{player2.getName()});
        } else {
            return true;
        }
        return false;
    }

    private boolean marryPriestTestCanMarry(MarriagePlayer player1, MarriagePlayer player2, CommandSender priest) {
        if (player1.equals(player2)) {
            this.messageNotWithHimself.send(priest, new Object[]{player1});
        } else if (player1.getPartners().contains(player2)) {
            this.messageAlreadySamePair.send(priest, new Object[]{player1, player2});
        } else if (!this.plugin.areMultiplePartnersAllowed() && (player1.isMarried() || player2.isMarried())) {
            if (player1.isMarried()) {
                this.messageAlreadyMarried.send(priest, new Object[]{player1});
            }
            if (player2.isMarried()) {
                this.messageAlreadyMarried.send(priest, new Object[]{player2});
            }
        } else {
            return true;
        }
        return false;
    }

    public void marryPriestFinish(MarriagePlayer player1, MarriagePlayer player2, CommandSender priest, String surname) {
        surname = this.cleanupSurname(surname);
        MarryEvent event = new MarryEvent(player1, player2, priest, surname);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            Object priestNameProvider;
            MarriageData marriage;
            String priestName;
            if (priest instanceof Player) {
                priestName = priest.getName();
                marriage = new MarriageData(player1, player2, this.plugin.getPlayerData((OfflinePlayer)((Player)priest)), new Date(), surname);
                if (this.confirm && this.autoDialog) {
                    String msg = String.format(this.dialogMarried, player1.getName(), player1.getDisplayName(), player2.getName(), player2.getDisplayName());
                    ((Player)priest).chat(msg);
                }
                priestNameProvider = this.plugin.getPlayerData((OfflinePlayer)((Player)priest));
            } else {
                priestName = CONSOLE_NAME;
                marriage = new MarriageData(player1, player2, null, surname);
                priestNameProvider = CONSOLE_DISPLAY_NAME_COMPONENT;
            }
            this.plugin.getDatabase().cachedMarry(marriage);
            this.messageMarried.send(priest, new Object[]{player1, player2});
            player1.sendMessage(this.messageHasMarried, priestName, priestNameProvider, player2);
            player2.sendMessage(this.messageHasMarried, priestName, priestNameProvider, player1);
            this.messageBroadcastMarriage.broadcast(new Object[]{priestName, priestNameProvider, player1, player2});
            this.plugin.getServer().getPluginManager().callEvent((Event)new MarriedEvent(marriage));
        }
    }

    @Override
    public void marry(@NotNull MarriagePlayer player1, @NotNull MarriagePlayer player2, @NotNull CommandSender priest, String surname) {
        if (priest instanceof Player) {
            this.marry(player1, player2, this.plugin.getPlayerData((OfflinePlayer)((Player)priest)), surname);
        } else if (this.marryOnlineTest(priest, (OfflinePlayer)player1.getPlayer(), (OfflinePlayer)player2.getPlayer()) && this.marryPriestTestCanMarry(player1, player2, priest) && this.marrySurnameTest(priest, surname)) {
            this.marryPriestFinish(player1, player2, priest, surname);
        }
    }

    @Override
    public void marry(@NotNull MarriagePlayer player1, @NotNull MarriagePlayer player2, @NotNull MarriagePlayer priest, String surname) {
        if (priest.isOnline() && this.marryOnlineTest((CommandSender)priest.getPlayerOnline(), (OfflinePlayer)player1.getPlayer(), (OfflinePlayer)player2.getPlayer()) && this.marrySurnameTest((CommandSender)priest.getPlayerOnline(), surname)) {
            if (player1.equals(priest) || player2.equals(priest)) {
                if (this.plugin.isSelfMarriageAllowed() && priest.hasPermission("marry.selfmarry")) {
                    MarriagePlayer otherPlayer;
                    MarriagePlayer marriagePlayer = otherPlayer = player1.equals(priest) ? player2 : player1;
                    if (player1.equals(player2)) {
                        priest.send(this.messageNotYourself, new Object[0]);
                    } else if (!this.plugin.isInRangeSquared(player1, player2, this.rangeMarrySquared)) {
                        priest.send(this.messageSelfNotInRange, this.rangeMarry);
                    } else if (priest.getPartners().contains(otherPlayer)) {
                        priest.send(this.messageSelfAlreadySamePair, otherPlayer);
                    } else if (!this.plugin.areMultiplePartnersAllowed() && (player1.isMarried() || player2.isMarried())) {
                        if (priest.isMarried()) {
                            priest.send(this.messageSelfAlreadyMarried, priest.getPartner());
                        } else if (otherPlayer.isMarried()) {
                            priest.send(this.messageSelfOtherAlreadyMarried, otherPlayer);
                        }
                    } else if (priest.getOpenRequest() != null || !priest.getRequestsToCancel().isEmpty()) {
                        priest.send(this.messageSelfAlreadyOpenRequest, new Object[0]);
                    } else if (otherPlayer.getOpenRequest() != null || !otherPlayer.getRequestsToCancel().isEmpty()) {
                        priest.send(this.messageAlreadyOpenRequest, otherPlayer);
                    } else {
                        otherPlayer.send(this.messageSelfConfirm, priest);
                        priest.send(this.messageSelfMarryRequestSent, new Object[0]);
                        this.plugin.getCommandManager().registerAcceptPendingRequest(new SelfMarryAcceptRequest(this, otherPlayer, priest, surname));
                    }
                } else {
                    priest.send(this.messageSelfNotOnYourOwn, new Object[0]);
                }
            } else if (priest.isPriest()) {
                Player bPriest = (Player)priest.getPlayerOnline();
                if (this.marryPriestTestCanMarry(player1, player2, (CommandSender)bPriest)) {
                    if (priest.hasPermission("marry.bypass.rangelimit") || this.plugin.isInRangeSquared(player1, player2, this.rangeMarrySquared) && this.plugin.isInRangeSquared(priest, player1, this.rangeMarrySquared) && this.plugin.isInRangeSquared(priest, player2, this.rangeMarrySquared)) {
                        if (!this.confirm) {
                            this.marryPriestFinish(player1, player2, (CommandSender)bPriest, surname);
                        } else if (player1.getOpenRequest() != null || !player1.getRequestsToCancel().isEmpty()) {
                            priest.send(this.messageAlreadyOpenRequest, player1);
                        } else if (player2.getOpenRequest() != null || !player2.getRequestsToCancel().isEmpty()) {
                            priest.send(this.messageAlreadyOpenRequest, player2);
                        } else {
                            if (this.autoDialog) {
                                bPriest.chat(String.format(this.dialogDoYouWant, player1.getName(), player1.getDisplayName(), player2.getName(), player2.getDisplayName()));
                            }
                            this.plugin.getCommandManager().registerAcceptPendingRequest(new PriestMarryAcceptRequest(this, player1, player2, priest, surname, true));
                        }
                    } else {
                        priest.send(this.messageNotInRange, this.rangeMarry);
                    }
                }
            } else {
                priest.send(CommonMessages.getMessageNoPermission(), new Object[0]);
            }
        }
    }

    public void priestFinishDivorce(@NotNull Marriage marriage, @NotNull CommandSender divorceBy) {
        DivorceEvent divorceEvent = new DivorceEvent(marriage, divorceBy);
        Bukkit.getPluginManager().callEvent((Event)divorceEvent);
        if (!divorceEvent.isCancelled()) {
            Object priestNameProvider;
            String priestName;
            marriage.divorce();
            MarriagePlayer player1 = (MarriagePlayer)marriage.getPartner1();
            MarriagePlayer player2 = (MarriagePlayer)marriage.getPartner2();
            if (divorceBy instanceof Player) {
                priestName = divorceBy.getName();
                priestNameProvider = this.plugin.getPlayerData((OfflinePlayer)((Player)divorceBy));
            } else {
                priestName = CONSOLE_NAME;
                priestNameProvider = CONSOLE_DISPLAY_NAME_COMPONENT;
            }
            this.messageBroadcastDivorce.broadcast(new Object[]{priestName, priestNameProvider, player1, player2});
            this.messageDivorced.send(divorceBy, new Object[]{player1, player2});
            if (player1.isOnline()) {
                player1.send(this.messageDivorcedPlayer, priestName, priestNameProvider, player2);
            }
            if (player2.isOnline()) {
                player2.send(this.messageDivorcedPlayer, priestName, priestNameProvider, player1);
            }
            this.plugin.getServer().getPluginManager().callEvent((Event)new DivorcedEvent((MarriagePlayer)marriage.getPartner1(), (MarriagePlayer)marriage.getPartner2(), divorceBy));
        }
    }

    public void selfFinishDivorce(@NotNull Marriage marriage, @NotNull MarriagePlayer divorceBy) {
        DivorceEvent divorceEvent = new DivorceEvent(marriage, (CommandSender)divorceBy.getPlayerOnline());
        Bukkit.getPluginManager().callEvent((Event)divorceEvent);
        if (!divorceEvent.isCancelled()) {
            MarriagePlayer otherPlayer = (MarriagePlayer)marriage.getPartner(divorceBy);
            marriage.divorce();
            divorceBy.send(this.messageSelfDivorced, otherPlayer);
            if (otherPlayer.isOnline()) {
                otherPlayer.send(this.messageSelfDivorcedPlayer, divorceBy);
            }
            this.messageSelfBroadcastDivorce.broadcast(new Object[]{divorceBy, otherPlayer});
            this.plugin.getServer().getPluginManager().callEvent((Event)new DivorcedEvent((MarriagePlayer)marriage.getPartner1(), (MarriagePlayer)marriage.getPartner2()));
        }
    }

    @Override
    public void divorce(@NotNull Marriage marriage) {
        this.divorce(marriage, (CommandSender)Bukkit.getConsoleSender());
    }

    @Override
    public void divorce(@NotNull Marriage marriage, @NotNull CommandSender divorceBy) {
        if (divorceBy instanceof Player) {
            this.divorce(marriage, this.plugin.getPlayerData((OfflinePlayer)((Player)divorceBy)));
        } else {
            this.priestFinishDivorce(marriage, divorceBy);
        }
    }

    @Override
    public void divorce(@NotNull Marriage marriage, @NotNull MarriagePlayer divorceBy) {
        if (!divorceBy.isOnline()) {
            return;
        }
        if (marriage.hasPlayer(divorceBy)) {
            if (this.plugin.isSelfDivorceAllowed() && divorceBy.hasPermission("marry.selfdivorce")) {
                MarriagePlayer otherPlayer = (MarriagePlayer)marriage.getPartner(divorceBy);
                if (!otherPlayer.isOnline()) {
                    if (divorceBy.hasPermission("marry.offlinedivorce")) {
                        this.selfFinishDivorce(marriage, divorceBy);
                    } else {
                        divorceBy.send(CommonMessages.getMessagePartnerOffline(), new Object[0]);
                    }
                } else if (this.plugin.isInRangeSquared(divorceBy, otherPlayer, this.rangeDivorceSquared)) {
                    if (this.otherPlayerOnSelfDivorce) {
                        if (((MarriagePlayer)marriage.getPartner1()).getOpenRequest() != null || ((MarriagePlayer)marriage.getPartner2()).getOpenRequest() != null) {
                            if (((MarriagePlayer)marriage.getPartner1()).getOpenRequest() != null) {
                                divorceBy.send(this.messageAlreadyOpenRequest, marriage.getPartner1());
                            }
                            if (((MarriagePlayer)marriage.getPartner2()).getOpenRequest() != null) {
                                divorceBy.send(this.messageAlreadyOpenRequest, marriage.getPartner2());
                            }
                        } else {
                            otherPlayer.send(this.messageSelfDivorceConfirm, divorceBy);
                            divorceBy.send(this.messageSelfDivorceRequestSent, otherPlayer);
                            this.plugin.getCommandManager().registerAcceptPendingRequest(new SelfDivorceAcceptRequest(this, otherPlayer, divorceBy, marriage));
                        }
                    } else {
                        this.selfFinishDivorce(marriage, divorceBy);
                    }
                } else {
                    divorceBy.send(this.messageSelfDivorceNotInRange, this.rangeDivorce);
                }
            } else {
                divorceBy.send(CommonMessages.getMessageNoPermission(), new Object[0]);
            }
        } else {
            this.divorce(marriage, divorceBy, (MarriagePlayer)marriage.getPartner1());
        }
    }

    @Override
    public void divorce(@NotNull Marriage marriage, @NotNull MarriagePlayer divorceBy, @NotNull MarriagePlayer first) {
        if (!divorceBy.isOnline() || !marriage.hasPlayer(first)) {
            return;
        }
        if (marriage.hasPlayer(divorceBy)) {
            this.divorce(marriage, divorceBy);
        } else if (divorceBy.isPriest()) {
            if (marriage.isBothOnline()) {
                if (divorceBy.hasPermission("marry.bypass.rangelimit") || this.plugin.isInRange(divorceBy, (MarriagePlayer)marriage.getPartner1(), this.rangeDivorce) && this.plugin.isInRange(divorceBy, (MarriagePlayer)marriage.getPartner2(), this.rangeDivorce)) {
                    if (this.confirm) {
                        if (((MarriagePlayer)marriage.getPartner1()).getOpenRequest() != null || ((MarriagePlayer)marriage.getPartner2()).getOpenRequest() != null) {
                            if (((MarriagePlayer)marriage.getPartner1()).getOpenRequest() != null) {
                                divorceBy.send(this.messageAlreadyOpenRequest, marriage.getPartner1());
                            }
                            if (((MarriagePlayer)marriage.getPartner2()).getOpenRequest() != null) {
                                divorceBy.send(this.messageAlreadyOpenRequest, marriage.getPartner2());
                            }
                        } else {
                            this.plugin.getCommandManager().registerAcceptPendingRequest(new PriestDivorceAcceptRequest(this, first, divorceBy, marriage, this.bothOnDivorce));
                        }
                    } else {
                        this.priestFinishDivorce(marriage, (CommandSender)divorceBy.getPlayerOnline());
                    }
                } else {
                    divorceBy.send(this.messageDivorceNotInRange, this.rangeDivorce);
                }
            } else if (divorceBy.hasPermission("marry.offlinedivorce")) {
                if (!((MarriagePlayer)marriage.getPartner1()).isOnline() && !((MarriagePlayer)marriage.getPartner2()).isOnline()) {
                    if (this.confirm) {
                        this.marryOnlineTest((CommandSender)divorceBy.getPlayerOnline(), (OfflinePlayer)((MarriagePlayer)marriage.getPartner1()).getPlayer(), (OfflinePlayer)((MarriagePlayer)marriage.getPartner2()).getPlayer());
                    } else {
                        this.priestFinishDivorce(marriage, (CommandSender)divorceBy.getPlayerOnline());
                    }
                } else if (first.isOnline()) {
                    if (this.confirm) {
                        if (((MarriagePlayer)marriage.getPartner1()).getOpenRequest() != null || ((MarriagePlayer)marriage.getPartner2()).getOpenRequest() != null) {
                            if (((MarriagePlayer)marriage.getPartner1()).getOpenRequest() != null) {
                                divorceBy.send(this.messageAlreadyOpenRequest, marriage.getPartner1());
                            }
                            if (((MarriagePlayer)marriage.getPartner2()).getOpenRequest() != null) {
                                divorceBy.send(this.messageAlreadyOpenRequest, marriage.getPartner2());
                            }
                        } else {
                            this.plugin.getCommandManager().registerAcceptPendingRequest(new PriestDivorceAcceptRequest(this, first, divorceBy, marriage, false));
                        }
                    } else {
                        this.priestFinishDivorce(marriage, (CommandSender)divorceBy.getPlayerOnline());
                    }
                } else {
                    divorceBy.send(CommonMessages.getMessagePlayerNotOnline(), ((MarriagePlayer)marriage.getPartner(first)).getName());
                }
            } else {
                this.marryOnlineTest((CommandSender)divorceBy.getPlayerOnline(), (OfflinePlayer)((MarriagePlayer)marriage.getPartner1()).getPlayer(), (OfflinePlayer)((MarriagePlayer)marriage.getPartner2()).getPlayer());
            }
        } else {
            divorceBy.send(CommonMessages.getMessageNoPermission(), new Object[0]);
        }
    }
}

