/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Listener;

import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.DivorceEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.GiftEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.HomeSetEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.HomeTPEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarryEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.SurnameChangeEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.TPEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.Message.Placeholder.Placeholder;
import at.pcgamingfreaks.Message.Placeholder.Processors.FloatPlaceholderProcessor;
import at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyHandler
implements Listener {
    private final MarriageMaster plugin;
    private double costMarry;
    private double costDivorce;
    private double costTp;
    private double costHome;
    private double costSetHome;
    private double costGift;
    private double costChangeSurname;
    private Message messageNotEnough;
    private Message messagePartnerNotEnough;
    private Message messageMarriagePaid;
    private Message messageDivorcePaid;
    private Message messagePriestMarryNotEnough;
    private Message messagePriestDivorceNotEnough;
    private Message messageTpPaid;
    private Message messageSetHomePaid;
    private Message messageHomePaid;
    private Message messageGiftPaid;
    private Message messageSurnameChangePaid;
    private Economy econ = null;

    public EconomyHandler(MarriageMaster plugin) {
        this.plugin = plugin;
        if (!this.setupEconomy(plugin)) {
            plugin.getLogger().info(ConsoleColor.RED + "Failed to connect with Vault's economy provider. Disable economy." + ConsoleColor.RESET);
            return;
        }
        this.costMarry = plugin.getConfiguration().getEconomyValue("Marry") / 2.0;
        this.costDivorce = plugin.getConfiguration().getEconomyValue("Divorce") / 2.0;
        this.costTp = plugin.getConfiguration().getEconomyValue("Tp");
        this.costGift = plugin.getConfiguration().getEconomyValue("Gift");
        this.costHome = plugin.getConfiguration().getEconomyValue("HomeTp");
        this.costSetHome = plugin.getConfiguration().getEconomyValue("SetHome");
        this.costChangeSurname = plugin.getConfiguration().getEconomyValue("ChangeSurname");
        int digits = this.econ.fractionalDigits();
        FloatPlaceholderProcessor floatPlaceholderProcessor = new FloatPlaceholderProcessor(digits < 0 ? 2 : digits);
        Placeholder[] ecoPlaceholders = new Placeholder[]{new Placeholder("Cost", (IPlaceholderProcessor)floatPlaceholderProcessor, -1), new Placeholder("Remaining", (IPlaceholderProcessor)floatPlaceholderProcessor, -1), new Placeholder("CurrencyName", -1)};
        this.messageNotEnough = (Message)this.getMessage(plugin, "NotEnough").placeholders(ecoPlaceholders);
        this.messagePartnerNotEnough = this.getMessage(plugin, "PartnerNotEnough");
        this.messagePriestMarryNotEnough = this.getMessage(plugin, "PriestMarryNotEnough");
        this.messagePriestDivorceNotEnough = this.getMessage(plugin, "PriestDivorceNotEnough");
        this.messageMarriagePaid = (Message)this.getMessage(plugin, "MarriagePaid").placeholders(ecoPlaceholders);
        this.messageDivorcePaid = (Message)this.getMessage(plugin, "DivorcePaid").placeholders(ecoPlaceholders);
        this.messageTpPaid = (Message)this.getMessage(plugin, "TpPaid").placeholders(ecoPlaceholders);
        this.messageHomePaid = (Message)this.getMessage(plugin, "HomeTPPaid").placeholders(ecoPlaceholders);
        this.messageSetHomePaid = (Message)this.getMessage(plugin, "SetHomePaid").placeholders(ecoPlaceholders);
        this.messageGiftPaid = (Message)this.getMessage(plugin, "GiftPaid").placeholders(ecoPlaceholders);
        this.messageSurnameChangePaid = (Message)this.getMessage(plugin, "SurnameChangePaid").placeholders(ecoPlaceholders);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private Message getMessage(MarriageMaster plugin, String key) {
        return plugin.getLanguage().getMessage("Ingame.Economy." + key);
    }

    private boolean setupEconomy(MarriageMaster plugin) {
        if (plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider economyProvider = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        this.econ = economyProvider != null ? (Economy)economyProvider.getProvider() : null;
        return this.econ != null;
    }

    private boolean hasPlayerEnoughMoney(MarriagePlayer player, double cost) {
        return this.econ.has((OfflinePlayer)player.getPlayer(), cost);
    }

    private boolean billPlayer(MarriagePlayer player, double cost) {
        return this.econ.withdrawPlayer((OfflinePlayer)player.getPlayer(), cost).transactionSuccess();
    }

    private boolean basicBillPlayer(MarriagePlayer player, double cost, Message successMessage) {
        if (this.hasPlayerEnoughMoney(player, cost) && this.billPlayer(player, cost)) {
            if (player.isOnline()) {
                player.send(successMessage, cost, this.econ.getBalance((OfflinePlayer)player.getPlayer()), this.econ.currencyNamePlural());
            }
            return true;
        }
        if (player.isOnline()) {
            player.send(this.messageNotEnough, cost, this.econ.getBalance((OfflinePlayer)player.getPlayer()), this.econ.currencyNamePlural());
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMarry(MarryEvent event) {
        if (this.costMarry <= 0.0) {
            return;
        }
        if (!this.billMarryOrDivorce(event.getPlayer1(), event.getPlayer2(), event.getPriestIfNotOneOfTheCouple(), this.costMarry, this.messageMarriagePaid, this.messagePriestMarryNotEnough)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDivorce(DivorceEvent event) {
        if (this.costDivorce <= 0.0) {
            return;
        }
        if (!this.billMarryOrDivorce((MarriagePlayer)event.getMarriageData().getPartner1(), (MarriagePlayer)event.getMarriageData().getPartner2(), event.getPriestIfNotOneOfTheCouple(), this.costDivorce, this.messageDivorcePaid, this.messagePriestDivorceNotEnough)) {
            event.setCancelled(true);
        }
    }

    private boolean billMarryOrDivorce(MarriagePlayer player1, MarriagePlayer player2, CommandSender priest, double cost, Message success, Message failPriest) {
        boolean failedPlayer2 = false;
        if (this.hasPlayerEnoughMoney(player1, cost) && this.hasPlayerEnoughMoney(player2, cost) && this.billPlayer(player1, cost)) {
            if (this.billPlayer(player2, cost)) {
                player1.send(success, cost, this.econ.getBalance((OfflinePlayer)player1.getPlayer()), this.econ.currencyNamePlural());
                player2.send(success, cost, this.econ.getBalance((OfflinePlayer)player2.getPlayer()), this.econ.currencyNamePlural());
                return true;
            }
            this.econ.depositPlayer((OfflinePlayer)player1.getPlayer(), cost);
            failedPlayer2 = true;
        }
        if (!this.hasPlayerEnoughMoney(player2, cost) || failedPlayer2) {
            player1.send(this.messagePartnerNotEnough, new Object[0]);
            player2.send(this.messageNotEnough, cost, this.econ.currencyNamePlural());
        } else {
            player2.send(this.messagePartnerNotEnough, new Object[0]);
            player1.send(this.messageNotEnough, cost, this.econ.currencyNamePlural());
        }
        if (priest != null) {
            failPriest.send(priest, new Object[0]);
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(TPEvent event) {
        if (this.costTp <= 0.0) {
            return;
        }
        if (!this.basicBillPlayer(event.getPlayer(), this.costTp, this.messageTpPaid)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onGift(GiftEvent event) {
        if (this.costGift <= 0.0) {
            return;
        }
        if (!this.basicBillPlayer(event.getPlayer(), this.costGift, this.messageGiftPaid)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHome(HomeTPEvent event) {
        if (this.costHome <= 0.0) {
            return;
        }
        if (!this.basicBillPlayer(event.getPlayer(), this.costHome, this.messageHomePaid)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSetHome(HomeSetEvent event) {
        if (this.costSetHome <= 0.0) {
            return;
        }
        if (!this.basicBillPlayer(event.getPlayer(), this.costSetHome, this.messageSetHomePaid)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChangeSurname(SurnameChangeEvent event) {
        if (this.costChangeSurname <= 0.0 || !(event.getChangedBy() instanceof Player)) {
            return;
        }
        if (!this.basicBillPlayer(this.plugin.getPlayerData((OfflinePlayer)((Player)event.getChangedBy())), this.costChangeSurname, this.messageSurnameChangePaid)) {
            event.setCancelled(true);
        }
    }
}

