/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Listener;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.DivorcedEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.MarriedEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.Config;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import java.util.Collection;
import java.util.LinkedList;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class CommandExecutor
implements Listener {
    private final MarriageMaster plugin;
    private final Collection<String> commandsOnMarry;
    private final Collection<String> commandsOnMarryWithPriest;
    private final Collection<String> commandsOnDivorce;
    private final Collection<String> commandsOnDivorceWithPriest;

    public CommandExecutor(MarriageMaster plugin) {
        this.plugin = plugin;
        this.commandsOnMarry = new LinkedList<String>();
        this.commandsOnMarryWithPriest = new LinkedList<String>();
        this.commandsOnDivorce = new LinkedList<String>();
        this.commandsOnDivorceWithPriest = new LinkedList<String>();
        Config config = plugin.getConfiguration();
        config.getCommandExecutorOnMarry().forEach(command -> this.commandsOnMarry.add(command.replace("{Player1}", "%1$s").replace("{Player2}", "%2$s")));
        config.getCommandExecutorOnMarryWithPriest().forEach(command -> this.commandsOnMarryWithPriest.add(command.replace("{Player1}", "%1$s").replace("{Player2}", "%2$s").replace("{Priest}", "%3$s")));
        config.getCommandExecutorOnDivorce().forEach(command -> this.commandsOnDivorce.add(command.replace("{Player1}", "%1$s").replace("{Player2}", "%2$s")));
        config.getCommandExecutorOnDivorceWithPriest().forEach(command -> this.commandsOnDivorceWithPriest.add(command.replace("{Player1}", "%1$s").replace("{Player2}", "%2$s").replace("{Priest}", "%3$s")));
    }

    @EventHandler
    public void onMarry(MarriedEvent event) {
        Marriage marriage = event.getMarriageData();
        if (marriage.getPriest() == null || ((MarriagePlayer)marriage.getPriest()).equals(marriage.getPartner1()) || ((MarriagePlayer)marriage.getPriest()).equals(marriage.getPartner2())) {
            for (String command : this.commandsOnMarry) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), String.format(command, ((MarriagePlayer)marriage.getPartner1()).getName(), ((MarriagePlayer)marriage.getPartner2()).getName()));
            }
        } else {
            for (String command : this.commandsOnMarryWithPriest) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), String.format(command, ((MarriagePlayer)marriage.getPartner1()).getName(), ((MarriagePlayer)marriage.getPartner2()).getName(), ((MarriagePlayer)marriage.getPriest()).getName()));
            }
        }
    }

    @EventHandler
    public void onDivorce(DivorcedEvent event) {
        if (event.getPriest() == null) {
            for (String command : this.commandsOnDivorce) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), String.format(command, event.getPlayer1().getName(), event.getPlayer2().getName()));
            }
        } else {
            for (String command : this.commandsOnDivorceWithPriest) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), String.format(command, event.getPlayer1().getName(), event.getPlayer2().getName(), event.getPriest().getName()));
            }
        }
    }
}

