/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Listener;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Formatter.IMarriageAndPartnerFormatter;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Formatter.PrefixSuffixFormatterImpl;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.Message.MessageColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.jetbrains.annotations.NotNull;

public class ChatPrefixSuffix
implements Listener {
    private static final String HEART = "\u2764" + MessageColor.WHITE;
    private static final String HEART_GRAY = MessageColor.GRAY + HEART + " ";
    private static final String STATUS_HEART_NM = HEART_GRAY + "%1$s";
    private final MarriageMaster plugin;
    private final IMarriageAndPartnerFormatter prefixFormatter;
    private final IMarriageAndPartnerFormatter suffixFormatter;
    private final boolean useStatusHeartPrefix;
    private final boolean useStatusHeartSuffix;
    private final boolean prefixOnLineBeginning;

    public ChatPrefixSuffix(@NotNull MarriageMaster plugin) {
        String suffix;
        this.plugin = plugin;
        if (plugin.getConfiguration().isPrefixEnabled()) {
            String prefix = plugin.getConfiguration().getPrefix();
            this.useStatusHeartPrefix = prefix.contains("{StatusHeart}");
            this.prefixFormatter = PrefixSuffixFormatterImpl.produceFormatter(prefix.isEmpty() ? "" : prefix + " ");
            this.prefixOnLineBeginning = plugin.getConfiguration().isPrefixOnLineBeginning();
        } else {
            this.prefixFormatter = PrefixSuffixFormatterImpl.produceFormatter("");
            this.useStatusHeartPrefix = false;
            this.prefixOnLineBeginning = false;
        }
        String string = suffix = plugin.getConfiguration().isSuffixEnabled() ? plugin.getConfiguration().getSuffix() : "";
        if (!suffix.isEmpty()) {
            suffix = " " + suffix;
        }
        this.useStatusHeartSuffix = suffix.contains("{StatusHeart}");
        this.suffixFormatter = PrefixSuffixFormatterImpl.produceFormatter(suffix);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String format = event.getFormat();
        boolean changed = false;
        MarriagePlayer player = this.plugin.getPlayerData((OfflinePlayer)event.getPlayer());
        if (player.isMarried()) {
            Marriage marriage = (Marriage)player.getMarriageData();
            MarriagePlayer partner = (MarriagePlayer)marriage.getPartner(player);
            String p = this.prefixFormatter.format(marriage, partner);
            String s = this.suffixFormatter.format(marriage, partner);
            if (p.length() == 1) {
                p = "";
            }
            if (s.length() == 1) {
                s = "";
            }
            boolean bl = changed = !p.isEmpty() || !s.isEmpty();
            format = this.prefixOnLineBeginning ? p + format.replace("%1$s", "%1$s" + s) : format.replace("%1$s", p + "%1$s" + s);
        } else {
            if (this.useStatusHeartPrefix) {
                format = this.prefixOnLineBeginning ? HEART_GRAY + format : format.replace("%1$s", STATUS_HEART_NM);
                changed = true;
            }
            if (this.useStatusHeartSuffix) {
                format = this.prefixOnLineBeginning ? HEART_GRAY + format : format.replace("%1$s", "%1$s " + HEART_GRAY);
                changed = true;
            }
        }
        if (changed) {
            event.setFormat(format);
        }
    }
}

