/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Listener.BonusXP;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Listener.BonusXP.IBonusXpCalculator;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Listener.BonusXP.IBonusXpListener;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Range;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class NearestPartnerBonusXpCalculator<EVENT, XP_TYPE>
implements IBonusXpCalculator<EVENT, XP_TYPE> {
    private final MarriageMaster plugin;
    private final double range;
    private final double multiplier;
    private final boolean split;
    private final IBonusXpListener<EVENT, XP_TYPE> eventListener;

    protected NearestPartnerBonusXpCalculator(MarriageMaster plugin, double multiplier, boolean split, IBonusXpListener<EVENT, XP_TYPE> eventListener) {
        this.plugin = plugin;
        this.split = split;
        this.multiplier = multiplier * (double)(split ? 0.5f : 1.0f);
        this.eventListener = eventListener;
        this.range = plugin.getConfiguration().getRangeSquared(Range.BonusXP);
    }

    @Override
    public void process(EVENT event, Player eventPlayer, double xp, XP_TYPE xpType) {
        MarriagePlayer partner;
        MarriagePlayer player = this.plugin.getPlayerData((OfflinePlayer)eventPlayer);
        Marriage marriage = player.getNearestPartnerMarriageData();
        if (marriage != null && (partner = (MarriagePlayer)marriage.getPartner(player)) != null && partner.isOnline() && marriage.inRangeSquared(this.range)) {
            this.eventListener.setEventExp(event, xp *= this.multiplier, xpType, player, marriage);
            if (this.split) {
                this.eventListener.splitWithPartner(event, (Player)partner.getPlayerOnline(), xp, xpType, player, marriage);
            }
        }
    }
}

