/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Listener.BonusXP;

import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Listener.BonusXP.IBonusXpCalculator;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Listener.BonusXP.IBonusXpListener;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Range;
import java.util.ArrayList;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class AllPartnersInRangeBonusXpCalculator<EVENT, XP_TYPE>
implements IBonusXpCalculator<EVENT, XP_TYPE> {
    private final MarriageMaster plugin;
    private final double range;
    private final double multiplier;
    private final IBonusXpListener<EVENT, XP_TYPE> eventListener;

    protected AllPartnersInRangeBonusXpCalculator(MarriageMaster plugin, double multiplier, IBonusXpListener<EVENT, XP_TYPE> eventListener) {
        this.plugin = plugin;
        this.multiplier = multiplier;
        this.eventListener = eventListener;
        this.range = plugin.getConfiguration().getRangeSquared(Range.BonusXP);
    }

    @Override
    public void process(EVENT event, Player eventPlayer, double xp, XP_TYPE xpType) {
        MarriagePlayer player = this.plugin.getPlayerData((OfflinePlayer)eventPlayer);
        ArrayList<Marriage> marriages = new ArrayList<Marriage>();
        for (Marriage marriage : player.getMultiMarriageData()) {
            if (!marriage.inRange(this.range)) continue;
            marriages.add(marriage);
        }
        if (!marriages.isEmpty()) {
            this.eventListener.setEventExp(event, xp *= this.multiplier / (double)(marriages.size() + 1), xpType, player, (Marriage)marriages.get(0));
            for (Marriage marriage : marriages) {
                this.eventListener.splitWithPartner(event, (Player)((MarriagePlayer)marriage.getPartner(player)).getPlayerOnline(), xp, xpType, player, marriage);
            }
        }
    }
}

