/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Database;

import at.pcgamingfreaks.Bukkit.Message.IMessage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Home;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.HugCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.KissCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.Message.MessageComponent;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarriagePlayerData
extends MarriagePlayerDataBase<MarriagePlayer, CommandSender, Home, Marriage, OfflinePlayer, Player, IMessage>
implements MarriagePlayer {
    private AcceptPendingRequest openRequest = null;
    private final List<AcceptPendingRequest> canCloseRequests = new LinkedList<AcceptPendingRequest>();
    private BukkitTask delayedTpTask = null;
    private long lastKissTime = 0L;
    private long lastHugTime = 0L;

    public MarriagePlayerData(@NotNull OfflinePlayer player) {
        super(player.getUniqueId(), player.getName() != null ? player.getName() : "Unknown");
    }

    public MarriagePlayerData(@Nullable UUID uuid, @NotNull String name, boolean sharesBackpack, boolean priest, @Nullable Object databaseKey) {
        super(uuid, name, priest, sharesBackpack, databaseKey);
    }

    public void addRequest(AcceptPendingRequest request) {
        if (((MarriagePlayer)request.getPlayerThatHasToAccept()).equals(this)) {
            this.openRequest = request;
        }
        for (MarriagePlayer p : (MarriagePlayer[])request.getPlayersThatCanCancel()) {
            if (!this.equals(p)) continue;
            this.canCloseRequests.add(request);
            break;
        }
    }

    public void closeRequest(AcceptPendingRequest request) {
        if (this.getOpenRequest() != null && this.getOpenRequest().equals(request)) {
            this.openRequest = null;
        }
        this.getRequestsToCancel().removeIf(acceptPendingRequest -> acceptPendingRequest.equals(request));
    }

    @Override
    @Nullable
    public String getOnlineName() {
        Player bPlayer = this.getPlayerOnline();
        return bPlayer != null ? bPlayer.getName() : null;
    }

    @Override
    @NotNull
    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.getUUID());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        Player bukkitPlayer = this.getPlayerOnline();
        return bukkitPlayer != null ? bukkitPlayer.getDisplayName() : this.getOfflineDisplayName();
    }

    @Override
    @NotNull
    public String getDisplayNameCheckVanished(@NotNull Player player) {
        Player bukkitPlayer = this.getPlayerOnline();
        return bukkitPlayer != null && player.canSee(bukkitPlayer) ? bukkitPlayer.getDisplayName() : this.getOfflineDisplayName();
    }

    @NotNull
    public MessageComponent getDisplayNameMessageComponentCheckVanished(@NotNull CommandSender checkFor) {
        if (!(checkFor instanceof Player)) {
            return this.getDisplayNameMessageComponent();
        }
        Player player = this.getPlayerOnline();
        return player != null && ((Player)checkFor).canSee(player) ? this.getDisplayNameMessageComponent() : this.offlineDisplayNameMessageComponent;
    }

    @Override
    public void kiss(MarriagePlayer partner) {
        if (((MarriagePlayerDataBase)this).isPartner(partner)) {
            KissCommand.getInstance().kiss(this, partner);
        }
    }

    @Override
    public void hug(MarriagePlayer partner) {
        if (((MarriagePlayerDataBase)this).isPartner(partner)) {
            HugCommand.getInstance().hug(this, partner);
        }
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        Player bukkitPlayer = this.getPlayerOnline();
        return bukkitPlayer != null && bukkitPlayer.hasPermission(permission);
    }

    @Override
    public boolean isOnline() {
        return this.getPlayerOnline() != null;
    }

    @Override
    public boolean canSee(@NotNull Player player) {
        Player onlinePlayer = this.getPlayerOnline();
        if (onlinePlayer == null) {
            return true;
        }
        return onlinePlayer.canSee(player);
    }

    public long getLastPlayed() {
        return this.getPlayer().getLastPlayed();
    }

    @Override
    public AcceptPendingRequest getOpenRequest() {
        return this.openRequest;
    }

    @Override
    @NotNull
    public List<AcceptPendingRequest> getRequestsToCancel() {
        return this.canCloseRequests;
    }

    @Override
    @Nullable
    public Player getPlayerOnline() {
        return Bukkit.getPlayer((UUID)this.getUUID());
    }

    @Override
    public boolean isPartner(@NotNull OfflinePlayer player) {
        return ((MarriagePlayerDataBase)this).isPartner(MarriageMaster.getInstance().getPlayerData(player));
    }

    @Override
    public Marriage getNearestPartnerMarriageData() {
        Marriage nearest = null;
        double distanceNearest = -1.0;
        for (Marriage marriage : this.getMultiMarriageData()) {
            double dist = marriage.getDistance();
            if (!(dist > 0.0 && dist < distanceNearest) && distanceNearest != -1.0) continue;
            distanceNearest = dist;
            nearest = marriage;
        }
        return nearest;
    }

    @Override
    @Nullable
    public MarriagePlayer getNearestPartner() {
        Marriage nearest = this.getNearestPartnerMarriage();
        if (nearest == null) {
            return null;
        }
        return (MarriagePlayer)nearest.getPartner(this);
    }

    @Override
    public void send(@NotNull IMessage message, Object ... args) {
        this.sendMessage(message, args);
    }

    @Override
    public void sendMessage(@NotNull IMessage message, Object ... args) {
        if (!this.isOnline()) {
            return;
        }
        message.send((Object)this.getPlayerOnline(), args);
    }

    public BukkitTask getDelayedTpTask() {
        return this.delayedTpTask;
    }

    public void setDelayedTpTask(BukkitTask delayedTpTask) {
        this.delayedTpTask = delayedTpTask;
    }

    @Override
    public long getLastKissTime() {
        return this.lastKissTime;
    }

    @Override
    public long getLastHugTime() {
        return this.lastHugTime;
    }

    @Override
    public void setLastKissTime(long lastKissTime) {
        this.lastKissTime = lastKissTime;
    }

    @Override
    public void setLastHugTime(long lastHugTime) {
        this.lastHugTime = lastHugTime;
    }
}

