/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Database;

import at.pcgamingfreaks.Bukkit.Util.Utils;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Home;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Database.MarriageDataBase;
import at.pcgamingfreaks.Message.MessageColor;
import java.util.Date;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarriageData
extends MarriageDataBase<MarriagePlayer, CommandSender, Home>
implements Marriage {
    public MarriageData(@NotNull MarriagePlayer player1, @NotNull MarriagePlayer player2, @Nullable MarriagePlayer priest, @NotNull Date weddingDate, @Nullable String surname, boolean pvpEnabled, @Nullable MessageColor color, @Nullable Home home, @Nullable Object databaseKey) {
        super(player1, player2, priest, weddingDate, surname, pvpEnabled, color, home, databaseKey);
    }

    public MarriageData(@NotNull MarriagePlayer player1, @NotNull MarriagePlayer player2, @Nullable MarriagePlayer priest, @NotNull Date weddingDate, @Nullable String surname) {
        super(player1, player2, priest, weddingDate, surname);
    }

    public MarriageData(@NotNull MarriagePlayer player1, @NotNull MarriagePlayer player2, @Nullable MarriagePlayer priest, @Nullable String surname) {
        super(player1, player2, priest, surname);
    }

    @Override
    public boolean setSurname(String surname) {
        surname = MarriageMaster.getInstance().getMarriageManager().cleanupSurname(surname);
        if (surname == null || MarriageMaster.getInstance().getMarriageManager().isSurnameValid(surname)) {
            String oldSurname = this.getSurname();
            this.surname = surname;
            MarriageMaster.getInstance().getDatabase().cachedSurnameUpdate(this, oldSurname);
            return true;
        }
        return false;
    }

    @Override
    public void setSurname(String surname, @NotNull CommandSender changer) {
        MarriageMaster.getInstance().getMarriageManager().setSurname(this, surname, changer);
    }

    @Override
    public void setSurname(String surname, @NotNull MarriagePlayer changer) {
        this.setSurname(surname, (CommandSender)changer.getPlayerOnline());
    }

    @Override
    public void divorce(@NotNull CommandSender divorcedBy) {
        MarriageMaster.getInstance().getMarriageManager().divorce(this, divorcedBy);
    }

    @Override
    public void divorce(@NotNull MarriagePlayer divorcedBy) {
        MarriageMaster.getInstance().getMarriageManager().divorce(this, divorcedBy);
    }

    @Override
    public double getDistance() {
        return this.isBothOnline() ? Utils.getDistance((Player)((Player)((MarriagePlayer)this.getPartner1()).getPlayerOnline()), (Player)((Player)((MarriagePlayer)this.getPartner2()).getPlayerOnline())) : Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean inRange(double maxDistance) {
        return this.isBothOnline() && MarriageMaster.getInstance().isInRange((Player)((MarriagePlayer)this.getPartner1()).getPlayerOnline(), (Player)((MarriagePlayer)this.getPartner2()).getPlayerOnline(), maxDistance);
    }

    @Override
    public boolean inRangeSquared(double maxDistanceSquared) {
        return this.isBothOnline() && MarriageMaster.getInstance().isInRangeSquared((Player)((MarriagePlayer)this.getPartner1()).getPlayerOnline(), (Player)((MarriagePlayer)this.getPartner2()).getPlayerOnline(), maxDistanceSquared);
    }

    @Override
    @Deprecated
    @NotNull
    public ChatColor getMarriageColor() {
        return ChatColor.getByChar((char)this.getColor().getCode());
    }

    @Override
    @Deprecated
    public void setMarriageColor(@NotNull ChatColor color) {
        this.setColor(MessageColor.getFromCode((char)color.getChar()));
    }
}

